/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.components.titulos.impl;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorEntSaida;
import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.lancamentogerencial.EnumLancamentoCTBGerencial;
import com.touchcomp.basementor.constants.enums.lancamentogerencial.EnumProvisionamentoLancamentoCTBGerencial;
import com.touchcomp.basementor.constants.enums.lancamentogerencial.EnumTipoLancamentoCTBGerencial;
import com.touchcomp.basementor.constants.enums.modelorps.EnumConstStatusRPS;
import com.touchcomp.basementor.constants.enums.opcoeslocacao.EnumGerTituloApuracao;
import com.touchcomp.basementor.constants.enums.pessoa.EnumConstPessoa;
import com.touchcomp.basementor.constants.enums.provisao.EnumConstProvisao;
import com.touchcomp.basementor.constants.enums.titulo.EnumConstTipoTitulo;
import com.touchcomp.basementor.model.vo.ApuracaoLocacaoContratoBem;
import com.touchcomp.basementor.model.vo.MeioPagamento;
import com.touchcomp.basementor.model.vo.OpcoesFaturamentoNFSe;
import com.touchcomp.basementor.model.vo.OpcoesFinanceiras;
import com.touchcomp.basementor.model.vo.OpcoesLocacao;
import com.touchcomp.basementor.model.vo.PlanoConta;
import com.touchcomp.basementor.model.vo.RepresentanteContratoComissao;
import com.touchcomp.basementor.model.vo.Rps;
import com.touchcomp.basementor.model.vo.Titulo;
import com.touchcomp.basementor.model.vo.TituloRepresentante;
import com.touchcomp.basementorexceptions.exceptions.impl.titulo.EnumExcepTitulo;
import com.touchcomp.basementorexceptions.exceptions.impl.titulo.ExceptionTitulo;
import com.touchcomp.basementorexceptions.exceptions.impl.validacaodados.ExceptionValidacaoDados;
import com.touchcomp.basementorservice.components.titulos.BaseTitulo;
import com.touchcomp.basementorservice.helpers.impl.lancamentoctbgerencial.HelperLancamentoCtbGerencial;
import com.touchcomp.basementorservice.helpers.impl.opcoes.opcoesfinanceiras.HelperOpcoesFinanceiras;
import com.touchcomp.basementorspringcontext.ConfApplicationContext;
import com.touchcomp.basementortools.tools.formatter.ToolFormatter;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.basementorvalidator.entities.impl.titulo.ValidTitulo;
import java.util.ArrayList;
import java.util.Collection;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CompTitulosRps
extends BaseTitulo<Titulo> {
    @Autowired
    ValidTitulo validTitulo;
    HelperOpcoesFinanceiras helperOpcoesFinanceiras;
    HelperLancamentoCtbGerencial helperLancamentoCtbGerencial;

    public CompTitulosRps(ValidTitulo validTitulo, HelperOpcoesFinanceiras helperOpcoesFinanceiras, HelperLancamentoCtbGerencial helperLancamentoCtbGerencial) {
        this.validTitulo = validTitulo;
        this.helperOpcoesFinanceiras = helperOpcoesFinanceiras;
        this.helperLancamentoCtbGerencial = helperLancamentoCtbGerencial;
    }

    public void criarTitulos(Rps rps, OpcoesFinanceiras opcoesFinanceiras, OpcoesFaturamentoNFSe opcoesFatNfse, OpcoesLocacao opcoesLocacao) throws ExceptionTitulo, ExceptionValidacaoDados {
        if (TMethods.isNotNull((Object)rps).booleanValue() && (TMethods.isNotNull((Object)rps.getGrupoApuracaoLocacao()).booleanValue() || TMethods.isNotNull((Object)rps.getApuracaoContratoLocacao()).booleanValue())) {
            return;
        }
        if (!TMethods.isAffirmative((Number)rps.getGerarFinanceiro()) || TMethods.isNull((Object)rps.getCondicoesPagamento()).booleanValue()) {
            return;
        }
        if (TMethods.isWithData((Collection)rps.getTitulos()) && TMethods.isEquals((Object)this.validarParcelas(rps), (Object)EnumConstantsMentorSimNao.NAO)) {
            return;
        }
        if (!TMethods.isWithData((Collection)rps.getTitulos())) {
            PlanoConta planoConta;
            EnumConstTipoTitulo tipoTitulo;
            if (TMethods.isEquals((Object)rps.getEntradaSaida(), (Object)EnumConstantsMentorEntSaida.ENTRADA.getValue())) {
                tipoTitulo = EnumConstTipoTitulo.PAGAMENTO;
                planoConta = rps.getUnidadeTomPrestRPS().getTomadorPrestadorRPS().getPlanoContaFornecedor();
            } else {
                tipoTitulo = EnumConstTipoTitulo.RECEBIMENTO;
                planoConta = rps.getUnidadeTomPrestRPS().getTomadorPrestadorRPS().getPlanoContaCliente();
            }
            List<Titulo> titulos = this.buildTitulos(rps, planoConta, tipoTitulo, opcoesFinanceiras);
            if (TMethods.isNotNull((Object)opcoesLocacao).booleanValue() && TMethods.isEquals((Object)opcoesLocacao.getTipoCentroCustoLancGerencial(), (Object)EnumGerTituloApuracao.CENTRO_CUSTO_ATIVO.getValue()) && TMethods.isNotNull((Object)rps.getApuracaoContratoLocacao()).booleanValue() && TMethods.isNotNull((Object)rps.getApuracaoContratoLocacao().getContratoLocacao()).booleanValue()) {
                this.gerarLancamentosApuracaoContratoLocacao(rps, titulos, opcoesFinanceiras);
            } else {
                this.gerarLancamentosServicos(rps, titulos, opcoesFinanceiras);
            }
            rps.setTitulos(titulos);
            this.validarTitulos(rps);
        } else {
            this.validarTitulos(rps);
        }
        if (TMethods.isWithData((Collection)rps.getTitulos())) {
            Double percBCComissaoRep = opcoesFatNfse.getPercBCComissaoRepresentante();
            rps.setTitulos(this.buildTitulosRepresentantes(rps.getRepresentantes(), rps.getTitulos(), percBCComissaoRep));
        }
    }

    private void gerarLancamentosServicos(Rps rps, List<Titulo> titulos, OpcoesFinanceiras opcoesFinanceiras) {
        for (Titulo t : titulos) {
            t.setRps(rps);
            t.setTipoDoc(opcoesFinanceiras.getTipoDocFinanceiro());
            t.setCarteiraCobranca(this.helperOpcoesFinanceiras.build(opcoesFinanceiras).getCarteiraCobranca(t.getPagRec()));
            t.getLancCtbGerencial().add(this.helperLancamentoCtbGerencial.newLancamentoCtbGerencial(null, t.getDataEmissao(), t.getDataVencimento(), EnumLancamentoCTBGerencial.CREDITO.getValue(), t.getEmpresa(), EnumConstantsMentorSimNao.NAO.getValue(), t.getObservacao(), rps.getServicoRPS().getPlanoContaGerencial(), EnumProvisionamentoLancamentoCTBGerencial.REALIZADO.getValue(), EnumTipoLancamentoCTBGerencial.COMPETENCIA.getValue(), rps.getServicoRPS().getCentroCusto(), t.getValor(), null));
        }
    }

    private void gerarLancamentosApuracaoContratoLocacao(Rps rps, List<Titulo> titulos, OpcoesFinanceiras opcoesFinanceiras) {
        Double valorApurContratos = 0.0;
        for (ApuracaoLocacaoContratoBem a : rps.getApuracaoContratoLocacao().getApuracaoLocacaoContratoBem()) {
            valorApurContratos = valorApurContratos + a.getValorTotal();
        }
        Double perc = 0.0;
        if (valorApurContratos > 0.0) {
            perc = ToolFormatter.arrredondarNumero((Double)(rps.getValorLiquidoNfse() * 100.0 / valorApurContratos), (int)4);
        }
        for (Titulo t : titulos) {
            Double valorAcumLanc = 0.0;
            t.setRps(rps);
            t.setTipoDoc(opcoesFinanceiras.getTipoDocFinanceiro());
            t.setCarteiraCobranca(this.helperOpcoesFinanceiras.build(opcoesFinanceiras).getCarteiraCobranca(t.getPagRec()));
            int qtdeBens = rps.getApuracaoContratoLocacao().getApuracaoLocacaoContratoBem().size();
            int qtdeAux = 0;
            for (ApuracaoLocacaoContratoBem a : rps.getApuracaoContratoLocacao().getApuracaoLocacaoContratoBem()) {
                Double valor = ToolFormatter.arrredondarNumero((Double)(a.getValorTotal() * perc / 100.0 / (double)titulos.size()), (int)2);
                if (++qtdeAux == qtdeBens) {
                    Double diferenca = valor + valorAcumLanc - t.getValor();
                    valor = valor - diferenca;
                }
                t.getLancCtbGerencial().add(this.helperLancamentoCtbGerencial.newLancamentoCtbGerencial(null, t.getDataEmissao(), t.getDataVencimento(), EnumLancamentoCTBGerencial.CREDITO.getValue(), t.getEmpresa(), EnumConstantsMentorSimNao.NAO.getValue(), t.getObservacao(), a.getContratoLocacaoBem().getAtivo().getContaGerencial(), EnumProvisionamentoLancamentoCTBGerencial.REALIZADO.getValue(), EnumTipoLancamentoCTBGerencial.COMPETENCIA.getValue(), a.getContratoLocacaoBem().getAtivo().getCentroCusto(), valor, null));
                valorAcumLanc = valorAcumLanc + valor;
            }
        }
    }

    private List<Titulo> buildTitulos(Rps rps, PlanoConta planoConta, EnumConstTipoTitulo tipoTitulo, OpcoesFinanceiras opcoesFinanceiras) throws ExceptionTitulo {
        if (TMethods.isAffirmative((Number)rps.getCondicoesPagamento().getCondMutante())) {
            return this.getTitulosMutanteInternal(rps.getCondicoesPagamento(), rps.getUnidadeTomPrestRPS().getTomadorPrestadorRPS().getPessoa(), rps.getValorLiquidoNfse(), planoConta, 0.0, rps.getParcelas(), EnumConstPessoa.PESSOA.getEnumId(), tipoTitulo.getValue(), EnumConstProvisao.REALIZADO.getValue(), rps.getDataEmissao(), "RPS/NFSe: " + rps.getUnidadeTomPrestRPS().getTomadorPrestadorRPS().getPessoa().getNome(), rps.getDataEmissao(), rps.getDataEmissao(), rps.getDataCadastro(), rps.getDataEmissao(), rps.getEmpresa(), opcoesFinanceiras, this.getMeioPagamento(rps, opcoesFinanceiras), rps.getClassificacaoPessoas());
        }
        return this.getTitulosNaoMutanteInternal(rps.getCondicoesPagamento(), rps.getUnidadeTomPrestRPS().getTomadorPrestadorRPS().getPessoa(), rps.getValorLiquidoNfse(), planoConta, 0.0, EnumConstPessoa.PESSOA.getEnumId(), tipoTitulo.getValue(), EnumConstProvisao.REALIZADO.getValue(), rps.getDataEmissao(), "RPS/NFSe: " + rps.getUnidadeTomPrestRPS().getTomadorPrestadorRPS().getPessoa().getNome(), rps.getDataEmissao(), rps.getDataEmissao(), rps.getDataCadastro(), rps.getDataEmissao(), rps.getEmpresa(), opcoesFinanceiras, this.getMeioPagamento(rps, opcoesFinanceiras), rps.getClassificacaoPessoas());
    }

    private MeioPagamento getMeioPagamento(Rps rps, OpcoesFinanceiras opcoesFinanceiras) {
        MeioPagamento meio = rps.getMeioPagamento();
        if (TMethods.isNull((Object)meio).booleanValue() && TMethods.isNotNull((Object)rps.getCondicoesPagamento()).booleanValue() && TMethods.isNotNull((Object)rps.getCondicoesPagamento().getMeioPagamento()).booleanValue()) {
            meio = rps.getCondicoesPagamento().getMeioPagamento();
        }
        if (TMethods.isNull((Object)meio).booleanValue()) {
            meio = opcoesFinanceiras.getMeioPagamento();
        }
        return meio;
    }

    private EnumConstantsMentorSimNao validarParcelas(Rps vo) throws ExceptionTitulo {
        Double total = 0.0;
        if (!TMethods.isEquals((Object)vo.getStatus(), (Object)EnumConstStatusRPS.RPS_CANCELADO.getValue())) {
            Double vlrLiquido = ToolFormatter.arrredondarNumero((Double)vo.getValorLiquidoNfse(), (int)2);
            for (Titulo p : vo.getTitulos()) {
                total = total + p.getValor();
            }
            if (TMethods.isAffirmative((Number)vo.getGerarFinanceiro()) && Math.abs(ToolFormatter.arrredondarNumero((Double)(vlrLiquido - total), (int)2)) > 0.01) {
                throw new ExceptionTitulo(EnumExcepTitulo.DIFERENCA_VLR_TITULOS_VR_TOTAL_DOC, new Object[]{String.valueOf(vlrLiquido), String.valueOf(total), ToolFormatter.formataNumero((Number)(vlrLiquido - total), (int)2)});
            }
        } else {
            vo.getTitulos().clear();
            vo.setTitulos(new ArrayList());
        }
        return EnumConstantsMentorSimNao.SIM;
    }

    private void validarTitulos(Rps vo) throws ExceptionValidacaoDados {
        ValidTitulo v = (ValidTitulo)ConfApplicationContext.getBean(ValidTitulo.class);
        v.isValidData(vo.getTitulos());
        if (v.hasErrors()) {
            throw new ExceptionValidacaoDados(v.getContainer().asString(), new Object[0]);
        }
    }

    public List<Titulo> buildTitulosRepresentantes(List<RepresentanteContratoComissao> representanteContratoComissaos, List<Titulo> titulos, Double percBCComissaoRep) {
        if (TMethods.isWithData(representanteContratoComissaos)) {
            for (Titulo titulo : titulos) {
                titulo.getRepresentantes().addAll(this.gerarTitulosRepresentante(representanteContratoComissaos, titulo, titulo.getValor(), percBCComissaoRep));
            }
        }
        return titulos;
    }

    public List<TituloRepresentante> gerarTitulosRepresentante(List<RepresentanteContratoComissao> representantesComissao, Titulo t, Double valorBaseCalculo, Double percBCComissaoRep) {
        ArrayList<TituloRepresentante> titulosRepresentantes = new ArrayList<TituloRepresentante>();
        for (RepresentanteContratoComissao reprComissao : representantesComissao) {
            TituloRepresentante tituloRepr = new TituloRepresentante();
            tituloRepr.setRepresentante(reprComissao.getRepresentante());
            tituloRepr.setPercComissao(reprComissao.getPercentualComissao());
            tituloRepr.setTitulo(t);
            tituloRepr.setVrBCComissao(Double.valueOf(valorBaseCalculo * percBCComissaoRep / 100.0));
            titulosRepresentantes.add(tituloRepr);
        }
        return titulosRepresentantes;
    }
}

