/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.components.titulos.impl;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.lancamentogerencial.EnumLancamentoCTBGerencial;
import com.touchcomp.basementor.constants.enums.lancamentogerencial.EnumProvisionamentoLancamentoCTBGerencial;
import com.touchcomp.basementor.constants.enums.lancamentogerencial.EnumTipoLancamentoCTBGerencial;
import com.touchcomp.basementor.constants.enums.pessoa.EnumConstPessoa;
import com.touchcomp.basementor.constants.enums.titulo.EnumConstTituloPagRec;
import com.touchcomp.basementor.constants.enums.titulo.EnumConstTituloPagRecRel;
import com.touchcomp.basementor.constants.enums.titulo.EnumConstTituloProvReal;
import com.touchcomp.basementor.model.vo.AdiantamentoViagem;
import com.touchcomp.basementor.model.vo.CentroCusto;
import com.touchcomp.basementor.model.vo.FechamAdiantamentoViagem;
import com.touchcomp.basementor.model.vo.FechamentoAdiantamentoViagem;
import com.touchcomp.basementor.model.vo.LancamentoCtbGerencial;
import com.touchcomp.basementor.model.vo.OpcoesContabeis;
import com.touchcomp.basementor.model.vo.OpcoesFinanceiras;
import com.touchcomp.basementor.model.vo.OpcoesGerenciais;
import com.touchcomp.basementor.model.vo.PlanoConta;
import com.touchcomp.basementor.model.vo.PlanoContaGerencial;
import com.touchcomp.basementor.model.vo.Titulo;
import com.touchcomp.basementormessages.MessagesBaseMentor;
import com.touchcomp.basementorservice.components.titulos.BaseTitulo;
import com.touchcomp.basementorservice.helpers.impl.fechamentoadiantamentoviagem.HelperFechamentoAdiantamentoViagem;
import com.touchcomp.basementorservice.helpers.impl.lancamentoctbgerencial.HelperLancamentoCtbGerencial;
import com.touchcomp.basementortools.tools.methods.TMethods;
import java.util.Collection;
import java.util.LinkedList;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class GerarTitulosAdiantamentoViagem
extends BaseTitulo {
    @Autowired
    private HelperFechamentoAdiantamentoViagem helperFechamentoAdViagem;
    @Autowired
    private HelperLancamentoCtbGerencial helperLancamentoCtbGerencial;

    public void criarTitulos(AdiantamentoViagem vo, PlanoConta planoConta, PlanoContaGerencial planoContaGerencial, OpcoesGerenciais opcoesGerenciais, OpcoesFinanceiras opcoesFinanceiras) {
        String obs = MessagesBaseMentor.getMsg((String)"M.ERP.0478.001", (Object[])new Object[]{vo.getObservacao(), vo});
        Titulo titulo = this.newTitulo(vo.getPessoa(), planoConta, EnumConstPessoa.PESSOA.getEnumId(), EnumConstTituloPagRecRel.TIPO_TITULO_PAG.getEnumId(), EnumConstTituloProvReal.REALIZADO.getValue(), vo.getDataEmissao(), obs, vo.getDataEmissao(), vo.getDataEmissao(), vo.getDataEmissao(), vo.getEmpresa(), opcoesFinanceiras, vo.getValorAdiantamento(), opcoesFinanceiras.getMeioPagamento(), opcoesFinanceiras.getClassificacaoClientes());
        titulo.setCartCobrancaDestino(null);
        obs = MessagesBaseMentor.getMsg((String)"M.ERP.0478.002", (Object[])new Object[]{vo.getPessoa().getNome()});
        this.newAddLancamentoGerencial(titulo, planoContaGerencial, EnumLancamentoCTBGerencial.DEBITO, EnumTipoLancamentoCTBGerencial.COMPETENCIA, obs, titulo.getValor());
        ((LancamentoCtbGerencial)titulo.getLancCtbGerencial().getFirst()).setCentroCusto(opcoesGerenciais.getCentroCustoAdiantViagem());
        titulo.setAdiantamentoViagem(vo);
        vo.setTitulo(titulo);
    }

    public void criarTitulos(FechamentoAdiantamentoViagem vo, OpcoesGerenciais opcoesGerenciais, OpcoesFinanceiras opcoesFinanceiras, OpcoesContabeis opcoesContabeis) {
        Double valorTitulo = this.helperFechamentoAdViagem.build(vo).getValorAcerto();
        if (TMethods.isEquals((Object)valorTitulo, (Object)0.0)) {
            vo.setTituloFechamento(null);
        } else {
            EnumConstTituloPagRec pagRec;
            if (valorTitulo < 0.0) {
                valorTitulo = Math.abs(valorTitulo);
                pagRec = EnumConstTituloPagRec.TIPO_TITULO_PAG;
            } else {
                pagRec = EnumConstTituloPagRec.TIPO_TITULO_REC;
            }
            String obs = MessagesBaseMentor.getMsg((String)"M.ERP.2012.001", (Object[])new Object[]{vo.getAdiantamentoViagem().getObservacao()});
            Titulo titulo = this.newTitulo(vo.getAdiantamentoViagem().getPessoa(), opcoesContabeis.getPlanoContaAdViagem(), EnumConstPessoa.PESSOA.getEnumId(), pagRec.getValue(), EnumConstTituloProvReal.REALIZADO.getValue(), vo.getDataFechamento(), obs, vo.getDataFechamento(), vo.getDataFechamento(), vo.getDataFechamento(), vo.getEmpresa(), opcoesFinanceiras, valorTitulo, opcoesFinanceiras.getMeioPagamento(), opcoesFinanceiras.getClassificacaoClientes());
            vo.setTituloFechamento(titulo);
            titulo.setAdiantamentoViagemFechamento(vo);
        }
        this.gerarLancamentosFechamento(vo, opcoesGerenciais, opcoesContabeis, valorTitulo);
    }

    private void gerarLancamentosFechamento(FechamentoAdiantamentoViagem vo, OpcoesGerenciais opcoesGerenciais, OpcoesContabeis opcoesContabeis, Double valorTitulo) {
        if (TMethods.isWithData((Collection)vo.getDespesas()) && TMethods.isNotNull((Object)vo.getTituloFechamento()).booleanValue()) {
            LinkedList<FechamAdiantamentoViagem> despesasSemCentroCusto = new LinkedList<FechamAdiantamentoViagem>();
            LinkedList<FechamAdiantamentoViagem> despesasComCentroCusto = new LinkedList<FechamAdiantamentoViagem>();
            Double vrTotalDespesasSemCC = 0.0;
            for (FechamAdiantamentoViagem despesa : vo.getDespesas()) {
                if (TMethods.isNotNull((Object)despesa.getCentroCusto()).booleanValue()) {
                    despesasComCentroCusto.add(despesa);
                } else {
                    vrTotalDespesasSemCC = vrTotalDespesasSemCC + despesa.getVrDespesa();
                    despesasSemCentroCusto.add(despesa);
                }
                despesa.setLancamentoCtbGerencial(this.newLancamentoCtbGerDespesaAdViagem(vo, despesa));
            }
            if (!despesasComCentroCusto.isEmpty()) {
                vo.getTituloFechamento().getLancCtbGerencial().clear();
                vo.getTituloFechamento().getLancCtbGerencial().add(this.newLancamentoCtbGerAdiantamentoViagem(vo, vo.getTituloFechamento(), opcoesContabeis));
                for (FechamAdiantamentoViagem despesa : despesasComCentroCusto) {
                    vo.getTituloFechamento().getLancCtbGerencial().add(this.newLancamentoCtbGerDespesaTituloAdViagem(vo, despesa));
                }
                if (!despesasSemCentroCusto.isEmpty()) {
                    vo.getTituloFechamento().getLancCtbGerencial().add(this.newLancamentoCtbGerUnicoDespesasTituloAdViagem(vo, opcoesContabeis, vrTotalDespesasSemCC));
                }
            } else {
                this.newLancamentoCtbGerAdiantamentoViagem(vo, vo.getTituloFechamento(), opcoesGerenciais, opcoesContabeis, valorTitulo);
            }
        } else if (TMethods.isNotNull((Object)vo.getTituloFechamento()).booleanValue()) {
            this.newLancamentoCtbGerAdiantamentoViagem(vo, vo.getTituloFechamento(), opcoesGerenciais, opcoesContabeis, valorTitulo);
        }
    }

    private void newLancamentoCtbGerAdiantamentoViagem(FechamentoAdiantamentoViagem vo, Titulo t, OpcoesGerenciais opcoesGerenciais, OpcoesContabeis opcoesContabeis, Double valorAcerto) {
        CentroCusto centroCusto = vo.getAdiantamentoViagem().getCentroCusto();
        if (TMethods.isNotNull((Object)opcoesGerenciais).booleanValue() && TMethods.isNotNull((Object)opcoesGerenciais.getCentroCustoAdiantViagem()).booleanValue()) {
            centroCusto = opcoesGerenciais.getCentroCustoAdiantViagem();
        }
        LancamentoCtbGerencial l = this.helperLancamentoCtbGerencial.newLancamentoCtbGerencial(null, t.getDataCadastro(), t.getDataVencimento(), valorAcerto > 0.0 ? EnumLancamentoCTBGerencial.CREDITO.getValue() : EnumLancamentoCTBGerencial.DEBITO.getValue(), t.getEmpresa(), EnumConstantsMentorSimNao.SIM.getValue(), MessagesBaseMentor.getMsg((String)"M.ERP.2012.002", (Object[])new Object[]{t.getPessoa().getNome()}), opcoesContabeis.getPlanoContaGerAdViagem(), EnumConstTituloProvReal.REALIZADO.getValue(), EnumTipoLancamentoCTBGerencial.COMPETENCIA.getValue(), centroCusto, t.getValor(), null);
        t.getLancCtbGerencial().clear();
        t.getLancCtbGerencial().add(l);
    }

    private LancamentoCtbGerencial newLancamentoCtbGerAdiantamentoViagem(FechamentoAdiantamentoViagem vo, Titulo t, OpcoesContabeis opcoesContabeis) {
        return this.helperLancamentoCtbGerencial.newLancamentoCtbGerencial(null, t.getDataCadastro(), t.getDataVencimento(), EnumLancamentoCTBGerencial.CREDITO.getValue(), t.getEmpresa(), EnumConstantsMentorSimNao.SIM.getValue(), MessagesBaseMentor.getMsg((String)"M.ERP.2012.002", (Object[])new Object[]{t.getPessoa().getNome()}), opcoesContabeis.getPlanoContaGerAdViagem(), EnumConstTituloProvReal.REALIZADO.getValue(), EnumTipoLancamentoCTBGerencial.COMPETENCIA.getValue(), vo.getAdiantamentoViagem().getCentroCusto(), vo.getAdiantamentoViagem().getValorAdiantamento(), null);
    }

    private LancamentoCtbGerencial newLancamentoCtbGerDespesaTituloAdViagem(FechamentoAdiantamentoViagem vo, FechamAdiantamentoViagem despesa) {
        return this.helperLancamentoCtbGerencial.newLancamentoCtbGerencial(null, vo.getDataCadastro(), vo.getDataCadastro(), EnumLancamentoCTBGerencial.DEBITO.getValue(), vo.getEmpresa(), EnumConstantsMentorSimNao.SIM.getValue(), MessagesBaseMentor.getMsg((String)"M.ERP.2012.002", (Object[])new Object[]{vo.getTituloFechamento().getPessoa().getNome()}), despesa.getDespesaViagem().getPlanoContaGerencial(), EnumProvisionamentoLancamentoCTBGerencial.REALIZADO.getValue(), EnumTipoLancamentoCTBGerencial.COMPETENCIA.getValue(), despesa.getCentroCusto(), despesa.getVrDespesa(), null);
    }

    private LancamentoCtbGerencial newLancamentoCtbGerUnicoDespesasTituloAdViagem(FechamentoAdiantamentoViagem vo, OpcoesContabeis opcoesContabeis, Double vrTotalDespesas) {
        return this.helperLancamentoCtbGerencial.newLancamentoCtbGerencial(null, vo.getDataCadastro(), vo.getDataCadastro(), EnumLancamentoCTBGerencial.DEBITO.getValue(), vo.getEmpresa(), EnumConstantsMentorSimNao.SIM.getValue(), MessagesBaseMentor.getMsg((String)"M.ERP.2012.002", (Object[])new Object[]{vo.getTituloFechamento().getPessoa().getNome()}), opcoesContabeis.getPlanoContaGerAdViagem(), EnumProvisionamentoLancamentoCTBGerencial.REALIZADO.getValue(), EnumTipoLancamentoCTBGerencial.COMPETENCIA.getValue(), vo.getAdiantamentoViagem().getCentroCusto(), vrTotalDespesas, null);
    }

    private LancamentoCtbGerencial newLancamentoCtbGerDespesaAdViagem(FechamentoAdiantamentoViagem vo, FechamAdiantamentoViagem despesa) {
        return this.helperLancamentoCtbGerencial.newLancamentoCtbGerencial(despesa.getLancamentoCtbGerencial(), vo.getDataFechamento(), vo.getDataFechamento(), EnumLancamentoCTBGerencial.DEBITO.getValue(), vo.getEmpresa(), EnumConstantsMentorSimNao.SIM.getValue(), MessagesBaseMentor.getMsg((String)"M.ERP.2012.003", (Object[])new Object[]{String.valueOf(despesa.getVrDespesa()), String.valueOf(vo.getIdentificador())}), despesa.getDespesaViagem().getPlanoContaGerencial(), EnumProvisionamentoLancamentoCTBGerencial.REALIZADO.getValue(), EnumTipoLancamentoCTBGerencial.LIQUIDACAO.getValue(), despesa.getCentroCusto(), despesa.getVrDespesa(), null);
    }
}

