/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.components.titulos.impl;

import com.touchcomp.basementor.constants.enums.pedido.EnumConstGeracaoTitulosPreVendaPedido;
import com.touchcomp.basementor.constants.enums.pessoa.EnumConstPessoa;
import com.touchcomp.basementor.model.vo.CondicoesPagamento;
import com.touchcomp.basementor.model.vo.InfPagamentoPedido;
import com.touchcomp.basementor.model.vo.ItemPedido;
import com.touchcomp.basementor.model.vo.OpcoesContabeis;
import com.touchcomp.basementor.model.vo.OpcoesFinanceiras;
import com.touchcomp.basementor.model.vo.Pedido;
import com.touchcomp.basementor.model.vo.PlanoConta;
import com.touchcomp.basementor.model.vo.Representante;
import com.touchcomp.basementor.model.vo.Titulo;
import com.touchcomp.basementor.model.vo.TituloRepresentante;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorexceptions.exceptions.impl.titulo.ExceptionTitulo;
import com.touchcomp.basementorservice.components.lancamentoctbgerencial.CompGeracaoLancCtbGerencial;
import com.touchcomp.basementorservice.components.titulos.BaseTitulo;
import com.touchcomp.basementorservice.components.titulos.model.InfPagNF;
import com.touchcomp.basementorservice.service.impl.planoconta.SCompPlanoConta;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.formatter.ToolFormatter;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class GerarTitulosPedidos
extends BaseTitulo {
    @Autowired
    private SCompPlanoConta scPlanoConta;

    public void gerarTitulosPedPreVenda(Pedido vo, OpcoesFinanceiras opcoesFinanceiras, OpcoesContabeis opcoesContabeis) throws ExceptionTitulo, ExceptionInvalidData {
        Date dataBase = this.getDataBase(vo);
        InfPagNF inf = this.getValorTotal(vo);
        if (inf.getValorTotal() == 0.0) {
            return;
        }
        if (vo.getInfPagamentoPedido().isEmpty()) {
            vo.getInfPagamentoPedido().add(this.criarInfPagamentoPadrao(vo, opcoesFinanceiras));
        }
        for (InfPagamentoPedido infPag : vo.getInfPagamentoPedido()) {
            String parcelas = this.getParcelas(dataBase, infPag.getTitulos());
            infPag.setParcelas(parcelas);
            this.criarTitulos(infPag, vo, opcoesFinanceiras, opcoesContabeis);
        }
    }

    public void criarTitulos(Pedido vo, OpcoesFinanceiras op, OpcoesContabeis opcoesContabeis) throws ExceptionTitulo, ExceptionInvalidData {
        InfPagNF inf = this.getValorTotal(vo);
        if (inf.getValorTotal() == 0.0) {
            return;
        }
        if (vo.getInfPagamentoPedido().isEmpty()) {
            vo.getInfPagamentoPedido().add(this.criarInfPagamentoPadrao(vo, op));
        }
        for (InfPagamentoPedido infPagamentoPedido : vo.getInfPagamentoPedido()) {
            this.criarTitulos(infPagamentoPedido, vo, op, opcoesContabeis);
        }
    }

    public void criarTitulos(InfPagamentoPedido infPagamentoPedido, Pedido vo, OpcoesFinanceiras op, OpcoesContabeis opcoesContabeis) throws ExceptionTitulo, ExceptionInvalidData {
        Short provisao = vo.getSituacaoPedido().getGerarFinanceiroNFCe();
        if (ToolMethods.isEquals((Object)provisao, (Object)EnumConstGeracaoTitulosPreVendaPedido.NAO_GERAR_TITULOS.getValue())) {
            return;
        }
        Double valorTotalNota = infPagamentoPedido.getValorLiquido();
        Date dataBase = vo.getDataPrevisaoSaida();
        if (vo.getTipoDataTitulo() != null && vo.getTipoDataTitulo() == 0) {
            dataBase = vo.getDataEmissao();
        }
        String obs = "Pedido: " + vo.getUnidadeFatCliente().getCliente().getPessoa().getNome();
        List<Titulo> titulos = null;
        PlanoConta planoContaCliente = this.scPlanoConta.getPlanoConta(vo.getUnidadeFatCliente().getCliente(), opcoesContabeis);
        titulos = ToolMethods.isAffirmative((Number)infPagamentoPedido.getCondicoesPagamento().getCondMutante()) ? this.getTitulosMutanteInternal(infPagamentoPedido.getCondicoesPagamento(), vo.getUnidadeFatCliente().getCliente().getPessoa(), valorTotalNota, planoContaCliente, vo.getPercComissao(), infPagamentoPedido.getParcelas(), EnumConstPessoa.CLIENTE.getEnumId(), (short)1, provisao, dataBase, obs, vo.getDataEmissao(), vo.getDataEmissao(), vo.getDataCadastro(), vo.getDataEmissao(), vo.getEmpresa(), op, infPagamentoPedido.getMeioPagamento(), vo.getUnidadeFatCliente().getCliente().getClassificacaoClientes()) : this.getTitulosNaoMutanteInternal(infPagamentoPedido.getCondicoesPagamento(), vo.getUnidadeFatCliente().getCliente().getPessoa(), valorTotalNota, planoContaCliente, vo.getPercComissao(), EnumConstPessoa.CLIENTE.getEnumId(), (short)1, provisao, dataBase, obs, vo.getDataEmissao(), vo.getDataEmissao(), vo.getDataCadastro(), vo.getDataEmissao(), vo.getEmpresa(), op, infPagamentoPedido.getMeioPagamento(), vo.getUnidadeFatCliente().getCliente().getClassificacaoClientes());
        for (Titulo t : titulos) {
            t.setInfPagamentoPedido(infPagamentoPedido);
        }
        if (infPagamentoPedido.getTitulos() != null) {
            infPagamentoPedido.getTitulos().clear();
            infPagamentoPedido.getTitulos().addAll(titulos);
        } else {
            infPagamentoPedido.setTitulos(titulos);
        }
        CompGeracaoLancCtbGerencial.criarSetarLancamentosCTBGerencial(vo, titulos, op.getEmpresa());
        this.calculaBCComissaoRepresentante(titulos, vo);
    }

    public HashMap getValorTotalItemPedido(List itens, double percDescFinance) {
        HashMap<String, Double> h = new HashMap<String, Double>();
        Double valor = 0.0;
        Double valorIcmsSt = 0.0;
        Double valorParaBCComissaoTitulo = 0.0;
        for (Object o : itens) {
            ItemPedido i = (ItemPedido)o;
            if (i.getModeloFiscal().getGerarFinanceiro() != 1) continue;
            valor = valor + (i.getValorTotal() - i.getValorTotal() * (percDescFinance / 100.0));
            valorParaBCComissaoTitulo = valorParaBCComissaoTitulo + i.getValorTotal();
        }
        h.put("valorTotal", valor);
        h.put("valorICMSST", valorIcmsSt);
        h.put("valorParaBCComissaoTitulo", valorParaBCComissaoTitulo);
        return h;
    }

    public InfPagNF getValorTotal(Pedido vo) {
        Double valor = 0.0;
        Double valorIcmsSt = 0.0;
        for (ItemPedido i : vo.getItemPedido()) {
            if (i.getModeloFiscal() != null && i.getModeloFiscal().getGerarFinanceiro() != 1) continue;
            valor = valor + i.getValorTotal();
        }
        if (vo.getPercDescFinanceiro() != null && vo.getPercDescFinanceiro() > 0.0) {
            valor = valor - valor * (vo.getPercDescFinanceiro() / 100.0);
        }
        InfPagNF i = new InfPagNF();
        i.setValorTotal(valor);
        i.setValorIcmsST(valorIcmsSt);
        return i;
    }

    public InfPagamentoPedido criarInfPagamentoPadrao(Pedido vo, OpcoesFinanceiras op) {
        InfPagamentoPedido i = new InfPagamentoPedido();
        i.setCondicoesPagamento(vo.getCondicoesPagamento());
        if (vo.getCondicoesPagamento() != null && vo.getCondicoesPagamento().getMeioPagamento() != null) {
            i.setMeioPagamento(vo.getCondicoesPagamento().getMeioPagamento());
        } else {
            i.setMeioPagamento(op.getMeioPagamento());
        }
        if (i.getMeioPagamento() != null) {
            i.setTipoPagamentoNFe(i.getMeioPagamento().getTipoPagamentoNFe());
        }
        i.setPedido(vo);
        return i;
    }

    private void determinarValorInfPagamento(Pedido vo, InfPagNF i) {
        Double valorTotal = i.getValorTotal() - i.getValorIcmsSTDev() - i.getValorImpostoRetido();
        int cont = vo.getInfPagamentoPedido().size();
        int contValorMaiorZero = 0;
        double somaValorMaiorZero = 0.0;
        for (InfPagamentoPedido pag : vo.getInfPagamentoPedido()) {
            if (!(pag.getValor() > 0.0)) continue;
            somaValorMaiorZero += pag.getValor().doubleValue();
            ++contValorMaiorZero;
        }
        valorTotal = valorTotal - somaValorMaiorZero;
        cont -= contValorMaiorZero;
        for (InfPagamentoPedido pag : vo.getInfPagamentoPedido()) {
            if (pag.getValor() == 0.0 && cont > 0) {
                pag.setValor(Double.valueOf(valorTotal / (double)cont));
            }
            if (!(pag.getValor() > 0.0) || cont != 0) continue;
            pag.setValor(Double.valueOf(pag.getValor() + valorTotal));
        }
    }

    private void calculaBCComissaoRepresentante(List titulos, Pedido vo) {
        for (int i = 0; i < titulos.size(); ++i) {
            Titulo t = (Titulo)titulos.get(i);
            if (t.getRepresentantes() == null) continue;
            t.getRepresentantes().clear();
        }
        if (vo.getNaturezaOperacao().getGerarComissaoRep() == null || vo.getNaturezaOperacao().getGerarComissaoRep() != 1) {
            return;
        }
        Integer numParcelas = titulos.size();
        Double valorAcumulado = 0.0;
        HashMap h = this.getPercentualComissaoItensNota(vo);
        Double vrTotal = (Double)h.get("vrTotal");
        Double percComissao = (Double)h.get("percComissao");
        Representante representante = (Representante)h.get("representante");
        Double valorRateioBC = this.arrredondarNumero(vrTotal / (double)(numParcelas > 0 ? numParcelas : 1), 2);
        if (representante == null) {
            return;
        }
        for (int i = 0; i < titulos.size(); ++i) {
            Double percMinoracaoComissao;
            Titulo t;
            valorAcumulado = valorAcumulado + valorRateioBC;
            if (i == titulos.size() - 1) {
                t = (Titulo)titulos.get(i);
                percMinoracaoComissao = this.getPercentualMinoracaoComissao(vo.getCondicoesPagamento());
                t.getRepresentantes().addAll(this.getTituloRepresentante(representante, t, percComissao, this.arrredondarNumero(valorRateioBC + (vrTotal - valorAcumulado), 2), percMinoracaoComissao));
                continue;
            }
            t = (Titulo)titulos.get(i);
            percMinoracaoComissao = this.getPercentualMinoracaoComissao(vo.getCondicoesPagamento());
            t.getRepresentantes().addAll(this.getTituloRepresentante(representante, t, percComissao, valorRateioBC, percMinoracaoComissao));
        }
    }

    private HashMap getPercentualComissaoItensNota(Pedido vo) {
        Double valorTotalComissao = 0.0;
        Double valorTotalItens = 0.0;
        Double percComissao = 0.0;
        Representante rep = null;
        for (ItemPedido i : vo.getItemPedido()) {
            Double valor = i.getValorTotal() - i.getValorSeguro() - i.getValorDespesaAcessoria() - i.getValorFrete();
            valorTotalComissao = valorTotalComissao + this.arrredondarNumero(valor * i.getPercComissao() / 100.0, 4);
            valorTotalItens = valorTotalItens + valor;
            rep = vo.getRepresentante();
        }
        percComissao = this.arrredondarNumero(valorTotalComissao * 100.0 / valorTotalItens, 4);
        HashMap<String, Double> h = new HashMap<String, Double>();
        h.put("percComissao", percComissao);
        h.put("vrTotal", valorTotalItens);
        h.put("representante", (Double)rep);
        return h;
    }

    private List<TituloRepresentante> getTituloRepresentante(Representante representante, Titulo titulo, Double percentual, Double vrBaseCalculoPercentual, Double percMinoracao) {
        ArrayList<TituloRepresentante> lista = new ArrayList<TituloRepresentante>();
        TituloRepresentante t = new TituloRepresentante();
        t.setRepresentante(representante);
        t.setTitulo(titulo);
        if (percentual != null && percentual > 0.0) {
            t.setPercComissao(percentual);
        }
        if (vrBaseCalculoPercentual != null && vrBaseCalculoPercentual > 0.0) {
            if (percMinoracao > 0.0) {
                Double valorMinoracao = ToolFormatter.arrredondarNumero((Double)(vrBaseCalculoPercentual * percMinoracao / 100.0), (int)2);
                vrBaseCalculoPercentual = vrBaseCalculoPercentual - valorMinoracao;
            }
            if (vrBaseCalculoPercentual > 0.0) {
                t.setVrBCComissao(vrBaseCalculoPercentual);
            }
        }
        if (t.getVrBCComissao() > 0.0) {
            lista.add(t);
        }
        return lista;
    }

    private String getParcelas(Date dataBase, List<Titulo> titulos) {
        StringBuilder sb = new StringBuilder();
        for (Titulo titulo : titulos) {
            Date aux = titulo.getDataVencimento();
            sb.append(ToolDate.difBetweenDatesInDays((Date)dataBase, (Date)aux));
            sb.append(";");
        }
        return sb.toString();
    }

    private Date getDataBase(Pedido pedido) {
        if (ToolMethods.isEquals((Object)pedido.getTipoDataTitulo(), (Object)0)) {
            return pedido.getDataPrevisaoSaida();
        }
        return pedido.getDataEmissao();
    }

    private Double getPercentualMinoracaoComissao(CondicoesPagamento c) {
        if (c == null) {
            return 0.0;
        }
        if (c.getMinoracaoComissao() != null) {
            return c.getMinoracaoComissao();
        }
        return 0.0;
    }
}

