/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.components.transferenciacentroestoque;

import com.touchcomp.basementor.model.vo.CentroEstoque;
import com.touchcomp.basementor.model.vo.GradeItemTransfCentroEstoque;
import com.touchcomp.basementor.model.vo.ItemTransfCentroEstoque;
import com.touchcomp.basementor.model.vo.TransferenciaCentroEstoque;
import com.touchcomp.basementor.model.vo.WmsOpcoes;
import com.touchcomp.basementor.model.vo.WmsSaidaEstoque;
import com.touchcomp.basementor.model.vo.WmsSaidaEstoqueGrade;
import com.touchcomp.basementor.model.vo.WmsSaidaEstoqueItem;
import com.touchcomp.basementorservice.helpers.impl.transferenciacentroestoque.HelperTransferenciaCentroEstoque;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.util.Date;
import java.util.Optional;
import org.springframework.stereotype.Component;

@Component
public class CompTransfCentroEstoque {
    public void gerarTransferencia(WmsSaidaEstoque saida, WmsOpcoes wmsOpcoes) {
        CentroEstoque destinoOpcoes = wmsOpcoes.getCentroEstoque();
        TransferenciaCentroEstoque t = saida.getTransfCentroEstocagem();
        if (t == null) {
            t = new TransferenciaCentroEstoque();
            t.setWmsSaidaEstoque(saida);
            t.setDataCadastro(new Date());
            t.setEmpresa(saida.getEmpresa());
            saida.setTransfCentroEstocagem(t);
        }
        t.getItemTransfCentroEstoque().forEach(i -> {
            i.setQuantidadeTotal(Double.valueOf(0.0));
            i.getGradeItemTransCentroEst().forEach(g -> g.setQuantidade(Double.valueOf(0.0)));
        });
        t.setDataTransferencia(saida.getDataSaida());
        for (WmsSaidaEstoqueItem item : saida.getItens()) {
            ItemTransfCentroEstoque itemTransf;
            Optional<ItemTransfCentroEstoque> founditemTransf = t.getItemTransfCentroEstoque().stream().filter(j -> ToolMethods.isEquals((Object)j.getProduto(), (Object)item.getProduto())).findFirst();
            if (founditemTransf.isPresent()) {
                itemTransf = founditemTransf.get();
            } else {
                itemTransf = new ItemTransfCentroEstoque();
                t.getItemTransfCentroEstoque().add(itemTransf);
                itemTransf.setProduto(item.getProduto());
                itemTransf.setTransfCentroEstoque(t);
            }
            for (WmsSaidaEstoqueGrade grade : item.getGrades()) {
                GradeItemTransfCentroEstoque g;
                CentroEstoque origemSet = grade.getWmsEndereco().getCentroEstoque();
                CentroEstoque destinoSet = grade.getWmsEndereco().getCentroEstoqueSaida();
                if (destinoSet == null) {
                    destinoSet = destinoOpcoes;
                }
                CentroEstoque destinoSetFinal = destinoSet;
                Optional<GradeItemTransfCentroEstoque> foundGradeTransf = itemTransf.getGradeItemTransCentroEst().stream().filter(j -> ToolMethods.isEquals((Object)j.getGradeCor(), (Object)grade.getGradeCor()) && ToolMethods.isEquals((Object)j.getLoteFabricacao(), (Object)grade.getLoteFabricacao()) && ToolMethods.isEquals((Object)j.getDestino(), (Object)destinoSetFinal) && ToolMethods.isEquals((Object)j.getOrigem(), (Object)origemSet)).findFirst();
                if (foundGradeTransf.isPresent()) {
                    g = foundGradeTransf.get();
                } else {
                    g = new GradeItemTransfCentroEstoque();
                    g.setDataTransferencia(grade.getDataSaida());
                    g.setEmpresa(t.getEmpresa());
                    g.setGradeCor(grade.getGradeCor());
                    g.setItemTransfCentroEst(itemTransf);
                    g.setLoteFabricacao(grade.getLoteFabricacao());
                    g.setOrigem(origemSet);
                    g.setDestino(destinoSet);
                    itemTransf.getGradeItemTransCentroEst().add(g);
                }
                g.setQuantidade(Double.valueOf(grade.getQuantidade() + g.getQuantidade()));
            }
        }
        HelperTransferenciaCentroEstoque helper = new HelperTransferenciaCentroEstoque();
        helper.build(t).normalizarDadosAntesSalvar();
        helper.limparItensZerados();
    }
}

