/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.components.validacaoliberacaopedido;

import com.touchcomp.basementor.constants.enums.pedido.EnumValidacaoPedidoVarEspeciais;
import com.touchcomp.basementor.constants.enums.saldotitulos.EnumConstSaldoTitPagRec;
import com.touchcomp.basementor.constants.enums.saldotitulos.EnumConstSaldoTitPessoaGrupoPessoa;
import com.touchcomp.basementor.constants.enums.titulo.EnumConstTituloPagRec;
import com.touchcomp.basementor.model.vo.Cliente;
import com.touchcomp.basementor.model.vo.Expedicao;
import com.touchcomp.basementor.model.vo.GrupoPessoas;
import com.touchcomp.basementor.model.vo.InfPagamentoPedido;
import com.touchcomp.basementor.model.vo.OpcoesFinanceiras;
import com.touchcomp.basementor.model.vo.Pedido;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.TipoPagamentoNFe;
import com.touchcomp.basementor.model.vo.UnidadeFatCliente;
import com.touchcomp.basementorservice.service.impl.chequeterceiros.ServiceChequeTerceirosImpl;
import com.touchcomp.basementorservice.service.impl.notafiscalpropria.ServiceNotaFiscalPropriaImpl;
import com.touchcomp.basementorservice.service.impl.pedido.ServicePedidoImpl;
import com.touchcomp.basementorservice.service.impl.saldotitulo.ServiceSaldoTituloImpl;
import com.touchcomp.basementorservice.service.impl.titulo.ServiceTituloImpl;
import com.touchcomp.basementorspringcontext.ConfApplicationContext;
import com.touchcomp.basementortools.tools.avaliadorexpressoes.ListenerAvaliadorExpressoes;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.util.Date;
import java.util.Map;

public class CompAvaExpVariablePedido
implements ListenerAvaliadorExpressoes {
    private static final ServiceSaldoTituloImpl serviceSaldoTitulo = (ServiceSaldoTituloImpl)ConfApplicationContext.getBean(ServiceSaldoTituloImpl.class);
    private static final ServiceTituloImpl serviceTitulo = (ServiceTituloImpl)ConfApplicationContext.getBean(ServiceTituloImpl.class);
    private static final ServiceChequeTerceirosImpl serviceChequeTerceiros = (ServiceChequeTerceirosImpl)ConfApplicationContext.getBean(ServiceChequeTerceirosImpl.class);
    private static final ServicePedidoImpl servicePedido = (ServicePedidoImpl)ConfApplicationContext.getBean(ServicePedidoImpl.class);
    private static final ServiceNotaFiscalPropriaImpl serviceNotaPropria = (ServiceNotaFiscalPropriaImpl)ConfApplicationContext.getBean(ServiceNotaFiscalPropriaImpl.class);

    public Double processVar(String var, String[] otherValues, Map<String, Object> values) {
        Double ret = 0.0;
        Pedido ped = (Pedido)values.get(Pedido.class.getCanonicalName());
        Pessoa pes = (Pessoa)values.get(Pessoa.class.getCanonicalName());
        UnidadeFatCliente unid = (UnidadeFatCliente)values.get(UnidadeFatCliente.class.getCanonicalName());
        OpcoesFinanceiras opcoesFinanceiras = (OpcoesFinanceiras)values.get(OpcoesFinanceiras.class.getCanonicalName());
        switch (EnumValidacaoPedidoVarEspeciais.get((Object)var)) {
            case EXP_VALOR_PEDIDOS_GR_SITUACAO_CLIENTE: {
                ret = this.getValorPedidosGrupoSituacaoCliente(otherValues, ped);
                break;
            }
            case EXP_VALOR_PEDIDOS_SITUACAO_CLIENTE: {
                ret = this.getValorPedidosSituacaoCliente(otherValues, ped);
                break;
            }
            case EXP_VALOR_PEDIDOS_ABERTOS_PESSOA: {
                ret = this.getValorPedidosAbertosPessoa(ped, values);
                break;
            }
            case EXP_VALOR_PEDIDOS_ABERTOS_GR_PESSOAS: {
                ret = this.getValorPedidosAbertosGrupoPessoas(ped, values);
                break;
            }
            case EXP_LIMITE_DISPONIVEL_PEDIDOS_ABERTOS_PESSOA: {
                ret = this.getLimiteDisponivelPedidosAbertosPessoa(ped, unid, values);
                break;
            }
            case EXP_LIMITE_DISPONIVEL_PEDIDOS_ABERTOS_GR_PESSOA: {
                ret = this.getLimiteDisponivelPedidosAbertosGrupoPessoa(ped, unid, values);
                break;
            }
            case EXP_VALOR_PEDIDOS_GR_SITUACAO_GR_PESSOAS: {
                ret = this.getValorPedidosGrupoSituacaoGrupoPessoas(otherValues, ped);
                break;
            }
            case EXP_VALOR_PEDIDOS_SITUACAO_GR_PESSOAS: {
                ret = this.getValorPedidosSituacaoGrupoPessoas(otherValues, ped);
                break;
            }
            case EXP_DATA_ULTIMO_TITULO_CARTORIO: {
                ret = this.getDataUltimoTituloCartorio(ped, values);
                break;
            }
            case EXP_DATA_ULTIMO_TITULO_PROTESTO: {
                ret = this.getDataUltimoTituloProtesto(ped, values);
                break;
            }
            case EXP_DATA_ULTIMO_TITULO_SUSTADO: {
                ret = this.getDataUltimoTituloSustado(ped, values);
                break;
            }
            case EXP_SALDO_DEVEDOR_PESSOA: {
                ret = this.getSaldoDevedorPessoa(pes, values);
                break;
            }
            case EXP_CHEQUE_DEVOLVIDO_PESSOA: {
                ret = this.getChequeDevolvidoPessoa(pes, values);
                break;
            }
            case EXP_CHEQUE_NAO_COMPENSADO_PESSOA: {
                ret = this.getChequeNaoCompensadoPessoa(pes, values);
                break;
            }
            case EXP_SALDO_VENCIDO_PESSOA: {
                ret = this.getSaldoVencidoPessoa(pes, values, opcoesFinanceiras);
                break;
            }
            case EXP_SALDO_VENCIDO_PESSOA_EXC_DIAS_NAO_UTEIS: {
                ret = this.getSaldoVencidoPessoaExcluindoDiasNaoUteis(pes, values, opcoesFinanceiras);
                break;
            }
            case EXP_DIAS_ULTIMA_COMPRA_CLIENTE: {
                ret = this.getDiasUltimaCompraCliente(unid, values);
                break;
            }
            case EXP_LIMITE_DISPONIVEL: {
                ret = this.getLimiteDisponivel(pes, unid, values);
                break;
            }
            case EXP_SALDO_DEVEDOR_GRUPO_PESSOA: {
                ret = this.getSaldoDevedorGrupoPessoa(pes, values);
                break;
            }
            case EXP_CHEQUE_DEVOLVIDO_GRUPO_PESSOA: {
                ret = this.getChequeDevolvidoGrupoPessoa(pes, values);
                break;
            }
            case EXP_CHEQUE_NAO_COMPENSADO_GRUPO_PESSOA: {
                ret = this.getChequeNaoCompensadoGrupoPessoa(pes, values);
                break;
            }
            case EXP_SALDO_VENCIDO_GRUPO_PESSOA: {
                ret = this.getSaldoVencidoGrupoPessoa(pes, opcoesFinanceiras, values);
                break;
            }
            case EXP_SALDO_VENCIDO_GRUPO_PESSOA_EXC_DIAS_NAO_UTEIS: {
                ret = this.getSaldoVencidoGrupoPessoaExcluindoDiasNaoUteis(pes, values, opcoesFinanceiras);
                break;
            }
            case EXP_LIMITE_DISPONIVEL_GRUPO_PESSOA: {
                ret = this.getLimiteDisponivelGrupoPessoa(pes, unid, values);
                break;
            }
            case EXP_PEDIDO_POSSUI_NF: {
                ret = CompAvaExpVariablePedido.verificaPedidoPossuiNF(ped);
                break;
            }
            case EXP_PEDIDO_POSSUI_EXP: {
                ret = CompAvaExpVariablePedido.verificaPedidoPossuiExpedicao(ped);
                break;
            }
            case EXP_DIAS_VALIDADE_LIMITE: {
                ret = this.verificaLimiteDiasValidade(unid);
                break;
            }
            case EXP_DIAS_VALIDADE_IMA: {
                ret = this.verificaDiasValidadeIMA(unid);
                break;
            }
            case EXP_INFORMADO_GRUPO_PESSOA: {
                ret = this.informadoGrupoPessoa(pes);
                break;
            }
            case EXP_DIAS_VALIDADE_LIMITE_GRUPO_PESSOA: {
                ret = this.verificaLimiteDiasValidadeGrupoPessoa(pes);
                break;
            }
            case EXP_PEDIDO_A_PRAZO: {
                ret = this.getPedidoAPrazo(ped, values);
            }
        }
        return ret != null ? ret : 0.0;
    }

    public boolean isAvailable(String var) {
        EnumValidacaoPedidoVarEspeciais[] data;
        for (EnumValidacaoPedidoVarEspeciais e : data = EnumValidacaoPedidoVarEspeciais.values()) {
            if (!e.getValue().equalsIgnoreCase(var)) continue;
            return true;
        }
        return false;
    }

    private static Integer getDiasUltimoTituloProtesto(Cliente cliente) {
        Date dataUltimoTitulo = serviceTitulo.findUltimaDataTituloProtesto(cliente.getPessoa().getIdentificador(), EnumConstTituloPagRec.TIPO_TITULO_REC);
        if (dataUltimoTitulo != null) {
            Integer dias = ToolDate.diferenceDayBetweenDatesExclusive((Date)dataUltimoTitulo, (Date)new Date());
            return dias;
        }
        return 0;
    }

    private Integer getDiasUltimoTituloSustado(Cliente cliente) {
        Date dataUltimoTitulo = serviceTitulo.findUltimaDataTituloSustado(cliente.getPessoa().getIdentificador(), EnumConstTituloPagRec.TIPO_TITULO_REC);
        if (dataUltimoTitulo != null) {
            Integer dias = ToolDate.diferenceDayBetweenDatesExclusive((Date)dataUltimoTitulo, (Date)new Date());
            return dias;
        }
        return 0;
    }

    private static Integer getDiasUltimoTituloCartorio(Cliente cliente) {
        Date dataUltimoTitulo = serviceTitulo.findUltimaDataTituloCartorio(cliente.getPessoa().getIdentificador(), EnumConstTituloPagRec.TIPO_TITULO_REC);
        if (dataUltimoTitulo != null) {
            Integer dias = ToolDate.diferenceDayBetweenDatesExclusive((Date)dataUltimoTitulo, (Date)new Date());
            return dias;
        }
        return 0;
    }

    private static Double getSaldoDevedor(Long id, EnumConstSaldoTitPessoaGrupoPessoa tipo) {
        return serviceSaldoTitulo.getSaldoDevedorPessoa(id, EnumConstSaldoTitPagRec.TIPO_TITULO_REC, tipo, new Date());
    }

    private static Double getSaldoChequesDevolvidos(Pessoa pessoa) {
        return serviceChequeTerceiros.valorChequesDevolvidos(pessoa.getIdentificador());
    }

    private static Double getSaldoDevedorChequesNaoComp(Pessoa pessoa) {
        return serviceChequeTerceiros.valorChequesNaoCompensados(pessoa.getIdentificador());
    }

    private static Double getSaldoChequesDevolvidosGrupoPessoas(GrupoPessoas gr) {
        return serviceChequeTerceiros.valorChequesDevolvidosGrupoPessoas(gr.getIdentificador());
    }

    private static Double getSaldoDevedorChequesNaoCompGrupoPessoas(GrupoPessoas gr) {
        return serviceChequeTerceiros.valorChequesNaoCompensadosGrupoPessoa(gr.getIdentificador());
    }

    private static Double getSaldoTitulosVencidos(Long id, Integer diasTolerancia, EnumConstSaldoTitPessoaGrupoPessoa tipo) {
        return serviceSaldoTitulo.getSaldoVencidoPessoa(id, diasTolerancia, EnumConstSaldoTitPagRec.TIPO_TITULO_REC, tipo, new Date());
    }

    private static Integer getUltimaCompraCliente(Cliente cliente) {
        Date dataUltimaCompra = serviceNotaPropria.getDataUltimaCompraCliente(cliente);
        if (dataUltimaCompra != null) {
            Integer dias = ToolDate.diferenceDayBetweenDatesExclusive((Date)dataUltimaCompra, (Date)new Date());
            return dias;
        }
        return 0;
    }

    private Double getValorPedidosGrupoSituacaoCliente(String[] otherValues, Pedido ped) {
        if (ped != null && otherValues.length > 0) {
            String id = otherValues[0];
            return servicePedido.getValorGrSituacaoCliente(Long.valueOf(id), ped.getUnidadeFatCliente().getCliente().getIdentificador());
        }
        return 0.0;
    }

    private Double getValorPedidosSituacaoCliente(String[] otherValues, Pedido ped) {
        if (ped != null && otherValues.length > 0) {
            String id = otherValues[0];
            return servicePedido.getValorSituacaoCliente(Long.valueOf(id), ped.getUnidadeFatCliente().getCliente().getIdentificador());
        }
        return 0.0;
    }

    private Double getValorPedidosAbertosPessoa(Pedido ped, Map<String, Object> values) {
        if (ped != null) {
            Double ret = servicePedido.getValorPedidoAberto(ped.getUnidadeFatCliente().getCliente());
            values.put(EnumValidacaoPedidoVarEspeciais.EXP_VALOR_PEDIDOS_ABERTOS_PESSOA.getValue(), ret);
            return ret;
        }
        return 0.0;
    }

    private Double getLimiteDisponivelPedidosAbertosPessoa(Pedido ped, UnidadeFatCliente unid, Map<String, Object> values) {
        if (ped != null && unid != null) {
            Double valorPedidoAberto = (Double)values.get(EnumValidacaoPedidoVarEspeciais.EXP_VALOR_PEDIDOS_ABERTOS_PESSOA.getValue());
            if (valorPedidoAberto == null) {
                valorPedidoAberto = servicePedido.getValorPedidoAberto(ped.getUnidadeFatCliente().getCliente());
            }
            Double limiteDisp = this.getLimiteDisponivel(unid.getPessoa(), unid, values);
            limiteDisp = limiteDisp - valorPedidoAberto;
            values.put(EnumValidacaoPedidoVarEspeciais.EXP_LIMITE_DISPONIVEL_PEDIDOS_ABERTOS_PESSOA.getValue(), limiteDisp);
            return limiteDisp;
        }
        return 0.0;
    }

    private Double getValorPedidosGrupoSituacaoGrupoPessoas(String[] otherValues, Pedido ped) {
        if (otherValues.length > 0 && ped.getUnidadeFatCliente().getCliente().getPessoa().getGrupoPessoas() != null) {
            String id = otherValues[0];
            return servicePedido.getValorGrSituacaoGrPessoas(Long.valueOf(id), ped.getUnidadeFatCliente().getCliente().getPessoa().getGrupoPessoas().getIdentificador());
        }
        return 0.0;
    }

    private Double getValorPedidosSituacaoGrupoPessoas(String[] otherValues, Pedido ped) {
        if (otherValues.length > 0 && ped.getUnidadeFatCliente().getCliente().getPessoa().getGrupoPessoas() != null) {
            String id = otherValues[0];
            return servicePedido.getValorSituacaoGrPessoas(Long.valueOf(id), ped.getUnidadeFatCliente().getCliente().getPessoa().getGrupoPessoas().getIdentificador());
        }
        return 0.0;
    }

    private Double getValorPedidosAbertosGrupoPessoas(Pedido ped, Map<String, Object> values) {
        Double ret = 0.0;
        if (ped != null && ped.getUnidadeFatCliente().getCliente().getPessoa().getGrupoPessoas() != null) {
            ret = servicePedido.getValorPedidoAbertoGrPessoas(ped.getUnidadeFatCliente().getCliente().getPessoa().getGrupoPessoas());
            values.put(EnumValidacaoPedidoVarEspeciais.EXP_VALOR_PEDIDOS_ABERTOS_GR_PESSOAS.getValue(), ret);
        }
        return ret;
    }

    private Double getLimiteDisponivelPedidosAbertosGrupoPessoa(Pedido ped, UnidadeFatCliente unid, Map<String, Object> values) {
        if (ped != null && unid != null && unid.getPessoa().getGrupoPessoas() != null) {
            Double valorPedidoAberto = (Double)values.get(EnumValidacaoPedidoVarEspeciais.EXP_VALOR_PEDIDOS_ABERTOS_GR_PESSOAS.getValue());
            if (valorPedidoAberto == null) {
                valorPedidoAberto = servicePedido.getValorPedidoAbertoGrPessoas(unid.getPessoa().getGrupoPessoas());
            }
            Double limiteDisp = this.getLimiteDisponivelGrupoPessoa(unid.getPessoa(), unid, values);
            limiteDisp = limiteDisp - valorPedidoAberto;
            return limiteDisp;
        }
        return 0.0;
    }

    private Double getDataUltimoTituloCartorio(Pedido ped, Map<String, Object> values) {
        Integer dias = CompAvaExpVariablePedido.getDiasUltimoTituloCartorio(ped.getUnidadeFatCliente().getCliente());
        values.put(EnumValidacaoPedidoVarEspeciais.EXP_DATA_ULTIMO_TITULO_CARTORIO.getValue(), dias);
        return dias.doubleValue();
    }

    private Double getDataUltimoTituloProtesto(Pedido ped, Map<String, Object> values) {
        Integer dias = CompAvaExpVariablePedido.getDiasUltimoTituloProtesto(ped.getUnidadeFatCliente().getCliente());
        values.put(EnumValidacaoPedidoVarEspeciais.EXP_DATA_ULTIMO_TITULO_PROTESTO.getValue(), dias);
        return dias.doubleValue();
    }

    private Double getDataUltimoTituloSustado(Pedido ped, Map<String, Object> values) {
        Integer dias = this.getDiasUltimoTituloSustado(ped.getUnidadeFatCliente().getCliente());
        values.put(EnumValidacaoPedidoVarEspeciais.EXP_DATA_ULTIMO_TITULO_SUSTADO.getValue(), dias);
        return dias.doubleValue();
    }

    private Double getSaldoDevedorPessoa(Pessoa pes, Map<String, Object> values) {
        if (pes != null) {
            Double saldoDev = CompAvaExpVariablePedido.getSaldoDevedor(pes.getIdentificador(), EnumConstSaldoTitPessoaGrupoPessoa.TIPO_PESSOA);
            values.put(EnumValidacaoPedidoVarEspeciais.EXP_SALDO_DEVEDOR_PESSOA.getValue(), saldoDev);
            return saldoDev;
        }
        return 0.0;
    }

    private Double getChequeDevolvidoPessoa(Pessoa pes, Map<String, Object> values) {
        if (pes != null) {
            Double chequesDev = CompAvaExpVariablePedido.getSaldoChequesDevolvidos(pes);
            values.put(EnumValidacaoPedidoVarEspeciais.EXP_CHEQUE_DEVOLVIDO_PESSOA.getValue(), chequesDev);
            return chequesDev;
        }
        return 0.0;
    }

    private Double getChequeNaoCompensadoPessoa(Pessoa pes, Map<String, Object> values) {
        if (pes != null) {
            Double chequesNaoComp = CompAvaExpVariablePedido.getSaldoDevedorChequesNaoComp(pes);
            values.put(EnumValidacaoPedidoVarEspeciais.EXP_CHEQUE_NAO_COMPENSADO_PESSOA.getValue(), chequesNaoComp);
            return chequesNaoComp;
        }
        return 0.0;
    }

    private Double getSaldoVencidoPessoa(Pessoa pes, Map<String, Object> values, OpcoesFinanceiras opcoesFinanceiras) {
        if (pes != null) {
            Double valor = CompAvaExpVariablePedido.getSaldoTitulosVencidos(pes.getIdentificador(), opcoesFinanceiras.getDiasToleranciaAnaliseCredito(), EnumConstSaldoTitPessoaGrupoPessoa.TIPO_PESSOA);
            values.put(EnumValidacaoPedidoVarEspeciais.EXP_SALDO_VENCIDO_PESSOA.getValue(), valor);
            return valor;
        }
        return 0.0;
    }

    private Double getDiasUltimaCompraCliente(UnidadeFatCliente unid, Map<String, Object> values) {
        Integer diasUltimaCompra = CompAvaExpVariablePedido.getUltimaCompraCliente(unid.getCliente());
        if (diasUltimaCompra == null) {
            diasUltimaCompra = 0;
        }
        values.put(EnumValidacaoPedidoVarEspeciais.EXP_DIAS_ULTIMA_COMPRA_CLIENTE.getValue(), diasUltimaCompra);
        return diasUltimaCompra.doubleValue();
    }

    private Double getLimiteDisponivel(Pessoa pes, UnidadeFatCliente unid, Map<String, Object> values) {
        Double ret = 0.0;
        if (pes != null && unid != null) {
            Double saldoDev = (Double)values.get(EnumValidacaoPedidoVarEspeciais.EXP_SALDO_DEVEDOR_PESSOA.getValue());
            Double chequesDev = (Double)values.get(EnumValidacaoPedidoVarEspeciais.EXP_CHEQUE_DEVOLVIDO_PESSOA.getValue());
            Double chequesNaoComp = (Double)values.get(EnumValidacaoPedidoVarEspeciais.EXP_CHEQUE_NAO_COMPENSADO_PESSOA.getValue());
            if (saldoDev == null) {
                saldoDev = CompAvaExpVariablePedido.getSaldoDevedor(pes.getIdentificador(), EnumConstSaldoTitPessoaGrupoPessoa.TIPO_PESSOA);
                values.put(EnumValidacaoPedidoVarEspeciais.EXP_SALDO_DEVEDOR_PESSOA.getValue(), saldoDev);
            }
            if (chequesDev == null) {
                chequesDev = CompAvaExpVariablePedido.getSaldoChequesDevolvidos(pes);
                values.put(EnumValidacaoPedidoVarEspeciais.EXP_CHEQUE_DEVOLVIDO_PESSOA.getValue(), chequesDev);
            }
            if (chequesNaoComp == null) {
                chequesNaoComp = CompAvaExpVariablePedido.getSaldoDevedorChequesNaoComp(pes);
                values.put(EnumValidacaoPedidoVarEspeciais.EXP_CHEQUE_NAO_COMPENSADO_PESSOA.getValue(), chequesNaoComp);
            }
            Double limiteDisp = unid.getCliente().getFinanceiro().getLimiteCredito() - saldoDev - chequesDev - chequesNaoComp;
            values.put(EnumValidacaoPedidoVarEspeciais.EXP_LIMITE_DISPONIVEL.getValue(), limiteDisp);
            ret = limiteDisp;
        }
        return ret;
    }

    private Double getSaldoDevedorGrupoPessoa(Pessoa pes, Map<String, Object> values) {
        if (pes != null && pes.getGrupoPessoas() != null) {
            Double saldoDev = CompAvaExpVariablePedido.getSaldoDevedor(pes.getGrupoPessoas().getIdentificador(), EnumConstSaldoTitPessoaGrupoPessoa.TIPO_GRUPO_PESSOA);
            values.put(EnumValidacaoPedidoVarEspeciais.EXP_SALDO_DEVEDOR_GRUPO_PESSOA.getValue(), saldoDev);
            return saldoDev;
        }
        return 0.0;
    }

    private Double getChequeDevolvidoGrupoPessoa(Pessoa pes, Map<String, Object> values) {
        if (pes != null && pes.getGrupoPessoas() != null) {
            Double chequesDev = CompAvaExpVariablePedido.getSaldoChequesDevolvidosGrupoPessoas(pes.getGrupoPessoas());
            values.put(EnumValidacaoPedidoVarEspeciais.EXP_CHEQUE_DEVOLVIDO_GRUPO_PESSOA.getValue(), chequesDev);
            return chequesDev;
        }
        return 0.0;
    }

    private Double getChequeNaoCompensadoGrupoPessoa(Pessoa pes, Map<String, Object> values) {
        if (pes != null && pes.getGrupoPessoas() != null) {
            Double chequesNaoComp = CompAvaExpVariablePedido.getSaldoDevedorChequesNaoCompGrupoPessoas(pes.getGrupoPessoas());
            values.put(EnumValidacaoPedidoVarEspeciais.EXP_CHEQUE_NAO_COMPENSADO_GRUPO_PESSOA.getValue(), chequesNaoComp);
            return chequesNaoComp;
        }
        return 0.0;
    }

    private Double getSaldoVencidoGrupoPessoa(Pessoa pes, OpcoesFinanceiras opcoesFinanceiras, Map<String, Object> values) {
        if (pes != null && opcoesFinanceiras != null && pes.getGrupoPessoas() != null) {
            Double valoresVencidos = CompAvaExpVariablePedido.getSaldoTitulosVencidos(pes.getGrupoPessoas().getIdentificador(), opcoesFinanceiras.getDiasToleranciaAnaliseCredito(), EnumConstSaldoTitPessoaGrupoPessoa.TIPO_GRUPO_PESSOA);
            values.put(EnumValidacaoPedidoVarEspeciais.EXP_SALDO_VENCIDO_GRUPO_PESSOA.getValue(), valoresVencidos);
            return valoresVencidos;
        }
        return 0.0;
    }

    private Double getLimiteDisponivelGrupoPessoa(Pessoa pes, UnidadeFatCliente unid, Map<String, Object> values) {
        if (pes != null && pes.getGrupoPessoas() != null) {
            Double saldoDev = (Double)values.get(EnumValidacaoPedidoVarEspeciais.EXP_SALDO_DEVEDOR_GRUPO_PESSOA.getValue());
            Double chequesDev = (Double)values.get(EnumValidacaoPedidoVarEspeciais.EXP_CHEQUE_DEVOLVIDO_GRUPO_PESSOA.getValue());
            Double chequesNaoComp = (Double)values.get(EnumValidacaoPedidoVarEspeciais.EXP_CHEQUE_NAO_COMPENSADO_GRUPO_PESSOA.getValue());
            if (saldoDev == null) {
                saldoDev = CompAvaExpVariablePedido.getSaldoDevedor(pes.getGrupoPessoas().getIdentificador(), EnumConstSaldoTitPessoaGrupoPessoa.TIPO_GRUPO_PESSOA);
                values.put(EnumValidacaoPedidoVarEspeciais.EXP_SALDO_DEVEDOR_GRUPO_PESSOA.getValue(), saldoDev);
            }
            if (chequesDev == null) {
                chequesDev = CompAvaExpVariablePedido.getSaldoChequesDevolvidosGrupoPessoas(pes.getGrupoPessoas());
                values.put(EnumValidacaoPedidoVarEspeciais.EXP_CHEQUE_DEVOLVIDO_GRUPO_PESSOA.getValue(), chequesDev);
            }
            if (chequesNaoComp == null) {
                chequesNaoComp = CompAvaExpVariablePedido.getSaldoDevedorChequesNaoCompGrupoPessoas(pes.getGrupoPessoas());
                values.put(EnumValidacaoPedidoVarEspeciais.EXP_CHEQUE_NAO_COMPENSADO_GRUPO_PESSOA.getValue(), chequesNaoComp);
            }
            Double limiteDisp = unid.getCliente().getPessoa().getGrupoPessoas().getLimiteCredito() - saldoDev - chequesDev - chequesNaoComp;
            values.put(EnumValidacaoPedidoVarEspeciais.EXP_LIMITE_DISPONIVEL_GRUPO_PESSOA.getValue(), limiteDisp);
            return limiteDisp;
        }
        return 0.0;
    }

    private static Double verificaPedidoPossuiNF(Pedido vo) {
        if (vo.getExpedicao() != null) {
            for (Expedicao expedicao : vo.getExpedicao()) {
                if (expedicao.getNotaFiscalPropria() == null) continue;
                return 1.0;
            }
        }
        return 0.0;
    }

    private static Double verificaPedidoPossuiExpedicao(Pedido vo) {
        return vo.getExpedicao() != null && vo.getExpedicao().size() > 0 ? 1.0 : 0.0;
    }

    private Double verificaLimiteDiasValidade(UnidadeFatCliente unidadeFatCliente) {
        Date dataLiberacao = unidadeFatCliente.getCliente().getFinanceiro().getDataLiberacaoCredito();
        Integer diasLimite = unidadeFatCliente.getCliente().getFinanceiro().getDiasVigorLimiteCred();
        diasLimite = diasLimite == null ? 0 : diasLimite;
        if (dataLiberacao != null) {
            dataLiberacao = ToolDate.nextDays((Date)dataLiberacao, (int)diasLimite);
        }
        Integer diasValidade = dataLiberacao == null ? Integer.valueOf(0) : (new Date().after(dataLiberacao) ? Integer.valueOf(-1) : ToolDate.diferenceDayBetweenDates((Date)new Date(), (Date)dataLiberacao));
        return diasValidade.doubleValue();
    }

    private Double verificaDiasValidadeIMA(UnidadeFatCliente unidadeFatCliente) {
        if (unidadeFatCliente == null) {
            return 1.0;
        }
        Integer diasDiferenca = 0;
        if (unidadeFatCliente.getPessoa().getComplemento().getDataValidadeIMA() != null) {
            diasDiferenca = ToolDate.diferenceDayBetweenDates((Date)new Date(), (Date)unidadeFatCliente.getPessoa().getComplemento().getDataValidadeIMA());
        }
        return diasDiferenca.doubleValue();
    }

    private Double informadoGrupoPessoa(Pessoa pes) {
        return pes.getGrupoPessoas() != null ? 1.0 : 0.0;
    }

    private Double verificaLimiteDiasValidadeGrupoPessoa(Pessoa pes) {
        Integer diasValidade = 0;
        if (pes.getGrupoPessoas() != null) {
            Integer diasLimiteGr = pes.getGrupoPessoas().getDiasVigorLimiteCred();
            Date dataLiberacao = pes.getGrupoPessoas().getDataLiberacaoCredito();
            diasLimiteGr = diasLimiteGr == null ? 0 : diasLimiteGr;
            if (dataLiberacao != null) {
                dataLiberacao = ToolDate.nextDays((Date)dataLiberacao, (int)diasLimiteGr);
            }
            diasValidade = dataLiberacao == null ? Integer.valueOf(0) : (new Date().after(dataLiberacao) ? Integer.valueOf(-1) : ToolDate.diferenceDayBetweenDates((Date)new Date(), (Date)dataLiberacao));
        }
        return diasValidade.doubleValue();
    }

    private Double getSaldoVencidoPessoaExcluindoDiasNaoUteis(Pessoa pes, Map<String, Object> values, OpcoesFinanceiras opcoesFinanceiras) {
        if (pes != null) {
            Double valor = CompAvaExpVariablePedido.getSaldoTitulosVencidosExcluindoDiasNaoUteis(pes.getIdentificador(), opcoesFinanceiras.getDiasToleranciaAnaliseCredito(), EnumConstSaldoTitPessoaGrupoPessoa.TIPO_PESSOA);
            values.put(EnumValidacaoPedidoVarEspeciais.EXP_SALDO_VENCIDO_PESSOA_EXC_DIAS_NAO_UTEIS.getValue(), valor);
            return valor;
        }
        return 0.0;
    }

    private Double getSaldoVencidoGrupoPessoaExcluindoDiasNaoUteis(Pessoa pes, Map<String, Object> values, OpcoesFinanceiras opcoesFinanceiras) {
        if (pes != null && pes.getGrupoPessoas() != null) {
            Double valor = CompAvaExpVariablePedido.getSaldoTitulosVencidosExcluindoDiasNaoUteis(pes.getGrupoPessoas().getIdentificador(), opcoesFinanceiras.getDiasToleranciaAnaliseCredito(), EnumConstSaldoTitPessoaGrupoPessoa.TIPO_GRUPO_PESSOA);
            values.put(EnumValidacaoPedidoVarEspeciais.EXP_SALDO_VENCIDO_GRUPO_PESSOA_EXC_DIAS_NAO_UTEIS.getValue(), valor);
            return valor;
        }
        return 0.0;
    }

    private static Double getSaldoTitulosVencidosExcluindoDiasNaoUteis(Long id, Integer diasTolerancia, EnumConstSaldoTitPessoaGrupoPessoa tipo) {
        return serviceSaldoTitulo.getSaldoVencidoPessoaExcluindoDiasNaoUteis(id, diasTolerancia, EnumConstSaldoTitPagRec.TIPO_TITULO_REC, tipo, new Date());
    }

    private Double getPedidoAPrazo(Pedido ped, Map<String, Object> values) {
        Short pedidoAPrazo = 0;
        for (InfPagamentoPedido infPag : ped.getInfPagamentoPedido()) {
            TipoPagamentoNFe t = infPag.getTipoPagamentoNFe();
            if (!ToolMethods.isNotNull((Object)t).booleanValue() || !ToolMethods.isEquals((Object)t.getCodigo(), (Object)"02") && !ToolMethods.isEquals((Object)t.getCodigo(), (Object)"05") && !ToolMethods.isEquals((Object)t.getCodigo(), (Object)"15")) continue;
            pedidoAPrazo = 1;
        }
        values.put(EnumValidacaoPedidoVarEspeciais.EXP_PEDIDO_A_PRAZO.getValue(), pedidoAPrazo.doubleValue());
        return pedidoAPrazo.doubleValue();
    }
}

