/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.components.validacaoliberacaopedido;

import com.touchcomp.basementor.constants.enums.pedido.EnumValidacaoPedido;
import com.touchcomp.basementor.constants.enums.pedido.EnumValidacaoPedidoVarEspeciais;
import com.touchcomp.basementor.model.impl.ValidacaoPedidoItem;
import com.touchcomp.basementor.model.vo.Cliente;
import com.touchcomp.basementor.model.vo.CondicoesPagamento;
import com.touchcomp.basementor.model.vo.ConfigValPedidos;
import com.touchcomp.basementor.model.vo.ConfigValPedidosItem;
import com.touchcomp.basementor.model.vo.Grupo;
import com.touchcomp.basementor.model.vo.GrupoPessoas;
import com.touchcomp.basementor.model.vo.InfPagamentoPedido;
import com.touchcomp.basementor.model.vo.ItemPedido;
import com.touchcomp.basementor.model.vo.LiberacaoPedidoPed;
import com.touchcomp.basementor.model.vo.LiberacaoPedidoPedItem;
import com.touchcomp.basementor.model.vo.MeioPagamento;
import com.touchcomp.basementor.model.vo.NaturezaOperacao;
import com.touchcomp.basementor.model.vo.OpcoesFaturamento;
import com.touchcomp.basementor.model.vo.OpcoesFinanceiras;
import com.touchcomp.basementor.model.vo.Pedido;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.Produto;
import com.touchcomp.basementor.model.vo.Representante;
import com.touchcomp.basementor.model.vo.SituacaoPedidos;
import com.touchcomp.basementor.model.vo.TipoFrete;
import com.touchcomp.basementor.model.vo.TipoPagamentoNFe;
import com.touchcomp.basementor.model.vo.UnidadeFatCliente;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementorexceptions.exceptions.ExceptionBase;
import com.touchcomp.basementorexceptions.exceptions.impl.invaliddata.ExceptionInvalidData;
import com.touchcomp.basementorservice.components.avaliadorexpressoes.CompAvaliadorExpressoes;
import com.touchcomp.basementorservice.components.validacaoliberacaopedido.CompAvaExpVariablePedido;
import com.touchcomp.basementorservice.helpers.impl.usuario.HelperUsuario;
import com.touchcomp.basementortools.tools.avaliadorexpressoes.ListenerAvaliadorExpressoes;
import com.touchcomp.basementortools.tools.avaliadorexpressoes.model.DTOResultCalcExpressoes;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.stream.Collectors;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CompValidacaoLiberacaoPedido {
    @Autowired
    HelperUsuario helperUsuario;

    public ValidacaoPedidoItem validarItemPedido(OpcoesFaturamento op, ItemPedido item, ValidacaoPedidoItem val, OpcoesFinanceiras opFin, EnumValidacaoPedido validarPedido, UnidadeFatCliente unidadefat) throws ExceptionBase {
        ConfigValPedidos conf = op.getConfValidacaoPedidos();
        if (val == null) {
            val = new ValidacaoPedidoItem();
        }
        if (conf == null) {
            throw new ExceptionInvalidData("E.ERP.1180.005", new Object[0]);
        }
        Map<String, Object> values = this.buildDefMap(item.getPedido(), opFin, op, validarPedido);
        values.put(ItemPedido.class.getCanonicalName(), item);
        values.put(Produto.class.getCanonicalName(), item.getProduto());
        if (unidadefat != null) {
            values.put(Cliente.class.getCanonicalName(), unidadefat.getCliente());
            values.put(UnidadeFatCliente.class.getCanonicalName(), unidadefat);
        }
        this.validarItensPedido(conf, val, item, null, values, null);
        this.buildStringText(val);
        return val;
    }

    public ValidacaoPedidoItem validarPedido(OpcoesFaturamento op, OpcoesFinanceiras opFin, Pedido pedido, ValidacaoPedidoItem val, EnumValidacaoPedido validarPedido, ConfigValPedidos conf) throws ExceptionBase {
        if (pedido.getSituacaoPedido() == null) {
            throw new ExceptionInvalidData("E.ERP.1180.004 ", new Object[]{pedido});
        }
        if (TMethods.isAffirmative((Number)pedido.getSituacaoPedido().getCancelarTitulos())) {
            return val;
        }
        if (conf == null) {
            throw new ExceptionInvalidData("E.ERP.1180.005", new Object[0]);
        }
        if (val == null) {
            val = new ValidacaoPedidoItem();
        }
        this.buildLiberacao(pedido);
        Map<String, Object> values = this.buildDefMap(pedido, opFin, op, validarPedido);
        val.setPedido(pedido);
        boolean validar = this.validarPedido(validarPedido, opFin);
        if (!validar) {
            this.buildStringText(val);
            return val;
        }
        List<ConfigValPedidosItem> regrasValPed = this.filtrar(conf.getItens(), (short)0);
        LinkedList<ConfigValPedidosItem> rules = new LinkedList<ConfigValPedidosItem>();
        for (ConfigValPedidosItem r : regrasValPed) {
            System.out.println("\n\nRegra: " + r.toString());
            this.avaliarRegra(r, val, pedido, values, rules);
        }
        for (ItemPedido item : pedido.getItemPedido()) {
            values.put(ItemPedido.class.getCanonicalName(), item);
            values.put(Produto.class.getCanonicalName(), item.getProduto());
            this.validarItensPedido(conf, val, item, pedido.getLiberacaoPedidoPed(), values, rules);
        }
        for (InfPagamentoPedido infPag : pedido.getInfPagamentoPedido()) {
            values.put(InfPagamentoPedido.class.getCanonicalName(), infPag);
            values.put(CondicoesPagamento.class.getCanonicalName(), infPag.getCondicoesPagamento());
            values.put(MeioPagamento.class.getCanonicalName(), infPag.getMeioPagamento());
            values.put(TipoPagamentoNFe.class.getCanonicalName(), infPag.getTipoPagamentoNFe());
            this.validarInfPagPedido(conf, val, infPag, pedido.getLiberacaoPedidoPed(), values, rules);
        }
        this.setarCamposDisponivel(pedido, values);
        LiberacaoPedidoPed l = pedido.getLiberacaoPedidoPed();
        if (l == null) {
            l = new LiberacaoPedidoPed();
            l.setPedido(pedido);
        }
        pedido.setLiberacaoPedidoPed(l);
        if (op.getNaoLiberarPedidosAoReavaliar() == null || op.getNaoLiberarPedidosAoReavaliar().equals((short)0)) {
            this.liberarAutomaticamentePed(rules, pedido);
        }
        this.checarItensBloq(l, val.getItens());
        this.buildStringText(val);
        this.removerItensSemLibPos(l);
        this.libBloqPedAcordoItens(pedido, op);
        return val;
    }

    private void setarCamposDisponivel(Pedido pedido, Map<String, Object> values) {
        Double limiteDisponivel = (Double)values.get(EnumValidacaoPedidoVarEspeciais.EXP_LIMITE_DISPONIVEL.getValue());
        if (ToolMethods.isWithData((Number)limiteDisponivel)) {
            pedido.setLimiteCredito(pedido.getUnidadeFatCliente().getCliente().getFinanceiro().getLimiteCredito());
            pedido.setValorLimiteDispAntesVenda(limiteDisponivel);
            pedido.setValorLimiteDispPosVenda(Double.valueOf(limiteDisponivel - pedido.getValorTotal()));
            pedido.setTotalCompras(Double.valueOf(pedido.getLimiteCredito() - pedido.getValorLimiteDispPosVenda()));
        }
    }

    private void libBloqPedAcordoItens(Pedido ped, OpcoesFaturamento op) {
        if (ped.getSituacaoPedido() == null) {
            return;
        }
        if (ped.getSituacaoPedido().getCancelarTitulos() != null && ped.getSituacaoPedido().getCancelarTitulos() == 1) {
            ped.getLiberacaoPedidoPed().setLiberado(Short.valueOf((short)1));
            return;
        }
        boolean achou = false;
        for (LiberacaoPedidoPedItem iten : ped.getLiberacaoPedidoPed().getItens()) {
            if (iten.getLiberado() != 0) continue;
            achou = true;
        }
        if (!achou) {
            ped.getLiberacaoPedidoPed().setLiberado(Short.valueOf((short)1));
            ped.getLiberacaoPedidoPed().setDataLiberacaoTdItens(new Date());
        } else {
            ped.getLiberacaoPedidoPed().setLiberado(Short.valueOf((short)0));
            if (op.getSituacaoPedidosBloqueio() != null) {
                ped.setSituacaoPedido(op.getSituacaoPedidosBloqueio());
            }
        }
    }

    private List<ConfigValPedidosItem> filtrar(List<ConfigValPedidosItem> itens, short tipoValidacao) {
        return itens.stream().filter(item -> item.getTipoValidacao() == tipoValidacao && item.getAtivo() == 1).collect(Collectors.toList());
    }

    private boolean avaliarRegraItemPedidoEbloqueia(ConfigValPedidosItem r, ItemPedido item, Map<String, Object> values) throws ExceptionBase {
        if (r.getAvaliadorExpressoes() == null) {
            throw new ExceptionInvalidData("E.ERP.1553.001", new Object[]{r});
        }
        values.put(ItemPedido.class.getCanonicalName(), item);
        DTOResultCalcExpressoes found = CompAvaliadorExpressoes.processAndValidateValue(r.getAvaliadorExpressoes(), values, false, (ListenerAvaliadorExpressoes)new CompAvaExpVariablePedido());
        return found.getResultado() > 0.0;
    }

    private boolean avaliarRegraInfPagEbloqueia(ConfigValPedidosItem r, InfPagamentoPedido infPag, Map<String, Object> values) throws ExceptionBase {
        if (r.getAvaliadorExpressoes() == null) {
            throw new ExceptionInvalidData("E.ERP.1553.001", new Object[]{r});
        }
        values.put(InfPagamentoPedido.class.getCanonicalName(), infPag);
        DTOResultCalcExpressoes found = CompAvaliadorExpressoes.processAndValidateValue(r.getAvaliadorExpressoes(), values, false, (ListenerAvaliadorExpressoes)new CompAvaExpVariablePedido());
        return found.getResultado() > 0.0;
    }

    private void avaliarRegra(ConfigValPedidosItem r, ValidacaoPedidoItem val, Pedido pedido, Map<String, Object> values, List<ConfigValPedidosItem> regras) throws ExceptionBase {
        if (r.getAvaliadorExpressoes() == null) {
            throw new ExceptionInvalidData("E.ERP.1553.001", new Object[]{r});
        }
        if (r.getAtivo() == 0) {
            return;
        }
        values.put(Pedido.class.getCanonicalName(), pedido);
        DTOResultCalcExpressoes found = CompAvaliadorExpressoes.processAndValidateValue(r.getAvaliadorExpressoes(), values, false, (ListenerAvaliadorExpressoes)new CompAvaExpVariablePedido());
        if (found.getResultado() > 0.0) {
            LiberacaoPedidoPedItem bl = this.findItemLiberacao(pedido.getLiberacaoPedidoPed(), r);
            if (bl == null) {
                bl = new LiberacaoPedidoPedItem();
                bl.setItemValBloqueio(r);
                bl.setLiberado(Short.valueOf((short)0));
                bl.setObservacao(found.getAvaliadorExpressoes().getDescricao());
                bl.setLiberacaoPedidoPed(pedido.getLiberacaoPedidoPed());
                pedido.getLiberacaoPedidoPed().getItens().add(bl);
                val.getItens().add(bl);
            }
            regras.add(bl.getItemValBloqueio());
        }
    }

    private void validarItensPedido(ConfigValPedidos conf, ValidacaoPedidoItem val, ItemPedido item, LiberacaoPedidoPed liberacao, Map<String, Object> values, List<ConfigValPedidosItem> rules) throws ExceptionBase {
        List<ConfigValPedidosItem> regrasValPed = this.filtrar(conf.getItens(), (short)1);
        for (ConfigValPedidosItem r : regrasValPed) {
            boolean res;
            if (r.getAtivo() != 1 || !(res = this.avaliarRegraItemPedidoEbloqueia(r, item, values))) continue;
            LiberacaoPedidoPedItem found = this.findItemLiberacao(liberacao, r, item);
            if (found == null) {
                LiberacaoPedidoPedItem bl = new LiberacaoPedidoPedItem();
                bl.setItemValBloqueio(r);
                bl.setLiberado(Short.valueOf((short)0));
                bl.setObservacao(item.toString());
                bl.setLiberacaoPedidoPed(liberacao);
                bl.setItemPedido(item);
                val.getItens().add(bl);
                if (liberacao != null) {
                    liberacao.getItens().add(bl);
                }
            }
            if (rules == null) continue;
            rules.add(r);
        }
    }

    private void validarInfPagPedido(ConfigValPedidos conf, ValidacaoPedidoItem val, InfPagamentoPedido infPagPedido, LiberacaoPedidoPed liberacao, Map<String, Object> values, List<ConfigValPedidosItem> rules) throws ExceptionBase {
        List<ConfigValPedidosItem> regrasValPed = this.filtrar(conf.getItens(), (short)3);
        for (ConfigValPedidosItem r : regrasValPed) {
            boolean res;
            if (r.getAtivo() != 1 || !(res = this.avaliarRegraInfPagEbloqueia(r, infPagPedido, values))) continue;
            LiberacaoPedidoPedItem found = this.findItemLiberacao(liberacao, r);
            if (found == null) {
                LiberacaoPedidoPedItem bl = new LiberacaoPedidoPedItem();
                bl.setItemValBloqueio(r);
                bl.setLiberado(Short.valueOf((short)0));
                bl.setObservacao(infPagPedido.toString());
                bl.setLiberacaoPedidoPed(liberacao);
                val.getItens().add(bl);
                if (liberacao != null) {
                    liberacao.getItens().add(bl);
                }
            }
            if (rules == null) continue;
            rules.add(r);
        }
    }

    private LiberacaoPedidoPedItem findItemLiberacao(LiberacaoPedidoPed liberacao, ConfigValPedidosItem r, ItemPedido itemPed) {
        if (liberacao == null || liberacao.getItens() == null) {
            return null;
        }
        for (LiberacaoPedidoPedItem iten : liberacao.getItens()) {
            if (iten.getItemValBloqueio() == null || !iten.getItemValBloqueio().equals((Object)r) || iten.getItemPedido() == null || !iten.getItemPedido().equals((Object)itemPed)) continue;
            return iten;
        }
        return null;
    }

    private LiberacaoPedidoPedItem findItemLiberacao(LiberacaoPedidoPed liberacao, ConfigValPedidosItem r) {
        if (liberacao == null || liberacao.getItens() == null) {
            return null;
        }
        Optional<LiberacaoPedidoPedItem> found = liberacao.getItens().stream().filter(item -> item.getItemValBloqueio() != null && item.getItemValBloqueio().equals((Object)r)).findFirst();
        if (found.isPresent()) {
            return found.get();
        }
        return null;
    }

    private void buildStringText(ValidacaoPedidoItem val) {
        StringBuilder sb = new StringBuilder();
        for (LiberacaoPedidoPedItem iten : val.getItens()) {
            sb.append("").append(iten != null && iten.getItemValBloqueio() != null ? iten.getItemValBloqueio().getDescricao() : "Item Bloqueio nao informado.").append(" Obs: ").append(iten.getObservacao()).append("\n");
        }
        val.setProblemasEncontrados(sb.toString());
    }

    private Map<String, Object> buildDefMap(Pedido vo, OpcoesFinanceiras opFinanceiras, OpcoesFaturamento opFat, EnumValidacaoPedido tipoVal) {
        HashMap<String, Object> values = new HashMap<String, Object>();
        if (vo != null) {
            UnidadeFatCliente unidadeFatCliente = vo.getUnidadeFatCliente();
            values.put(Pessoa.class.getCanonicalName(), unidadeFatCliente.getCliente().getPessoa());
            values.put(SituacaoPedidos.class.getCanonicalName(), vo.getSituacaoPedido());
            values.put(GrupoPessoas.class.getCanonicalName(), unidadeFatCliente.getCliente().getPessoa().getGrupoPessoas());
            values.put(Cliente.class.getCanonicalName(), unidadeFatCliente.getCliente());
            values.put(UnidadeFatCliente.class.getCanonicalName(), unidadeFatCliente);
            values.put(Representante.class.getCanonicalName(), vo.getRepresentante());
            values.put(Pedido.class.getCanonicalName(), vo);
            values.put(TipoFrete.class.getCanonicalName(), vo.getTipoFrete());
            values.put(CondicoesPagamento.class.getCanonicalName(), vo.getCondicoesPagamento());
            values.put(MeioPagamento.class.getCanonicalName(), vo.getMeioPagamento());
            values.put(OpcoesFaturamento.class.getCanonicalName(), opFat);
            values.put(Usuario.class.getCanonicalName(), vo.getUsuarioUltMod());
            if (vo.getUsuarioUltMod() != null) {
                values.put(Grupo.class.getCanonicalName(), this.helperUsuario.getGrupo(vo.getUsuarioUltMod().getUsuarioBasico(), vo.getEmpresa()));
            }
            values.put(OpcoesFinanceiras.class.getCanonicalName(), opFinanceiras);
            values.put(NaturezaOperacao.class.getCanonicalName(), vo.getNaturezaOperacao());
            values.put("local_avaliacao_corrente", tipoVal.value);
        }
        return values;
    }

    private void buildLiberacao(Pedido pedido) {
        LiberacaoPedidoPed l = pedido.getLiberacaoPedidoPed();
        if (l == null) {
            l = new LiberacaoPedidoPed();
            l.setPedido(pedido);
            pedido.setLiberacaoPedidoPed(l);
        }
    }

    private boolean validarPedido(EnumValidacaoPedido validarPedido, OpcoesFinanceiras opcoesFinanceiras) {
        boolean validar = true;
        switch (validarPedido) {
            case COTACAO_VENDAS: {
                validar = opcoesFinanceiras.getVerificaLimiteCotacaoVendas() == 1;
                break;
            }
            case CTE: {
                validar = opcoesFinanceiras.getVerificaLimiteCte() == 1;
                break;
            }
            case EXPEDICAO: {
                validar = opcoesFinanceiras.getVerificaLimiteExpedicao() == 1;
                break;
            }
            case FATURAMENTO: {
                validar = opcoesFinanceiras.getVerificaLimiteNFPropria() == 1;
                break;
            }
            case NOTA_PROPRIA: {
                validar = opcoesFinanceiras.getVerificaLimiteNFPropria() == 1;
                break;
            }
            case PEDIDO: {
                validar = opcoesFinanceiras.getVerificaLimitePedido() == 1;
                break;
            }
            case SAIDA_NOTAS: {
                validar = opcoesFinanceiras.getVerificaLimiteSaida() == 1;
                break;
            }
            case PLANEJAMENTO_PROD: {
                validar = opcoesFinanceiras.getVerificaLimitePlanProd() == 1;
                break;
            }
            case SITUACAO_PEDIDOS: {
                validar = opcoesFinanceiras.getVerificaLimiteSitPed() == 1;
                break;
            }
            case LIBERACAO_PEDIDOS: {
                validar = opcoesFinanceiras.getVerificaLimiteLibPed() == 1;
                break;
            }
            case PRE_VENDA: {
                validar = opcoesFinanceiras.getVerificaLimitePreVenda() == 1;
                break;
            }
            case NAO_VALIDAR: {
                validar = false;
            }
        }
        return validar;
    }

    private void liberarAutomaticamentePed(List<ConfigValPedidosItem> rules, Pedido pedido) {
        for (LiberacaoPedidoPedItem iten : pedido.getLiberacaoPedidoPed().getItens()) {
            Optional<ConfigValPedidosItem> found = rules.stream().filter(confItem -> confItem.equals((Object)iten.getItemValBloqueio())).findFirst();
            if (!found.isPresent() && iten.getLiberado().equals((short)0)) {
                iten.setLiberado(Short.valueOf((short)1));
                iten.setObservacao("Liberado automaticamente pelo Mentor.");
            }
            if (!found.isPresent() || !iten.getLiberado().equals((short)1) || iten.getUsuario() != null) continue;
            iten.setLiberado(Short.valueOf((short)0));
            iten.setObservacao("");
        }
    }

    private void removerItensSemLibPos(LiberacaoPedidoPed l) {
        ArrayList<LiberacaoPedidoPedItem> toRem = new ArrayList<LiberacaoPedidoPedItem>();
        for (LiberacaoPedidoPedItem item : l.getItens()) {
            if (item.getItemValBloqueio().getTipoValPedidos() != 1 && item.getItemValBloqueio().getTipoValPedidos() != 0) continue;
            toRem.add(item);
        }
        l.getItens().removeAll(toRem);
    }

    private void checarItensBloq(LiberacaoPedidoPed l, List<LiberacaoPedidoPedItem> temp) {
        for (LiberacaoPedidoPedItem item : l.getItens()) {
            if (!item.getLiberado().equals((short)0) || temp.contains(item)) continue;
            temp.add(item);
        }
    }
}

