/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.components.wmspedido;

import com.touchcomp.basementor.constants.enums.wmspedido.EnumConstTipoMovimentacaoWMS;
import com.touchcomp.basementor.model.vo.Expedicao;
import com.touchcomp.basementor.model.vo.GradeCor;
import com.touchcomp.basementor.model.vo.GradeItemPedido;
import com.touchcomp.basementor.model.vo.ItemPedido;
import com.touchcomp.basementor.model.vo.ItemPedidoEmbalagemProduto;
import com.touchcomp.basementor.model.vo.ProdutoGrade;
import com.touchcomp.basementor.model.vo.Usuario;
import com.touchcomp.basementor.model.vo.WmsOpcoes;
import com.touchcomp.basementor.model.vo.WmsPedido;
import com.touchcomp.basementor.model.vo.WmsPedidoItem;
import com.touchcomp.basementor.model.vo.WmsPedidoItemEmb;
import com.touchcomp.basementor.model.vo.WmsPedidoItemGrade;
import com.touchcomp.basementorexceptions.exceptions.impl.invalidstate.ExceptionInvalidState;
import com.touchcomp.basementorservice.components.wmspedido.CompWmsPedidoStatus;
import com.touchcomp.basementorservice.helpers.impl.wmspedido.HelperWmsPedido;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.util.Date;
import java.util.List;
import java.util.Optional;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Component;

@Component
public class CompWmsPedido {
    @Autowired
    CompWmsPedidoStatus compStatus;
    @Autowired
    HelperWmsPedido helper;

    public void gerarWmsPedido(List<Expedicao> expedicoes, WmsOpcoes opcoes, Usuario usuarioSolicitante) throws ExceptionInvalidState {
        for (Expedicao expedicao : expedicoes) {
            this.gerarWmsPedido(expedicao, opcoes, usuarioSolicitante);
        }
    }

    public void gerarWmsPedido(Expedicao expedicao, WmsOpcoes opcoes, Usuario usuarioSolicitante) throws ExceptionInvalidState {
        WmsPedido w = expedicao.getWmsPedido();
        if (w == null) {
            w = new WmsPedido();
        }
        expedicao.setWmsPedido(w);
        w.setExpedicao(expedicao);
        w.setDataCadastro(new Date());
        w.setDataSolicitacao(new Date());
        w.setDescricao(expedicao.getPedido().toString());
        w.setEmpresa(expedicao.getEmpresa());
        w.setUsuarioSolicitante(usuarioSolicitante);
        w.setTipoMovimentacao(EnumConstTipoMovimentacaoWMS.TIPO_MOVIMENTACAO_TRANSFERENCIA.getEnumId());
        this.compStatus.setStatusPedido(opcoes.getStatusPedidoSolicitacao(), w);
        for (ItemPedido itemPedido : expedicao.getPedido().getItemPedido()) {
            Optional<GradeCor> foundGrPrin;
            WmsPedidoItem it = new WmsPedidoItem();
            it.setProduto(itemPedido.getProduto());
            it.setWmsPedido(w);
            w.getItens().add(it);
            boolean setouGrPrinc = false;
            if (!it.getProduto().getGradesProduto().isEmpty() && (foundGrPrin = ((ProdutoGrade)it.getProduto().getGradesProduto().get(0)).getGradesCores().stream().filter(i -> ToolMethods.isAffirmative((Number)i.getGradePrincipal())).findFirst()).isPresent()) {
                double total = itemPedido.getGradeItemPedido().stream().mapToDouble(i -> i.getQuantidade()).sum();
                WmsPedidoItemGrade wg = new WmsPedidoItemGrade();
                wg.setGradeCor(foundGrPrin.get());
                wg.setQuantidade(Double.valueOf(total));
                wg.setWmsPedidoItem(it);
                it.getGrades().add(wg);
                setouGrPrinc = true;
            }
            if (!setouGrPrinc) {
                for (GradeItemPedido gradeItemPedido : itemPedido.getGradeItemPedido()) {
                    WmsPedidoItemGrade wg = new WmsPedidoItemGrade();
                    wg.setGradeCor(gradeItemPedido.getGradeCor());
                    wg.setQuantidade(gradeItemPedido.getQuantidade());
                    wg.setWmsPedidoItem(it);
                    it.getGrades().add(wg);
                }
            }
            for (ItemPedidoEmbalagemProduto item : itemPedido.getItemPedidoEmbalagemProduto()) {
                WmsPedidoItemEmb em = new WmsPedidoItemEmb();
                em.setEmbalagem(item.getEmbalagem());
                em.setNrEmbalagem(Integer.valueOf(item.getNrEmbalagem().intValue()));
                em.setQtdePorEmbalagem(item.getQtdePorEmbalagem());
                em.setItemPedidoWms(it);
                it.getItensEmbalagens().add(em);
            }
        }
        if (opcoes.getSituacaoPedVendaWmsSol() != null) {
            expedicao.getPedido().setSituacaoPedido(opcoes.getSituacaoPedVendaWmsSol());
        }
        this.helper.build(w).calcularTotais();
        this.helper.reservarPedido(w, opcoes);
    }
}

