/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.dao;

import com.touchcomp.basementor.constants.enums.statusobjeto.EnumConstStatusObjeto;
import com.touchcomp.basementor.model.interfaces.InterfaceVO;
import com.touchcomp.basementorservice.dao.DAOGenericEntity;
import com.touchcomp.basementorservice.dao.DaoGenericImpl;
import com.touchcomp.basementorservice.dao.builders.AuxCriteriaBuilder;
import com.touchcomp.basementorservice.data.DataCacheService;
import com.touchcomp.basementortools.model.reflection.FieldClassInfo;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementortools.tools.reflections.ToolReflections;
import java.io.Serializable;
import java.lang.reflect.Field;
import java.lang.reflect.Method;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.persistence.Id;
import javax.persistence.Version;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.hibernate.Criteria;
import org.hibernate.LockMode;
import org.hibernate.Query;
import org.hibernate.criterion.CriteriaSpecification;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.ProjectionList;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.metadata.ClassMetadata;
import org.hibernate.transform.Transformers;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public abstract class DaoGenericEntityImpl<E extends InterfaceVO, K extends Serializable>
extends DaoGenericImpl
implements DAOGenericEntity<E, K> {
    protected Class<E> entityClass = ToolReflections.getGenericTypeClass(this.getClass());
    @Autowired
    private DataCacheService dataCacheService;

    @Override
    public Class<E> getEntityClass() {
        return this.entityClass;
    }

    @Override
    public void flushData() {
        this.getSession().flush();
    }

    @Override
    public E saveOrUpdate(E entity) {
        if (entity == null) {
            return entity;
        }
        InterfaceVO result = (InterfaceVO)this.getSession().merge(entity);
        this.dataCacheService.reloadCache(entity.getClass());
        return (E)result;
    }

    @Override
    public List<E> saveOrUpdate(Collection<E> entity) {
        LinkedList temp = new LinkedList();
        if (entity == null) {
            return temp;
        }
        entity.forEach(i -> temp.add(this.saveOrUpdate(i)));
        return temp;
    }

    @Override
    public boolean delete(E entity) {
        if (entity == null) {
            return true;
        }
        this.getSession().delete(entity);
        return true;
    }

    @Override
    public Criteria restrictions(Criterion ... crits) {
        Criteria crit = this.criteria();
        for (Criterion cr : crits) {
            crit.add(cr);
        }
        return crit;
    }

    @Override
    public boolean deleteCollection(Collection<E> entity) {
        if (entity == null) {
            return true;
        }
        entity.forEach(i -> this.delete(i));
        return true;
    }

    @Override
    public boolean deleteById(K id) {
        if (id == null) {
            return true;
        }
        InterfaceVO found = (InterfaceVO)this.getSession().get(this.getEntityClass(), id);
        this.delete(found);
        return true;
    }

    @Override
    public E get(K id) {
        if (id == null || id instanceof Number && ((Number)id).longValue() <= 0L) {
            return null;
        }
        return (E)((InterfaceVO)this.getSession().get(this.getEntityClass(), id));
    }

    @Override
    public List<E> gets(K ... ids) {
        if (ids == null || ids.length == 0) {
            return new LinkedList();
        }
        Criteria crit = this.criteria();
        crit.add(Restrictions.in((String)this.getFieldID(), (Object[])ids));
        return crit.list();
    }

    @Override
    public List<E> gets(Collection<K> ids) {
        if (!ToolMethods.isWithData(ids)) {
            return new LinkedList();
        }
        Criteria crit = this.criteria();
        crit.add(Restrictions.in((String)this.getFieldID(), ids));
        return crit.list();
    }

    @Override
    public E get(String id) {
        if (id == null || id.length() == 0) {
            return null;
        }
        return (E)((InterfaceVO)this.getSession().get(this.getEntityClass(), (Serializable)Long.valueOf(id)));
    }

    @Override
    public List<E> getAll() {
        CriteriaBuilder qb = this.getSessionFactory().getCriteriaBuilder();
        CriteriaQuery cq = qb.createQuery(this.getEntityClass());
        Root root = cq.from(this.entityClass);
        cq.select((Selection)root);
        return this.getSession().createQuery(cq).list();
    }

    @Override
    public List<E> getAllByStatus(EnumConstStatusObjeto status) {
        return this.toList(this.restrictions(this.eq("ativo", status.getValue())));
    }

    @Override
    public List<E> findAllAtivos() {
        return this.getAllByStatus(EnumConstStatusObjeto.ATIVO);
    }

    @Override
    public E getAtivo(K id) {
        if (id == null || id instanceof Number && ((Number)id).longValue() <= 0L) {
            return null;
        }
        Criteria c = this.criteria();
        c.add(this.eq(this.getFieldID(), id));
        c.add(this.eq("ativo", EnumConstStatusObjeto.ATIVO.getValue()));
        return (E)((InterfaceVO)c.uniqueResult());
    }

    @Override
    public List<E> getAll(Long firstResult, Long numberOF) {
        CriteriaBuilder qb = this.getSessionFactory().getCriteriaBuilder();
        CriteriaQuery cq = qb.createQuery(this.getEntityClass());
        Root root = cq.from(this.entityClass);
        cq.select((Selection)root);
        return this.getSession().createQuery(cq).setFirstResult(firstResult.intValue()).setMaxResults(numberOF.intValue()).list();
    }

    @Override
    public Long countOf() {
        return (Long)this.criteria().setProjection(Projections.rowCount()).uniqueResult();
    }

    @Override
    public E getFirst() {
        Criteria crit = this.criteria();
        crit.setMaxResults(1);
        ClassMetadata meta = this.getSessionFactory().getClassMetadata(this.getEntityClass());
        crit.addOrder(Order.asc((String)meta.getIdentifierPropertyName()));
        return (E)((InterfaceVO)crit.uniqueResult());
    }

    @Override
    public E getLast() {
        Criteria crit = this.criteria();
        crit.setMaxResults(1);
        ClassMetadata meta = this.getSessionFactory().getClassMetadata(this.getEntityClass());
        crit.addOrder(Order.desc((String)meta.getIdentifierPropertyName()));
        return (E)((InterfaceVO)crit.uniqueResult());
    }

    @Override
    public E refresh(E entity) {
        if (entity == null) {
            return entity;
        }
        this.getSession().refresh(entity);
        return entity;
    }

    @Override
    public Criteria criteria() {
        return super.criteria(this.getEntityClass());
    }

    @Override
    public E toUnique(Criteria crit) {
        crit.setMaxResults(1);
        return (E)((InterfaceVO)super.toUnique(crit));
    }

    public E toUnique(Query crit) {
        crit.setMaxResults(1);
        return (E)((InterfaceVO)super.toUnique(crit));
    }

    public List<E> toList(Criteria crit) {
        crit.setResultTransformer(CriteriaSpecification.DISTINCT_ROOT_ENTITY);
        return crit.list();
    }

    public Long toRowCount(Criteria crit) {
        crit.setProjection(Projections.rowCount());
        Long ret = (Long)crit.uniqueResult();
        if (ret == null) {
            ret = 0L;
        }
        return ret;
    }

    public List<E> toList(Query crit) {
        crit.setResultTransformer(CriteriaSpecification.DISTINCT_ROOT_ENTITY);
        return crit.list();
    }

    protected String getFieldVersion() {
        List mh = ToolReflections.getGetMethodsWithAnnotation(this.getEntityClass(), Version.class);
        if (!mh.isEmpty()) {
            return ToolReflections.getFieldName((Method)((Method)mh.get(0)));
        }
        List fi = ToolReflections.getFieldWithAnnotation(this.getEntityClass(), Version.class);
        if (!fi.isEmpty()) {
            return ToolReflections.getFieldName((Field)((Field)fi.get(0)));
        }
        throw new RuntimeException("Class does not contains @Version attribute " + this.getClass().getCanonicalName());
    }

    protected String getFieldID() {
        List mh = ToolReflections.getGetMethodsWithAnnotation(this.getEntityClass(), Id.class);
        if (!mh.isEmpty()) {
            return ToolReflections.getFieldName((Method)((Method)mh.get(0)));
        }
        List fi = ToolReflections.getFieldWithAnnotation(this.getEntityClass(), Id.class);
        if (!fi.isEmpty()) {
            return ToolReflections.getFieldName((Field)((Field)fi.get(0)));
        }
        throw new RuntimeException("Class does not contains @Id attribute");
    }

    @Override
    public <S> S getSimpleDTO(Long identificador, Class<S> classTo) {
        try {
            Criteria c = this.criteria();
            ProjectionList projections = Projections.projectionList();
            List fields = ToolReflections.getFieldClass((String)classTo.getName());
            for (FieldClassInfo field : fields) {
                projections.add((Projection)Projections.property((String)field.getFieldName()), field.getFieldName());
            }
            c.setProjection((Projection)projections);
            c.setResultTransformer(Transformers.aliasToBean(classTo));
            c.add(this.eq("identificador", identificador));
            return (S)c.uniqueResult();
        }
        catch (Exception e) {
            throw new RuntimeException(e);
        }
    }

    @Override
    public void evict(List<E> data) {
        for (InterfaceVO e : data) {
            this.evict(e);
        }
    }

    @Override
    public void evict(E data) {
        if (data == null) {
            return;
        }
        this.getSession().evict(data);
    }

    @Override
    public E attachSession(E data) {
        if (data == null) {
            return data;
        }
        if (this.getSession().contains(data)) {
            return data;
        }
        this.getSession().lock(data, LockMode.NONE);
        return data;
    }

    public AuxCriteriaBuilder queryBuilder() {
        AuxCriteriaBuilder aux = this.queryBuilder(this.getEntityClass());
        aux.from();
        return aux;
    }

    public CriteriaBuilder criteriaBuilder() {
        return this.criteriaBuilder(this.getEntityClass());
    }
}

