/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.dao;

import com.touchcomp.basementorexceptions.exceptions.impl.erroprogramacao.ExceptionErroProgramacao;
import com.touchcomp.basementorexceptions.exceptions.impl.reflection.ExceptionReflection;
import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementorservice.dao.DAOGeneric;
import com.touchcomp.basementorservice.dao.builders.AuxCriteriaBuilder;
import com.touchcomp.basementorservice.dao.builders.AuxCriterionBuilder;
import com.touchcomp.basementorservice.model.genericmap.GenericEnumInterface;
import com.touchcomp.basementorservice.model.genericmap.GenericMapValues;
import com.touchcomp.basementorspringcontext.ConfApplicationContext;
import com.touchcomp.basementorspringcontext.Context;
import com.touchcomp.basementortools.constants.EnumConstantsCriteria;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementortools.tools.reflections.ToolReflections;
import java.util.Collection;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import java.util.Set;
import java.util.StringTokenizer;
import java.util.logging.Level;
import java.util.logging.Logger;
import javax.persistence.EntityManager;
import javax.persistence.PersistenceContext;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.From;
import javax.persistence.criteria.Predicate;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.SQLQuery;
import org.hibernate.Session;
import org.hibernate.SessionFactory;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.ProjectionList;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.query.NativeQuery;
import org.hibernate.sql.JoinType;
import org.hibernate.transform.AliasToEntityMapResultTransformer;
import org.hibernate.transform.ResultTransformer;
import org.springframework.beans.factory.annotation.Autowired;
import org.springframework.stereotype.Repository;

@Repository
public abstract class DaoGenericImpl
implements DAOGeneric {
    @PersistenceContext
    private EntityManager entityManager;
    @Autowired
    private AuxCriterionBuilder auxCriterionBuilder;
    private final TLogger logger = TLogger.get(this.getClass());
    public static final String BASE_ALIAS = "aux";

    @Override
    public SessionFactory getSessionFactory() {
        return (SessionFactory)Context.get(SessionFactory.class);
    }

    @Override
    public EntityManager getEntityManager() {
        return this.entityManager;
    }

    @Override
    public Criteria criteria(Class<?> voClass) {
        return this.getSession().createCriteria(voClass, BASE_ALIAS);
    }

    @Override
    public Criteria criteria(String voClass) {
        return this.getSession().createCriteria(voClass, BASE_ALIAS);
    }

    @Override
    public Criteria criteria(String voClass, String alias) {
        return this.getSession().createCriteria(voClass, alias);
    }

    @Override
    public Criteria fields(Criteria crit, String ... fields) {
        ProjectionList list = Projections.projectionList();
        for (String str : fields) {
            list.add(Projections.alias((Projection)Projections.property((String)str), (String)str));
        }
        crit.setProjection((Projection)list);
        return crit;
    }

    @Override
    public Criteria fields(Criteria crit, String[] ... fields) {
        ProjectionList list = Projections.projectionList();
        for (String[] str : fields) {
            list.add(Projections.alias((Projection)Projections.property((String)str[0]), (String)str[1]));
        }
        crit.setProjection((Projection)list);
        return crit;
    }

    @Override
    public Criteria order(Criteria crit, String ... fields) {
        for (String str : fields) {
            crit.addOrder(Order.asc((String)str));
        }
        return crit;
    }

    @Override
    public Criteria alias(Criteria crit, String[] ... alias) {
        for (String[] str : alias) {
            crit.createAlias(str[0], str[1]);
        }
        return crit;
    }

    @Override
    public Criteria restrictions(Criteria crit, Criterion ... crits) {
        for (Criterion cr : crits) {
            crit.add(cr);
        }
        return crit;
    }

    @Override
    public Criteria orderDesc(Criteria crit, String ... fields) {
        for (String str : fields) {
            crit.addOrder(Order.desc((String)str));
        }
        return crit;
    }

    public org.hibernate.query.Query query(String query) {
        return this.getSession().createQuery(query);
    }

    public NativeQuery sqlQuery(String query) {
        return this.getSession().createNativeQuery(query);
    }

    @Override
    public Session getSession() {
        return this.getSessionFactory().getCurrentSession();
    }

    @Override
    public void doLogError(Throwable t) {
        this.logger.error(t.getClass(), t);
    }

    @Override
    public List<Map<String, Object>> toHashList(Criteria crit) {
        crit.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        return crit.list();
    }

    @Override
    public List<Map<String, Object>> toHashList(Query query) {
        query.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        return query.list();
    }

    @Override
    public List<Map<String, Object>> toHashList(SQLQuery query) {
        query.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        return query.list();
    }

    @Override
    public Map<String, Object> toHashUnique(Criteria crit) {
        crit.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        crit.setMaxResults(1);
        return (Map)crit.uniqueResult();
    }

    @Override
    public Map<String, Object> toHashUnique(Query query) {
        query.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        query.setMaxResults(1);
        return (Map)query.uniqueResult();
    }

    @Override
    public Map<String, Object> toHashUnique(SQLQuery query) {
        query.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        query.setMaxResults(1);
        return (Map)query.uniqueResult();
    }

    public Object toUnique(Criteria crit) {
        crit.setMaxResults(1);
        return crit.uniqueResult();
    }

    @Override
    public Object toUnique(Query query) {
        query.setMaxResults(1);
        return query.uniqueResult();
    }

    @Override
    public Criterion getExpression(String string, String fieldClass, EnumConstantsCriteria filter, Object value1) {
        return this.getExpression(string, fieldClass, filter, value1, null);
    }

    @Override
    public Criterion getExpression(String string, String fieldClass, EnumConstantsCriteria filter, Object value1, Object value2) {
        return this.auxCriterionBuilder.getExpression(string, fieldClass, filter, value1, value2);
    }

    @Override
    public Predicate getPredicate(CriteriaBuilder builder, CriteriaQuery criteria, From from, String atributo, String classe, EnumConstantsCriteria op, Object value1, Object value2) {
        return this.auxCriterionBuilder.getPredicate(builder, criteria, from, atributo, classe, op, value1, value2);
    }

    public Predicate getPredicate(CriteriaBuilder builder, Expression expression, String atributo, String classe, EnumConstantsCriteria op, Object value1, Object value2) {
        return this.auxCriterionBuilder.getPredicate(builder, expression, atributo, classe, op, value1, value2);
    }

    protected String addField(Criteria c, String basePath, String aliasField, List<String> aliases, ProjectionList list) {
        String aux = this.createAliasField(c, basePath, aliases);
        list.add(Projections.alias((Projection)Projections.property((String)aux), (String)String.valueOf(aliasField)));
        return aux;
    }

    protected String addField(Criteria c, String pathField, List<String> aliases, ProjectionList list) {
        String aux = this.createAliasField(c, pathField, aliases);
        list.add((Projection)Projections.property((String)aux));
        return aux;
    }

    protected void addOrder(Criteria c, String pathField, List<String> repoAliases) {
        String aux = this.createAliasField(c, pathField, repoAliases);
        c.addOrder(Order.asc((String)aux));
    }

    protected void addOrderDesc(Criteria c, String pathField, List<String> repoAliases) {
        String aux = this.createAliasField(c, pathField, repoAliases);
        c.addOrder(Order.desc((String)aux));
    }

    public String createAliasField(Criteria c, String pathField, List<String> aliases) {
        String token;
        Object baseAlias = BASE_ALIAS;
        StringTokenizer sk = new StringTokenizer(pathField, ".");
        int count = sk.countTokens();
        if (count > 1) {
            for (int i = 0; i < count - 1; ++i) {
                token = sk.nextToken();
                String alias = (String)baseAlias + "_" + i + "_" + token;
                if (!aliases.contains(alias)) {
                    c.createAlias((String)baseAlias + "." + token, alias, JoinType.LEFT_OUTER_JOIN);
                    aliases.add(alias);
                }
                baseAlias = alias;
            }
        }
        token = sk.nextToken();
        String aux = (String)baseAlias + "." + token;
        return aux;
    }

    @Override
    public Criterion notEqual(String field, Object value) {
        return Restrictions.ne((String)field, (Object)value);
    }

    @Override
    public Criterion isNotEmpty(String field) {
        return Restrictions.isNotEmpty((String)field);
    }

    @Override
    public Criterion ilikeLeft(String field, Object value) {
        if (value == null) {
            value = "";
        }
        return Restrictions.ilike((String)field, (Object)("%" + String.valueOf(value)));
    }

    @Override
    public Criterion ilikeRight(String field, Object value) {
        if (value == null) {
            value = "";
        }
        return Restrictions.ilike((String)field, (Object)(String.valueOf(value) + "%"));
    }

    @Override
    public Criterion ilike(String field, Object value) {
        if (value == null) {
            value = "";
        }
        return Restrictions.ilike((String)field, (Object)("%" + String.valueOf(value) + "%"));
    }

    @Override
    public Criterion likeLeft(String field, Object value) {
        if (value == null) {
            value = "";
        }
        return Restrictions.ilike((String)field, (Object)("%" + String.valueOf(value)));
    }

    @Override
    public Criterion likeRight(String field, Object value) {
        if (value == null) {
            value = "";
        }
        return Restrictions.ilike((String)field, (Object)(String.valueOf(value) + "%"));
    }

    @Override
    public Criterion like(String field, Object value) {
        if (value == null) {
            value = "";
        }
        return Restrictions.like((String)field, (Object)("%" + String.valueOf(value) + "%"));
    }

    @Override
    public Criterion lessEqual(String field, Object value) {
        return Restrictions.le((String)field, (Object)value);
    }

    @Override
    public Criterion less(String field, Object value) {
        return Restrictions.lt((String)field, (Object)value);
    }

    @Override
    public Criterion isNull(String field) {
        return Restrictions.isNull((String)field);
    }

    @Override
    public Criterion isNotNull(String field) {
        return Restrictions.isNotNull((String)field);
    }

    @Override
    public Criterion greatherEqual(String field, Object value) {
        return Restrictions.ge((String)field, (Object)value);
    }

    @Override
    public Criterion greather(String field, Object value) {
        return Restrictions.gt((String)field, (Object)value);
    }

    @Override
    public Criterion isEmpty(String field) {
        return Restrictions.isEmpty((String)field);
    }

    @Override
    public Criterion between(String field, Object value1, Object value2) {
        return Restrictions.between((String)field, (Object)value1, (Object)value2);
    }

    @Override
    public Criterion eq(String field, Object value) {
        return Restrictions.eq((String)field, (Object)value);
    }

    @Override
    public Criterion in(String field, Object ... value) {
        return Restrictions.in((String)field, (Object[])value);
    }

    @Override
    public Criterion in(String field, Collection value) {
        return Restrictions.in((String)field, (Collection)value);
    }

    @Override
    public Criterion or(Criterion ... crit) {
        return Restrictions.or((Criterion[])crit);
    }

    @Override
    public Criterion and(Criterion ... crit) {
        return Restrictions.and((Criterion[])crit);
    }

    @Override
    public Long countOf(Criteria c) {
        c.setProjection(Projections.rowCount());
        Number found = (Number)c.uniqueResult();
        return found != null ? found.longValue() : 0L;
    }

    @Override
    public Long countOf(Query q) {
        Number found = (Number)q.uniqueResult();
        return found != null ? found.longValue() : 0L;
    }

    protected void logger(Class aClass, Throwable ex) {
        Logger.getLogger(aClass.getCanonicalName()).log(Level.SEVERE, null, ex);
    }

    protected <S extends GenericEnumInterface> GenericMapValues<S> toGenMap(org.hibernate.query.Query q, Class<S> type) {
        q.setMaxResults(1);
        List<GenericMapValues<S>> res = this.toGenMapList(q, type);
        if (res != null && res.size() > 0) {
            return res.get(0);
        }
        return null;
    }

    protected <S extends GenericEnumInterface> List<GenericMapValues<S>> toGenMapList(org.hibernate.query.Query q, Class<S> type) {
        List<Map<String, Object>> values = this.toHashList((Query)q);
        return this.toGenMapList(values, type);
    }

    protected <S extends GenericEnumInterface> List<GenericMapValues<S>> toGenMapList(List<Map<String, Object>> values, Class<S> type) {
        try {
            GenericEnumInterface[] types = (GenericEnumInterface[])ToolReflections.getValuesEnum(type);
            LinkedList<GenericMapValues<S>> aux = new LinkedList<GenericMapValues<S>>();
            if (values == null || values.isEmpty()) {
                return aux;
            }
            Set<String> keys = values.get(0).keySet();
            HashMap<String, GenericEnumInterface> pairs = new HashMap<String, GenericEnumInterface>();
            for (GenericEnumInterface t : types) {
                Optional<String> found = keys.stream().filter(i -> ToolMethods.isEquals((Object)i, (Object)t.getValue())).findFirst();
                if (!found.isPresent()) continue;
                pairs.put(found.get(), t);
            }
            for (Map map : values) {
                GenericMapValues<GenericEnumInterface> g = new GenericMapValues<GenericEnumInterface>();
                aux.add(g);
                for (String key : keys) {
                    g.addValue((GenericEnumInterface)pairs.get(key), map.get(key));
                }
            }
            return aux;
        }
        catch (ExceptionReflection ex) {
            this.logger(this.getClass(), ex);
            throw new ExceptionErroProgramacao("O resultado da Query e incompativel com mapa de campos informados", (Throwable)ex);
        }
    }

    public String getIdPropertyName(String voClass) {
        try {
            Class<?> clazz = Class.forName(voClass);
            return this.getSessionFactory().getMetamodel().entity(clazz).getId(Number.class).getName();
        }
        catch (ClassNotFoundException ex) {
            this.logger(this.getClass(), ex);
            throw new ExceptionErroProgramacao(ex.getMessage(), (Throwable)ex);
        }
    }

    public Criteria criteria(Class voClass, String BASE_ALIAS) {
        return this.criteria(voClass.getCanonicalName(), BASE_ALIAS);
    }

    public <S> S getBean(Class<S> aClass) {
        return (S)ConfApplicationContext.getBean(aClass);
    }

    public AuxCriteriaBuilder queryBuilder(Class entity) {
        return new AuxCriteriaBuilder(this.getSession(), entity);
    }

    public CriteriaBuilder criteriaBuilder(Class entity) {
        return this.getSession().getEntityManagerFactory().getCriteriaBuilder();
    }
}

