/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.dao.builders;

import com.touchcomp.basementorlogger.TLogger;
import com.touchcomp.basementortools.tools.date.TDate;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementortools.tools.string.TString;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedHashMap;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import java.util.Optional;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Fetch;
import javax.persistence.criteria.FetchParent;
import javax.persistence.criteria.From;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.Order;
import javax.persistence.criteria.Path;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import lombok.Generated;
import org.hibernate.Session;
import org.hibernate.query.Query;
import org.hibernate.query.criteria.internal.path.SingularAttributePath;

public class AuxCriteriaBuilder<E> {
    private final Session session;
    private final CriteriaBuilder builder;
    private final CriteriaQuery criteria;
    private Root<E> root;
    private final Class<E> entityClass;
    private final List<Selection> auxFields = new LinkedList<Selection>();
    private final List<Order> auxOrder = new LinkedList<Order>();
    private final List<Predicate> predicates = new LinkedList<Predicate>();
    private final List<Predicate> havings = new LinkedList<Predicate>();
    private final List<Expression> groupsBy = new LinkedList<Expression>();
    private final HashMap<String, Join> joins = new HashMap();
    private final HashMap<String, Fetch> fetchs = new HashMap();
    private int maxResults = 0;
    private int firstResult = 0;
    private boolean distinct = false;

    public AuxCriteriaBuilder(Session session, Class<E> entity) {
        this.session = session;
        this.builder = session.getCriteriaBuilder();
        this.criteria = this.builder.createQuery();
        this.entityClass = entity;
        this.from();
    }

    public Root<E> from() {
        if (this.getRoot() == null) {
            this.setRoot(this.getCriteria().from(this.getEntityClass()));
        }
        return this.getRoot();
    }

    public AuxCriteriaBuilder select(String ... fields) {
        for (String field : fields) {
            this.addField((Selection)this.getRoot().get(field));
        }
        return this;
    }

    public AuxCriteriaBuilder selectAlias(String field, String alias) {
        this.addField(this.getRoot().get(field).alias(alias));
        return this;
    }

    public AuxCriteriaBuilder select(Selection ... fields) {
        for (Selection field : fields) {
            this.addField(field);
        }
        return this;
    }

    public AuxCriteriaBuilder select(From from, String ... fields) {
        for (String field : fields) {
            this.addField((Selection)from.get(field));
        }
        return this;
    }

    public AuxCriteriaBuilder select(From from, Pair ... fields) {
        for (Pair field : fields) {
            this.addField(from.get(field.getField()).alias(field.getAlias()));
        }
        return this;
    }

    public AuxCriteriaBuilder select(Pair ... pairs) {
        for (Pair field : pairs) {
            From fromIt = this.getRoot();
            if (field.getFrom() != null) {
                fromIt = field.getFrom();
            }
            Path exp = fromIt.get(field.getField());
            if (TMethods.isStrWithData((String)field.getAlias())) {
                this.addField(exp.alias(field.getAlias()));
                continue;
            }
            this.addField((Selection)exp);
        }
        return this;
    }

    public AuxCriteriaBuilder selectAlias(From from, String field, String alias) {
        this.addField(from.get(field).alias(alias));
        return this;
    }

    public Join join(String field) {
        return this.join((From)this.getRoot(), field);
    }

    public Join join(From from, String field) {
        String key = from.toString() + ".inner." + field;
        Join j = this.getJoins().get(key);
        if (j == null) {
            j = from.join(field);
        }
        this.getJoins().put(key, j);
        return j;
    }

    public Fetch joinFetch(String field) {
        return this.joinFetch((FetchParent)this.getRoot(), field);
    }

    public Fetch joinFetch(FetchParent from, String field) {
        String key = from.toString() + ".inner." + field;
        Fetch j = this.getFetchs().get(key);
        if (j == null) {
            j = from.fetch(field);
        }
        this.getFetchs().put(key, j);
        return j;
    }

    public Join joinLeft(String field) {
        return this.joinLeft((From)this.getRoot(), field);
    }

    public Join joinLeft(From from, String field) {
        String key = from.toString() + ".left." + field;
        Join j = this.getJoins().get(key);
        if (j == null) {
            j = from.join(field, JoinType.LEFT);
        }
        this.getJoins().put(key, j);
        return j;
    }

    public Fetch joinLeftFetch(String field) {
        return this.joinLeftFetch((FetchParent)this.getRoot(), field);
    }

    public Fetch joinLeftFetch(FetchParent from, String field) {
        String key = from.toString() + ".left." + field;
        Fetch j = this.getFetchs().get(key);
        if (j == null) {
            j = from.fetch(field, JoinType.LEFT);
        }
        this.getFetchs().put(key, j);
        return j;
    }

    public Join joinRight(String field) {
        return this.joinRight((From)this.getRoot(), field);
    }

    public Join joinRight(From from, String field) {
        String key = from.toString() + ".right." + field;
        Join j = this.getJoins().get(key);
        if (j == null) {
            j = from.join(field, JoinType.RIGHT);
        }
        this.getJoins().put(key, j);
        return j;
    }

    public Fetch joinRightFetch(String field) {
        return this.joinRightFetch((From)this.getRoot(), field);
    }

    public Fetch joinRightFetch(From from, String field) {
        String key = from.toString() + ".right." + field;
        Fetch j = this.getFetchs().get(key);
        if (j == null) {
            j = from.fetch(field, JoinType.RIGHT);
        }
        this.getFetchs().put(key, j);
        return j;
    }

    public AuxCriteriaBuilder paginate(int page, int numberRegs) {
        this.setFirstResult(page).setMaxResults(numberRegs);
        return this;
    }

    public Object getUniqueGenericResult() {
        this.prepare();
        Query q = this.session.createQuery(this.getCriteria());
        q.setMaxResults(1);
        List result = q.getResultList();
        if (result.size() > 0) {
            return result.get(0);
        }
        return null;
    }

    public List getResult() {
        this.prepare();
        Query q = this.session.createQuery(this.getCriteria());
        if (this.getMaxResults() > 0) {
            q.setMaxResults(this.getMaxResults());
        }
        if (this.getFirstResult() > 0) {
            q.setFirstResult(this.getFirstResult());
        }
        return q.getResultList();
    }

    public List<E> getResultEnt() {
        this.prepare();
        this.getCriteria().select(this.root);
        Query q = this.session.createQuery(this.getCriteria());
        if (this.getMaxResults() > 0) {
            q.setMaxResults(this.getMaxResults());
        }
        if (this.getFirstResult() > 0) {
            q.setFirstResult(this.getFirstResult());
        }
        return q.getResultList();
    }

    private void prepare() {
        if (!this.getAuxFields().isEmpty()) {
            this.getCriteria().multiselect(this.getAuxFields());
        } else {
            this.getCriteria().select(this.root);
        }
        if (!this.getAuxOrder().isEmpty()) {
            this.getCriteria().orderBy(this.getAuxOrder());
        }
        if (!this.predicates.isEmpty()) {
            this.getCriteria().where(this.getPredicates().toArray(new Predicate[0]));
        }
        if (!this.havings.isEmpty()) {
            this.getCriteria().having(this.havings.toArray(new Predicate[0]));
        }
        if (!this.groupsBy.isEmpty()) {
            this.getCriteria().groupBy(this.groupsBy.toArray(new Expression[0]));
        }
        this.getCriteria().distinct(this.distinct);
    }

    public E getUniqueResult() {
        return (E)this.getUniqueGenericResult();
    }

    public Map getUniqueResultMap() {
        return this.convertToMap(this.getUniqueGenericResult());
    }

    public List<Map<String, Object>> getResultMap() {
        List data = this.getResult();
        LinkedList<Map<String, Object>> ret = new LinkedList<Map<String, Object>>();
        for (Object object : data) {
            Map ayx = this.convertToMap(object);
            if (ayx == null) continue;
            ret.add(ayx);
        }
        return ret;
    }

    public AuxCriteriaBuilder where(Predicate ... pred) {
        if (pred == null) {
            return this;
        }
        this.getCriteria().where(pred);
        this.getPredicates().clear();
        return this;
    }

    public AuxCriteriaBuilder where(List<Predicate> pred) {
        if (pred == null) {
            return this;
        }
        return this.where(pred.toArray(new Predicate[0]));
    }

    public AuxCriteriaBuilder where() {
        this.where(this.getPredicates().toArray(new Predicate[0]));
        return this;
    }

    public Predicate or(Predicate ... pred) {
        Predicate pr = this.getOr(pred);
        this.addPredicate(pr);
        return pr;
    }

    public Predicate or(List<Predicate> pred) {
        Predicate pr = this.getOr(pred.toArray(new Predicate[0]));
        this.addPredicate(pr);
        return pr;
    }

    public Predicate getOr(Predicate ... pred) {
        Predicate pr = this.getBuilder().or(pred);
        return pr;
    }

    public Predicate and(Predicate ... pred) {
        Predicate pr = this.getAnd(pred);
        this.addPredicate(pr);
        return pr;
    }

    public Predicate getAnd(Predicate ... pred) {
        Predicate pr = this.getBuilder().and(pred);
        return pr;
    }

    public AuxCriteriaBuilder orderAsc(String ... field) {
        for (String f : field) {
            this.getAuxOrder().add(this.getBuilder().asc((Expression)this.getRoot().get(f)));
        }
        return this;
    }

    public void orderAsc(Pair ... pairs) {
        for (Pair pair : pairs) {
            Root<E> temp = pair.getFrom();
            if (temp == null) {
                temp = this.from();
            }
            this.getAuxOrder().add(this.getBuilder().asc((Expression)temp.get(pair.field)));
        }
    }

    public void orderDesc(Pair ... pairs) {
        for (Pair pair : pairs) {
            Root<E> temp = pair.getFrom();
            if (temp == null) {
                temp = this.from();
            }
            this.getAuxOrder().add(this.getBuilder().desc((Expression)temp.get(pair.field)));
        }
    }

    public void orderAsc(Expression ... pairs) {
        for (Expression pair : pairs) {
            this.getAuxOrder().add(this.getBuilder().asc(pair));
        }
    }

    public void orderDesc(Expression ... pairs) {
        for (Expression pair : pairs) {
            this.getAuxOrder().add(this.getBuilder().desc(pair));
        }
    }

    public AuxCriteriaBuilder orderDesc(String ... field) {
        for (String f : field) {
            this.getAuxOrder().add(this.getBuilder().desc((Expression)this.getRoot().get(f)));
        }
        return this;
    }

    public AuxCriteriaBuilder<E> orderDesc(From joinItem, Pair ... pairs) {
        for (Pair f : pairs) {
            this.getAuxOrder().add(this.getBuilder().desc((Expression)joinItem.get(f.field)));
        }
        return this;
    }

    public AuxCriteriaBuilder orderAsc(From from, String ... field) {
        for (String f : field) {
            this.getAuxOrder().add(this.getBuilder().asc((Expression)from.get(f)));
        }
        return this;
    }

    public AuxCriteriaBuilder orderDesc(From from, String ... field) {
        for (String f : field) {
            this.getAuxOrder().add(this.getBuilder().desc((Expression)from.get(f)));
        }
        return this;
    }

    public AuxCriteriaBuilder orderAsc(From from, Expression expression) {
        this.getAuxOrder().add(this.getBuilder().asc(expression));
        return this;
    }

    public AuxCriteriaBuilder orderDesc(From from, Expression expression) {
        this.getAuxOrder().add(this.getBuilder().desc(expression));
        return this;
    }

    public AuxCriteriaBuilder setMaxResults(int maxResults) {
        this.maxResults = maxResults;
        return this;
    }

    public AuxCriteriaBuilder setFirstResult(int firstResult) {
        this.firstResult = firstResult;
        return this;
    }

    public Expression countOf(String field) {
        return this.getBuilder().count((Expression)this.getRoot().get(field));
    }

    public Predicate gt(String field, Comparable value) {
        return this.gt((From)this.getRoot(), field, value);
    }

    public Predicate gt(String field, Path other) {
        Predicate pr = this.getBuilder().greaterThan((Expression)this.getRoot().get(field), (Expression)other);
        return pr;
    }

    public Predicate getGt(String field, Comparable value) {
        return this.getGt((From)this.getRoot(), field, value);
    }

    public Predicate gt(From from, String field, Comparable value) {
        Predicate pr = this.getGt(from, field, value);
        this.addPredicate(pr);
        return pr;
    }

    public Predicate getGt(From from, String field, Comparable value) {
        Predicate pr = this.getBuilder().greaterThan((Expression)from.get(field), value);
        return pr;
    }

    public Predicate ge(String field, Comparable value) {
        return this.ge((From)this.getRoot(), field, value);
    }

    public Predicate getGe(String field, Comparable value) {
        return this.getGe((From)this.getRoot(), field, value);
    }

    public Predicate ge(From from, String field, Comparable value) {
        Predicate pr = this.getGe(from, field, value);
        this.addPredicate(pr);
        return pr;
    }

    public Predicate getGe(From from, String field, Comparable value) {
        Predicate pr = this.getBuilder().greaterThanOrEqualTo((Expression)from.get(field), value);
        return pr;
    }

    public Predicate inString(String field, List<? extends String> values) {
        values = values == null ? new LinkedList() : values;
        return this.in((From)this.getRoot(), field, values.toArray(new String[0]));
    }

    public Predicate getInString(String field, List<? extends String> values) {
        values = values == null ? new LinkedList() : values;
        return this.getIn((From)this.getRoot(), field, values.toArray(new String[0]));
    }

    public Predicate inString(From from, String field, List<? extends String> values) {
        values = values == null ? new LinkedList() : values;
        return this.in(from, field, values.toArray(new String[0]));
    }

    public Predicate getInString(From from, String field, List<? extends String> values) {
        values = values == null ? new LinkedList() : values;
        return this.getIn(from, field, values.toArray(new String[0]));
    }

    public Predicate in(String field, String ... values) {
        return this.in((From)this.getRoot(), field, values);
    }

    public Predicate getIn(String field, String ... values) {
        return this.getIn((From)this.getRoot(), field, values);
    }

    public Predicate in(From from, String field, String ... values) {
        Predicate pr = this.getIn(from, field, values);
        this.addPredicate(pr);
        return pr;
    }

    public Predicate getIn(From from, String field, String ... values) {
        values = values == null ? new String[]{} : values;
        CriteriaBuilder.In inClause = this.getBuilder().in((Expression)from.get(field));
        for (String value : values) {
            inClause.value((Object)value);
        }
        CriteriaBuilder.In pr = inClause;
        return pr;
    }

    public Predicate in(String field, Number ... values) {
        return this.in((From)this.getRoot(), field, values);
    }

    public Predicate getIn(String field, Number ... values) {
        return this.getIn((From)this.getRoot(), field, values);
    }

    public Predicate inNumber(String field, List<? extends Number> values) {
        values = values == null ? new LinkedList() : values;
        return this.in((From)this.getRoot(), field, values.toArray(new Number[0]));
    }

    public Predicate getInNumber(String field, List<? extends Number> values) {
        values = values == null ? new LinkedList() : values;
        return this.getIn((From)this.getRoot(), field, values.toArray(new Number[0]));
    }

    public Predicate inNumber(From from, String field, List<? extends Number> values) {
        values = values == null ? new LinkedList() : values;
        return this.in(from, field, values.toArray(new Number[0]));
    }

    public Predicate getInNumber(From from, String field, List<? extends Number> values) {
        values = values == null ? new LinkedList() : values;
        return this.getIn(from, field, values.toArray(new Number[0]));
    }

    public Predicate in(From from, String field, Number ... values) {
        Predicate pr = this.getIn(from, field, values);
        this.addPredicate(pr);
        return pr;
    }

    public Predicate getIn(From from, String field, Number ... values) {
        values = values == null ? new Number[]{} : values;
        CriteriaBuilder.In inClause = this.getBuilder().in((Expression)from.get(field));
        for (Number value : values) {
            inClause.value((Object)value);
        }
        CriteriaBuilder.In pr = inClause;
        return pr;
    }

    public Predicate inDate(String field, List<Date> values) {
        values = values == null ? new LinkedList() : values;
        return this.in((From)this.getRoot(), field, values.toArray(new Date[0]));
    }

    public Predicate getInDate(String field, List<Date> values) {
        values = values == null ? new LinkedList() : values;
        return this.getIn((From)this.getRoot(), field, values.toArray(new Date[0]));
    }

    public Predicate in(String field, Date ... values) {
        return this.in((From)this.getRoot(), field, values);
    }

    public Predicate getIn(String field, Date ... values) {
        return this.getIn((From)this.getRoot(), field, values);
    }

    public Predicate in(From from, String field, Date ... values) {
        Predicate pr = this.getIn(from, field, values);
        this.addPredicate(pr);
        return pr;
    }

    public Predicate getIn(From from, String field, Date ... values) {
        values = values == null ? new Date[]{} : values;
        CriteriaBuilder.In inClause = this.getBuilder().in((Expression)from.get(field));
        for (Date value : values) {
            inClause.value((Object)value);
        }
        CriteriaBuilder.In pr = inClause;
        return pr;
    }

    public Predicate le(String field, Comparable value) {
        return this.le((From)this.getRoot(), field, value);
    }

    public Predicate getLe(String field, Comparable value) {
        return this.getLe((From)this.getRoot(), field, value);
    }

    public Predicate le(From from, String field, Comparable value) {
        Predicate pr = this.getLe(from, field, value);
        this.addPredicate(pr);
        return pr;
    }

    public Predicate getLe(From from, String field, Comparable value) {
        Predicate pr = this.getBuilder().lessThanOrEqualTo((Expression)from.get(field), value);
        return pr;
    }

    public Predicate lt(String field, Comparable value) {
        return this.lt((From)this.getRoot(), field, value);
    }

    public Predicate getLt(String field, Comparable value) {
        return this.getLt((From)this.getRoot(), field, value);
    }

    public Predicate lt(From from, String field, Comparable value) {
        Predicate pr = this.getLt(from, field, value);
        this.addPredicate(pr);
        return pr;
    }

    public Predicate getLt(From from, String field, Comparable value) {
        Predicate pr = this.getBuilder().lessThan((Expression)from.get(field), value);
        return pr;
    }

    public Predicate isNull(String field) {
        return this.isNull((From)this.getRoot(), field);
    }

    public Predicate getIsNull(String field) {
        return this.getIsNull((From)this.getRoot(), field);
    }

    public Predicate isNull(From from, String field) {
        Predicate pr = this.getIsNull(from, field);
        this.addPredicate(pr);
        return pr;
    }

    public Predicate isEmpty(String field) {
        return this.isEmpty((From)this.getRoot(), field);
    }

    public Predicate getIsEmpty(String field) {
        return this.getIsEmpty((From)this.getRoot(), field);
    }

    public Predicate isEmpty(From from, String field) {
        Predicate pr = this.getIsEmpty(from, field);
        this.addPredicate(pr);
        return pr;
    }

    public Predicate getIsEmpty(From from, String field) {
        Predicate pr = this.getBuilder().isEmpty((Expression)from.get(field));
        return pr;
    }

    public Predicate getIsNull(From from, String field) {
        Predicate pr = this.getBuilder().isNull((Expression)from.get(field));
        return pr;
    }

    public Predicate isNotNull(String field) {
        return this.isNotNull((From)this.getRoot(), field);
    }

    public Predicate getIsNotNull(String field) {
        return this.getIsNotNull((From)this.getRoot(), field);
    }

    public Predicate isNotNull(From from, String field) {
        Predicate pr = this.getIsNotNull(from, field);
        this.addPredicate(pr);
        return pr;
    }

    public Predicate getIsNotNull(From from, String field) {
        Predicate pr = this.getBuilder().isNotNull((Expression)from.get(field));
        return pr;
    }

    public Predicate equal(String field, Object value) {
        return this.equal((From)this.getRoot(), field, value);
    }

    public Predicate getEqual(String field, Object value) {
        return this.getEqual((From)this.getRoot(), field, value);
    }

    public Predicate equal(From from, String field, Object value) {
        Predicate pr = this.getEqual(from, field, value);
        this.addPredicate(pr);
        return pr;
    }

    public Predicate getEqual(From from, String field, Object value) {
        Predicate pr = this.getBuilder().equal((Expression)from.get(field), value);
        return pr;
    }

    public Predicate ilike(String field, String value) {
        return this.ilike((From)this.getRoot(), field, value);
    }

    public Predicate getIlike(String field, String value) {
        return this.getIlike((From)this.getRoot(), field, value);
    }

    public Predicate ilike(From from, String field, String value) {
        Predicate pr = this.getIlike(from, field, value);
        this.addPredicate(pr);
        return pr;
    }

    public Predicate getIlike(From from, String field, String value) {
        value = value.toUpperCase();
        Predicate pr = this.getBuilder().like(this.getBuilder().upper((Expression)from.get(field)), "%" + value + "%");
        return pr;
    }

    public Predicate startWith(String field, String value) {
        return this.startWith((From)this.getRoot(), field, value);
    }

    public Predicate getStartWith(String field, String value) {
        return this.getStartWith((From)this.getRoot(), field, value);
    }

    public Predicate startWith(From from, String field, String value) {
        Predicate pr = this.getStartWith(from, field, value);
        this.addPredicate(pr);
        return pr;
    }

    public Predicate getStartWith(From from, String field, String value) {
        value = value.toUpperCase();
        Predicate pr = this.getBuilder().like(this.getBuilder().upper((Expression)from.get(field)), value + "%");
        return pr;
    }

    public Predicate endsWith(String field, String value) {
        return this.endsWith((From)this.getRoot(), field, value);
    }

    public Predicate getEndsWith(String field, String value) {
        return this.getEndsWith((From)this.getRoot(), field, value);
    }

    public Predicate endsWith(From from, String field, String value) {
        Predicate pr = this.getStartWith(from, field, value);
        this.addPredicate(pr);
        return pr;
    }

    public Predicate getEndsWith(From from, String field, String value) {
        value = value.toUpperCase();
        Predicate pr = this.getBuilder().like(this.getBuilder().upper((Expression)from.get(field)), "%" + value);
        return pr;
    }

    public Predicate notEqual(String field, Object value) {
        return this.notEqual((From)this.getRoot(), field, value);
    }

    public Predicate getNotEqual(String field, Object value) {
        return this.getNotEqual((From)this.getRoot(), field, value);
    }

    public Predicate notEqual(From from, String field, Object value) {
        Predicate pr = this.getNotEqual(from, field, value);
        this.addPredicate(pr);
        return pr;
    }

    public Predicate getNotEqual(From from, String field, Object value) {
        Predicate pr = this.getBuilder().notEqual((Expression)from.get(field), value);
        return pr;
    }

    public Predicate getBetween(String field, Comparable value, Comparable value1) {
        return this.getBetween((From)this.getRoot(), field, value, value1);
    }

    public Predicate getBetween(From from, String field, Comparable value, Comparable value1) {
        Predicate pr = this.getBuilder().between((Expression)from.get(field), value, value1);
        return pr;
    }

    public Predicate getBetween(String field1, String field2, Comparable value) {
        return this.getBetween((From)this.root, field1, field2, value);
    }

    public Predicate between(String field, Comparable value, Comparable value1) {
        return this.between((From)this.getRoot(), field, value, value1);
    }

    public Predicate between(From from, String field, Comparable value, Comparable value1) {
        Predicate pr = this.getBetween(from, field, value, value1);
        this.addPredicate(pr);
        return pr;
    }

    public Predicate between(String field, String field1, Comparable value) {
        Predicate pr = this.getBetween(field, field1, value);
        this.addPredicate(pr);
        return pr;
    }

    public Predicate between(From from, String field, String field1, Comparable value) {
        Predicate pr = this.getBetween(from, field, field1, value);
        this.addPredicate(pr);
        return pr;
    }

    public Predicate getBetween(From from, String field1, String field2, Comparable value) {
        Predicate pr = this.getBuilder().between(this.getBuilder().literal((Object)value), (Expression)from.get(field1), (Expression)from.get(field2));
        return pr;
    }

    public CriteriaQuery getCriteria() {
        return this.criteria;
    }

    public Root<E> getRoot() {
        return this.root;
    }

    public Class<E> getEntityClass() {
        return this.entityClass;
    }

    public List<Selection> getAuxFields() {
        return this.auxFields;
    }

    public List<Order> getAuxOrder() {
        return this.auxOrder;
    }

    public HashMap<String, Join> getJoins() {
        return this.joins;
    }

    public int getMaxResults() {
        return this.maxResults;
    }

    public int getFirstResult() {
        return this.firstResult;
    }

    public <E> E[] convertListInParams(String param, Class<E> aClass) {
        String[] params = TString.splitString((String)param, (char[])new char[]{','});
        Object[] ret = new Object[params.length];
        int i = 0;
        for (String p : params) {
            ret[i] = Long.class.isAssignableFrom(aClass) ? (ToolMethods.isStrWithData((String)(p = TString.onlyNumbers((String)p))) ? Long.valueOf(p) : null) : (Integer.class.isAssignableFrom(aClass) ? (ToolMethods.isStrWithData((String)(p = TString.onlyNumbers((String)p))) ? Integer.valueOf(p) : null) : (Short.class.isAssignableFrom(aClass) ? (ToolMethods.isStrWithData((String)(p = TString.onlyNumbers((String)p))) ? Short.valueOf(p) : null) : (Double.class.isAssignableFrom(aClass) ? (ToolMethods.isStrWithData((String)(p = TString.trim((String)p))) ? Double.valueOf(p) : null) : (Float.class.isAssignableFrom(aClass) ? (ToolMethods.isStrWithData((String)(p = TString.trim((String)p))) ? Float.valueOf(p) : null) : (Date.class.isAssignableFrom(aClass) ? (ToolMethods.isStrWithData((String)(p = TString.trim((String)p))) ? TDate.strToDate((String)p) : null) : p)))));
            ++i;
        }
        return ret;
    }

    public static Pair pair(String field, String alias) {
        return new Pair(field, alias);
    }

    public static Pair pair(From from, String field) {
        return new Pair(from, field);
    }

    public static Pair pair(From from, String field, String alias) {
        return new Pair(from, field, alias);
    }

    public CriteriaBuilder getBuilder() {
        return this.builder;
    }

    public AuxCriteriaBuilder<E> avg(Pair ... fields) {
        for (Pair field : fields) {
            Selection ex = this.getAvg(field);
            this.addField(ex);
        }
        return this;
    }

    public Selection getAvg(Pair field) {
        if (TMethods.isStrWithData((String)field.getAlias())) {
            return this.getAvgExpression(field).alias(field.getAlias());
        }
        return this.getAvgExpression(field);
    }

    public Expression getAvgExpression(Pair field) {
        Root<E> from = field.getFrom();
        if (from == null) {
            from = this.getRoot();
        }
        return this.builder.avg((Expression)from.get(field.getField()));
    }

    public AuxCriteriaBuilder<E> sum(Pair ... fields) {
        for (Pair field : fields) {
            Selection ex = this.getSum(field);
            this.addField(ex);
        }
        return this;
    }

    public Expression getSumExpression(Pair field) {
        Root<E> from = field.getFrom();
        if (from == null) {
            from = this.getRoot();
        }
        return this.builder.sum((Expression)from.get(field.getField()));
    }

    public Selection getSum(Pair field) {
        Expression ex = this.getSumExpression(field);
        if (TMethods.isStrWithData((String)field.getAlias())) {
            return ex.alias(field.getAlias());
        }
        return ex;
    }

    public AuxCriteriaBuilder<E> count(Pair ... fields) {
        for (Pair field : fields) {
            Selection ex = this.getCount(field);
            this.addField(ex);
        }
        return this;
    }

    public Expression getCountExpression(Pair field) {
        Root<E> from = field.getFrom();
        if (from == null) {
            from = this.getRoot();
        }
        return this.builder.count((Expression)from.get(field.getField()));
    }

    public Expression getCountExpression(String field) {
        return this.builder.count((Expression)this.getRoot().get(field));
    }

    public Selection getCount(Pair field) {
        Expression ex = this.getCountExpression(field);
        if (TMethods.isStrWithData((String)field.getAlias())) {
            return ex.alias(field.getAlias());
        }
        return ex;
    }

    public Selection getCount(String field) {
        Expression ex = this.getCountExpression(field);
        return ex;
    }

    public AuxCriteriaBuilder<E> max(Pair ... fields) {
        for (Pair field : fields) {
            Selection ex = this.getMax(field);
            this.addField(ex);
        }
        return this;
    }

    public Expression getMaxExpression(Pair field) {
        Root<E> from = field.getFrom();
        if (from == null) {
            from = this.getRoot();
        }
        return this.builder.max((Expression)from.get(field.getField()));
    }

    public Selection getMax(Pair field) {
        Expression ex = this.getMaxExpression(field);
        if (TMethods.isStrWithData((String)field.getAlias())) {
            return ex.alias(field.getAlias());
        }
        return ex;
    }

    public AuxCriteriaBuilder<E> min(Pair ... fields) {
        for (Pair field : fields) {
            Selection ex = this.getMin(field);
            this.addField(ex);
        }
        return this;
    }

    public Expression getMinExpression(Pair field) {
        Root<E> from = field.getFrom();
        if (from == null) {
            from = this.getRoot();
        }
        return this.builder.min((Expression)from.get(field.getField()));
    }

    public Selection getMin(Pair field) {
        Expression ex = this.getMinExpression(field);
        if (TMethods.isStrWithData((String)field.getAlias())) {
            return ex.alias(field.getAlias());
        }
        return ex;
    }

    public AuxCriteriaBuilder<E> groupBySelect(From from, Pair ... fields) {
        for (Pair field : fields) {
            Path ex = from.get(field.getField());
            this.addField(ex.alias(field.getAlias()));
            this.groupsBy.add((Expression)ex);
        }
        return this;
    }

    public AuxCriteriaBuilder<E> groupBy(From from, Pair ... fields) {
        for (Pair field : fields) {
            Path ex = from.get(field.getField());
            this.groupsBy.add((Expression)ex);
        }
        return this;
    }

    public AuxCriteriaBuilder<E> groupBy(Expression ... groupBy) {
        this.groupsBy.addAll(TMethods.toListArray((Object[])groupBy));
        return this;
    }

    public Expression getExpression(From from, String field) {
        Path ex = from.get(field);
        return ex;
    }

    public Expression getExpression(String field) {
        Path ex = this.root.get(field);
        return ex;
    }

    public void groupBy(List<Expression> groupBy) {
        this.groupsBy.addAll(groupBy);
    }

    public void groupBy(Pair ... fields) {
        for (Pair field : fields) {
            Root<E> fromIt = field.from;
            if (fromIt == null) {
                fromIt = this.root;
            }
            Path ex = fromIt.get(field.getField());
            this.groupsBy.add((Expression)ex);
        }
    }

    public AuxCriteriaBuilder<E> clearGroupBy() {
        this.getCriteria().groupBy(new LinkedList());
        this.groupsBy.clear();
        return this;
    }

    public AuxCriteriaBuilder<E> clearSelection() {
        this.getAuxFields().clear();
        return this;
    }

    public AuxCriteriaBuilder<E> clearOrderBy() {
        this.auxOrder.clear();
        return this;
    }

    public AuxCriteriaBuilder<E> clearWhere() {
        this.getPredicates().clear();
        return this;
    }

    public void having(Predicate ... preds) {
        for (Predicate having : preds) {
            this.havings.add(having);
        }
    }

    public void having(List<Predicate> preds) {
        for (Predicate having : preds) {
            this.havings.add(having);
        }
    }

    private void addPredicate(Predicate pr) {
        if (!this.predicates.contains(pr)) {
            this.getPredicates().add(pr);
        }
    }

    private void addField(Selection selection) {
        Optional<Selection> found;
        if (!TMethods.isStrWithData((String)selection.getAlias())) {
            this.getAuxFields().add(selection);
        }
        if (!(found = this.getAuxFields().stream().filter(i -> TMethods.isEquals((Object)i.getAlias(), (Object)selection.getAlias())).findFirst()).isPresent()) {
            this.getAuxFields().add(selection);
        } else {
            TLogger.get(this.getClass()).info("aliases j\u00ef\u00bf\u00bd existe, foi informado " + selection.getAlias());
        }
    }

    public void setDistinct(boolean distinct) {
        this.distinct = distinct;
    }

    public void setRoot(Root<E> root) {
        this.root = root;
    }

    private Map convertToMap(Object object) {
        if (object == null || !object.getClass().isArray()) {
            return null;
        }
        Object[] aux = (Object[])object;
        LinkedHashMap<String, Object> m = new LinkedHashMap<String, Object>();
        int i = 0;
        for (Selection s : this.getAuxFields()) {
            Object alias = s.getAlias();
            if (!ToolMethods.isStrWithData((String)alias) && s instanceof SingularAttributePath) {
                alias = ((SingularAttributePath)s).getAttribute().getName();
            }
            if (!ToolMethods.isStrWithData((String)alias)) {
                alias = "FIELD_" + i;
            }
            m.put((String)alias, aux[i]);
            ++i;
        }
        return m;
    }

    public List<Predicate> getPredicates() {
        return this.predicates;
    }

    public HashMap<String, Fetch> getFetchs() {
        return this.fetchs;
    }

    public static class Pair {
        private From from;
        private String field;
        private String alias;

        public Pair(From from, String field, String alias) {
            this.from = from;
            this.field = field;
            this.alias = alias;
        }

        public Pair(String field, String alias) {
            this.field = field;
            this.alias = alias;
        }

        public Pair(From from, String field) {
            this.from = from;
            this.field = field;
        }

        @Generated
        public From getFrom() {
            return this.from;
        }

        @Generated
        public String getField() {
            return this.field;
        }

        @Generated
        public String getAlias() {
            return this.alias;
        }

        @Generated
        public void setFrom(From from) {
            this.from = from;
        }

        @Generated
        public void setField(String field) {
            this.field = field;
        }

        @Generated
        public void setAlias(String alias) {
            this.alias = alias;
        }

        @Generated
        public boolean equals(Object o) {
            if (o == this) {
                return true;
            }
            if (!(o instanceof Pair)) {
                return false;
            }
            Pair other = (Pair)o;
            if (!other.canEqual(this)) {
                return false;
            }
            From this$from = this.getFrom();
            From other$from = other.getFrom();
            if (this$from == null ? other$from != null : !this$from.equals(other$from)) {
                return false;
            }
            String this$field = this.getField();
            String other$field = other.getField();
            if (this$field == null ? other$field != null : !this$field.equals(other$field)) {
                return false;
            }
            String this$alias = this.getAlias();
            String other$alias = other.getAlias();
            return !(this$alias == null ? other$alias != null : !this$alias.equals(other$alias));
        }

        @Generated
        protected boolean canEqual(Object other) {
            return other instanceof Pair;
        }

        @Generated
        public int hashCode() {
            int PRIME = 59;
            int result = 1;
            From $from = this.getFrom();
            result = result * 59 + ($from == null ? 43 : $from.hashCode());
            String $field = this.getField();
            result = result * 59 + ($field == null ? 43 : $field.hashCode());
            String $alias = this.getAlias();
            result = result * 59 + ($alias == null ? 43 : $alias.hashCode());
            return result;
        }

        @Generated
        public String toString() {
            return "AuxCriteriaBuilder.Pair(from=" + String.valueOf(this.getFrom()) + ", field=" + this.getField() + ", alias=" + this.getAlias() + ")";
        }
    }
}

