/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.dao.builders;

import com.touchcomp.basementortools.constants.EnumConstantsCriteria;
import com.touchcomp.basementortools.tools.converter.CompRestrictionsFactory;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.basementortools.tools.string.ToolString;
import java.util.Collection;
import java.util.LinkedList;
import java.util.List;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.From;
import javax.persistence.criteria.Predicate;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.stereotype.Component;

@Component
public class AuxCriterionBuilder {
    public Criterion getExpression(String string, String fieldClass, EnumConstantsCriteria filter, Object value1) {
        return this.getExpression(string, fieldClass, filter, value1, null);
    }

    public Criterion getExpression(String string, EnumConstantsCriteria filter, Object value1, Object value2) {
        String fieldClass = null;
        if (value1 != null) {
            fieldClass = value1.getClass().getCanonicalName();
        }
        if (value1 == null && ToolMethods.isEquals((Object)EnumConstantsCriteria.IN, (Object)filter)) {
            filter = EnumConstantsCriteria.EQUAL;
        }
        return this.getExpression(string, fieldClass, filter, value1, value2);
    }

    public Criterion getExpression(String string, String fieldClass, EnumConstantsCriteria filter, Object value1, Object value2) {
        return switch (filter) {
            case EnumConstantsCriteria.BETWEEN -> Restrictions.between((String)string, (Object)value1, (Object)value2);
            case EnumConstantsCriteria.EQUAL -> Restrictions.eq((String)string, (Object)value1);
            case EnumConstantsCriteria.EMPTY -> Restrictions.isEmpty((String)string);
            case EnumConstantsCriteria.GREATER -> Restrictions.gt((String)string, (Object)value1);
            case EnumConstantsCriteria.GREATER_EQUAL -> Restrictions.ge((String)string, (Object)value1);
            case EnumConstantsCriteria.IS_NOT_NULL -> Restrictions.isNotNull((String)string);
            case EnumConstantsCriteria.IS_NULL -> Restrictions.isNull((String)string);
            case EnumConstantsCriteria.LESS -> Restrictions.lt((String)string, (Object)value1);
            case EnumConstantsCriteria.LESS_EQUAL -> Restrictions.le((String)string, (Object)value1);
            case EnumConstantsCriteria.LIKE -> {
                if (value1 == null) {
                    value1 = "";
                }
                yield Restrictions.like((String)string, (Object)("%" + String.valueOf(value1) + "%"));
            }
            case EnumConstantsCriteria.LIKE_RIGHT -> {
                if (value1 == null) {
                    value1 = "";
                }
                yield Restrictions.like((String)string, (Object)(String.valueOf(value1) + "%"));
            }
            case EnumConstantsCriteria.LIKE_LEFT -> {
                if (value1 == null) {
                    value1 = "";
                }
                yield Restrictions.like((String)string, (Object)("%" + String.valueOf(value1)));
            }
            case EnumConstantsCriteria.ILIKE -> {
                if (value1 == null) {
                    value1 = "";
                }
                yield Restrictions.ilike((String)string, (Object)("%" + String.valueOf(value1) + "%"));
            }
            case EnumConstantsCriteria.ILIKE_RIGTH -> {
                if (value1 == null) {
                    value1 = "";
                }
                yield Restrictions.ilike((String)string, (Object)(String.valueOf(value1) + "%"));
            }
            case EnumConstantsCriteria.ILIKE_LEFT -> {
                if (value1 == null) {
                    value1 = "";
                }
                yield Restrictions.ilike((String)string, (Object)("%" + String.valueOf(value1)));
            }
            case EnumConstantsCriteria.NOT_EMPTY -> Restrictions.isNotEmpty((String)string);
            case EnumConstantsCriteria.NOT_EQUAL -> Restrictions.ne((String)string, (Object)value1);
            case EnumConstantsCriteria.IN -> this.analiseIn(string, fieldClass, value1);
            default -> Restrictions.eq((String)string, (Object)value1);
        };
    }

    public Predicate getPredicate(CriteriaBuilder builder, CriteriaQuery criteria, From from, String atributo, String classe, EnumConstantsCriteria op, Object value1, Object value2) {
        return this.getPredicate(builder, (Expression)from.get(atributo), atributo, classe, op, value1, value2);
    }

    public Predicate getPredicate(CriteriaBuilder builder, Expression expression, String atributo, String classe, EnumConstantsCriteria op, Object value1, Object value2) {
        switch (op) {
            case BETWEEN: {
                return builder.between(expression, (Comparable)value1, (Comparable)value2);
            }
            case EMPTY: {
                return builder.isEmpty(expression);
            }
            case GREATER: {
                return builder.greaterThan(expression, (Comparable)value1);
            }
            case GREATER_EQUAL: {
                return builder.greaterThanOrEqualTo(expression, (Comparable)value1);
            }
            case IS_NOT_NULL: {
                return builder.isNotNull(expression);
            }
            case IS_NULL: {
                return builder.isNull(expression);
            }
            case LESS: {
                return builder.lessThan(expression, (Comparable)value1);
            }
            case LESS_EQUAL: {
                return builder.lessThanOrEqualTo(expression, (Comparable)value1);
            }
            case LIKE: {
                if (value1 == null) {
                    value1 = "";
                }
                return builder.like(expression, "%" + String.valueOf(value1) + "%");
            }
            case LIKE_RIGHT: {
                if (value1 == null) {
                    value1 = "";
                }
                return builder.like(expression, String.valueOf(value1) + "%");
            }
            case LIKE_LEFT: {
                if (value1 == null) {
                    value1 = "";
                }
                return builder.like(expression, "%" + String.valueOf(value1));
            }
            case ILIKE: {
                if (value1 == null) {
                    value1 = "";
                }
                return builder.like(builder.lower(expression), "%" + String.valueOf(value1).toLowerCase() + "%");
            }
            case ILIKE_RIGTH: {
                if (value1 == null) {
                    value1 = "";
                }
                return builder.like(builder.lower(expression), String.valueOf(value1).toLowerCase() + "%");
            }
            case ILIKE_LEFT: {
                if (value1 == null) {
                    value1 = "";
                }
                return builder.like(builder.lower(expression), "%" + String.valueOf(value1).toLowerCase());
            }
            case NOT_EMPTY: {
                return builder.isNotEmpty(expression);
            }
            case NOT_EQUAL: {
                return builder.notEqual(expression, value1);
            }
            case IN: {
                CriteriaBuilder.In inClause = builder.in(expression);
                for (Object ob : (Collection)value1) {
                    inClause.value(ob);
                }
                return inClause;
            }
        }
        return builder.equal(expression, value1);
    }

    public List getInParams(String fieldClass, Object value1) {
        String[] tokens;
        String str = String.valueOf(value1);
        LinkedList<Object> ret = new LinkedList<Object>();
        for (String token : tokens = ToolString.splitString((String)str, (char[])new char[]{'.', ',', '/'})) {
            if (token == null || "null".equals(token)) continue;
            ret.add(CompRestrictionsFactory.getRestrictions((String)fieldClass).convertValue(token));
        }
        return ret;
    }

    private Criterion analiseIn(String field, String fieldClass, Object value1) {
        if (!ToolMethods.isStrWithData((String)fieldClass)) {
            return Restrictions.eq((String)field, (Object)value1);
        }
        if (Collection.class.isAssignableFrom(value1.getClass())) {
            return Restrictions.in((String)field, (Collection)((Collection)value1));
        }
        return Restrictions.in((String)field, (Object[])this.getInParams(fieldClass, value1).toArray());
    }
}

