/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.dao.impl;

import com.touchcomp.basementor.constants.enums.evento.EnumConstTipoCalculoEvento;
import com.touchcomp.basementor.model.vo.AberturaPeriodo;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.TipoCalculo;
import com.touchcomp.basementorservice.dao.DaoGenericEntityImpl;
import com.touchcomp.basementorservice.dao.builders.AuxCriteriaBuilder;
import com.touchcomp.basementortools.tools.date.ToolDate;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.persistence.criteria.From;
import javax.persistence.criteria.Join;
import org.springframework.stereotype.Repository;

@Repository
public class DaoAberturaPeriodoImpl
extends DaoGenericEntityImpl<AberturaPeriodo, Long> {
    public List<HashMap> getDetalhamentoImpostoByPeriodoGrupoEmpresa(Date dataPeriodo, Long grupoEmpresa) {
        AuxCriteriaBuilder aux = this.queryBuilder();
        Join jEmpresa = aux.join("empresa");
        Join jEmpresaDados = jEmpresa.join("empresaDados");
        Join jGrupoEmpresa = jEmpresaDados.join("grupoEmpresa");
        Join jMovimentoFolha = aux.join("movimentoFolha");
        aux.select(aux.getSum(AuxCriteriaBuilder.pair((From)jMovimentoFolha, "valorPis", "valorPis")));
        aux.select(aux.getSum(AuxCriteriaBuilder.pair((From)jMovimentoFolha, "vrFgtsSalario", "vrFgtsSalario")));
        aux.select(aux.getSum(AuxCriteriaBuilder.pair((From)jMovimentoFolha, "vrFgtsFerias", "vrFgtsFerias")));
        aux.select(aux.getSum(AuxCriteriaBuilder.pair((From)jMovimentoFolha, "vrFgts13Sal", "vrFgts13Sal")));
        aux.between("periodoApuracao", ToolDate.getDataInicial((Date)dataPeriodo), (Comparable)ToolDate.getDataFinal((Date)dataPeriodo));
        aux.equal((From)jGrupoEmpresa, "identificador", grupoEmpresa);
        return aux.getResultMap();
    }

    public List<AberturaPeriodo> findAberturaPeriodoByCalculoInss(Date periodo, TipoCalculo tipoCalculo, Empresa empresa) {
        return this.query("FROM AberturaPeriodo a WHERE a.dataInicio  = :periodo AND   a.tipoCalculo = :tipoCalculo AND   a.empresa     = :empresa AND NOT EXISTS (FROM CalculoInssAberturaPeriodo c WHERE c.aberturaPeriodo = a)").setParameter("periodo", (Object)periodo).setParameter("tipoCalculo", (Object)tipoCalculo).setParameter("empresa", (Object)empresa).list();
    }

    public List<AberturaPeriodo> findAberturaPeriodoPorDataPagamentoAndEmpresa(Date dataPagamento, Empresa empresa) {
        return this.query("FROM AberturaPeriodo a WHERE a.dataPagamento  = :dataPagamento AND   a.empresa        = :empresa AND   (a.tipoCalculo.tipoFolha = :folhaPagamento or a.tipoCalculo.tipoFolha = :folhaDecimoTerceiro)").setParameter("dataPagamento", (Object)dataPagamento).setParameter("empresa", (Object)empresa).setParameter("folhaPagamento", (Object)EnumConstTipoCalculoEvento.CALCULO_FOLHA_DE_PAGAMENTO.getValue()).setParameter("folhaDecimoTerceiro", (Object)EnumConstTipoCalculoEvento.CALCULO_DEC_13O.getValue()).list();
    }

    public List<HashMap> getDetalhamentoImpostoByDataPagamentoGrupoEmpresa(Date dataPeriodo, Long grupoEmpresa) {
        AuxCriteriaBuilder aux = this.queryBuilder();
        Join jEmpresa = aux.join("empresa");
        Join jEmpresaDados = jEmpresa.join("empresaDados");
        Join jGrupoEmpresa = jEmpresaDados.join("grupoEmpresa");
        Join jMovimentoFolha = aux.join("movimentoFolha");
        Join jStatus = jMovimentoFolha.join("statusFolha");
        aux.select(aux.getSum(AuxCriteriaBuilder.pair((From)jMovimentoFolha, "vrIrrfSalario", "vrIrrfSalario")));
        aux.select(aux.getSum(AuxCriteriaBuilder.pair((From)jMovimentoFolha, "vrIrrf13Sal", "vrIrrf13Sal")));
        aux.between("dataPagamento", ToolDate.getDataInicial((Date)dataPeriodo), (Comparable)ToolDate.getDataFinal((Date)dataPeriodo));
        aux.equal((From)jGrupoEmpresa, "identificador", grupoEmpresa);
        aux.notEqual((From)jStatus, "codigo", (short)3);
        return aux.getResultMap();
    }
}

