/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.dao.impl;

import com.touchcomp.basementor.model.vo.AfastamentoColaborador;
import com.touchcomp.basementor.model.vo.Colaborador;
import com.touchcomp.basementorclientwebservices.ponto.model.abono.DTOPontoAfastamentoColaborador;
import com.touchcomp.basementorservice.dao.DaoGenericEntityImpl;
import com.touchcomp.basementorservice.dao.builders.AuxCriteriaBuilder;
import com.touchcomp.basementortools.tools.methods.TMethods;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.From;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.springframework.stereotype.Repository;

@Repository
public class DaoAfastamentoColaboradorImpl
extends DaoGenericEntityImpl<AfastamentoColaborador, Long> {
    public List<AfastamentoColaborador> getAfastamentosColaborador(Colaborador colaborador, Date inicioApuracao, Date finalApuracao) {
        String hql = " from AfastamentoColaborador af  where  af.dataAfastamento != null  and  af.colaborador = :colaborador  and  (af.dataAfastamento between :inicioApuracao and :finalApuracao  or  (af.dataRetorno is not null   and   af.dataRetorno between :inicioApuracao and :finalApuracao)) ";
        return this.query(hql).setEntity("colaborador", (Object)colaborador).setDate("inicioApuracao", inicioApuracao).setDate("finalApuracao", finalApuracao).list();
    }

    public List<AfastamentoColaborador> getAfastamentoColaboradorPorColaborador(Long idColaborador) {
        CriteriaBuilder builder = this.criteriaBuilder(AfastamentoColaborador.class);
        CriteriaQuery crit = builder.createQuery();
        LinkedList<Predicate> exps = new LinkedList<Predicate>();
        Root fromAfastamentoColaborador = crit.from(AfastamentoColaborador.class);
        Join jColaborador = fromAfastamentoColaborador.join("colaborador", JoinType.INNER);
        crit.select((Selection)fromAfastamentoColaborador);
        exps.add(builder.equal((Expression)jColaborador.get("identificador"), (Object)idColaborador));
        crit.where(exps.toArray(new Predicate[0]));
        return this.getEntityManager().createQuery(crit).getResultList();
    }

    public List<DTOPontoAfastamentoColaborador> findAfastamentoColaboradorPonto(Date dataBaseSincSistemaPonto, Date dataUltimaSincronizacao) {
        AuxCriteriaBuilder aux = this.queryBuilder();
        Join jColaborador = aux.join("colaborador");
        aux.select((From)jColaborador, "numeroRegistro");
        aux.select("dataInicio");
        aux.select("dataRetorno");
        aux.select((From)jColaborador, "identificador");
        LinkedList<Predicate> where = new LinkedList<Predicate>();
        where.add(aux.and(aux.isNotNull("dataCadastro"), aux.gt("dataCadastro", dataBaseSincSistemaPonto)));
        if (TMethods.isNotNull((Object)dataUltimaSincronizacao).booleanValue()) {
            where.add(aux.gt("dataAtualizacao", dataUltimaSincronizacao));
        }
        aux.where(where);
        List data = aux.getResult();
        LinkedList<DTOPontoAfastamentoColaborador> result = new LinkedList<DTOPontoAfastamentoColaborador>();
        for (Object[] obj : data) {
            DTOPontoAfastamentoColaborador dto = new DTOPontoAfastamentoColaborador();
            dto.setMatricula((String)obj[0]);
            dto.setDtInicio((Date)obj[1]);
            dto.setDtFim((Date)obj[2]);
            dto.setIdColaborador((Long)obj[3]);
            result.add(dto);
        }
        return result;
    }

    public List<AfastamentoColaborador> getAfastamentoColaboradorDataProvisao(Colaborador colaborador, Date dataProvisao) {
        return this.query("SELECT a FROM AfastamentoColaborador a INNER JOIN a.afastamentoSefip s WHERE a.colaborador = :colaborador AND s.codigo != :codigo1 AND s.codigo != :codigo2 AND s.codigo != :codigo3 AND (a.dataAfastamento >= :dataProvisao) ORDER BY a.dataAfastamento").setParameter("colaborador", (Object)colaborador).setParameter("codigo1", (Object)"Z1").setParameter("codigo2", (Object)"Q1").setParameter("codigo3", (Object)"U1").setParameter("dataProvisao", (Object)dataProvisao).list();
    }
}

