/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.dao.impl;

import com.touchcomp.basementor.model.impl.SaldoValorConta;
import com.touchcomp.basementor.model.vo.AgenciaValores;
import com.touchcomp.basementor.model.vo.ContaValores;
import com.touchcomp.basementorservice.dao.DaoGenericEntityImpl;
import java.math.BigDecimal;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hibernate.query.NativeQuery;
import org.springframework.stereotype.Repository;

@Repository
public class DaoAgenciaValoresImpl
extends DaoGenericEntityImpl<AgenciaValores, Long> {
    public List<SaldoValorConta> findSaldoEmissao(Date dataInicial, Date dataFinal, ContaValores conta) {
        NativeQuery q = this.sqlQuery("select valor_saldo,data_saldo from SALDO_BANCO_EMISSAO(:conta,:dataIn,:dataFim)");
        q.setParameter("dataIn", (Object)dataInicial);
        q.setParameter("dataFim", (Object)dataFinal);
        q.setParameter("conta", (Object)conta.getIdentificador());
        List lista = q.list();
        ArrayList<SaldoValorConta> result = new ArrayList<SaldoValorConta>();
        for (Object o : lista) {
            Object[] ob = (Object[])o;
            SaldoValorConta s = new SaldoValorConta();
            s.setValorSaldo(Double.valueOf(((BigDecimal)ob[0]).doubleValue()));
            s.setDataSaldo((Date)ob[1]);
            s.setAgencia(conta.getAgenciaValor().getPessoa().getNome());
            s.setNrConta(conta.getDescricao());
            result.add(s);
        }
        return result;
    }

    public List<SaldoValorConta> findSaldoCompensacao(Date dataInicial, Date dataFinal, ContaValores conta) {
        NativeQuery q = this.sqlQuery("select valor_saldo,data_saldo from SALDO_BANCO_COMPENSACAO(:conta,:dataIn,:dataFim)");
        q.setParameter("dataIn", (Object)dataInicial);
        q.setParameter("dataFim", (Object)dataFinal);
        q.setParameter("conta", (Object)conta.getIdentificador());
        List lista = q.list();
        ArrayList<SaldoValorConta> result = new ArrayList<SaldoValorConta>();
        for (Object o : lista) {
            Object[] ob = (Object[])o;
            SaldoValorConta s = new SaldoValorConta();
            s.setValorSaldo(Double.valueOf(((BigDecimal)ob[0]).doubleValue()));
            s.setDataSaldo((Date)ob[1]);
            s.setAgencia(conta.getAgenciaValor().getPessoa().getNome());
            s.setNrConta(conta.getDescricao());
            result.add(s);
        }
        return result;
    }
}

