/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.dao.impl;

import com.touchcomp.basementor.constants.enums.nfe.EnumConstNFeStatus;
import com.touchcomp.basementor.model.vo.ApuracaoComissaoRepresentante;
import com.touchcomp.basementor.model.vo.Representante;
import com.touchcomp.basementorservice.dao.DaoGenericEntityImpl;
import com.touchcomp.basementortools.tools.formatter.ToolFormatter;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.util.Date;
import org.hibernate.query.Query;
import org.springframework.stereotype.Repository;

@Repository
public class DaoApuracaoComissaoImpl
extends DaoGenericEntityImpl<ApuracaoComissaoRepresentante, Long> {
    public Double getValoresRecVistaNFCe(Representante r, Date dataInicial, Date dataFinal, Short ignorarFiltrosNFCe) {
        String hql = "";
        hql = ToolMethods.isNull((Object)ignorarFiltrosNFCe) != false || ToolMethods.isEquals((Object)ignorarFiltrosNFCe, (Object)0) ? "select sum((i.valorTotalBruto - i.valorDesconto - ic.valorIcmsDesonerado)*(p.valorLiquido/t.valorTotalNFe)*(i.percentualComissao/100)) from NFCe n inner join n.naturezaOperacao nat inner join n.itens i inner join i.icms ic inner join n.pagamentos p inner join p.tipoPagamentoNFe tp inner join p.meioPagamento m inner join n.totalizadores t where i.representante = :representante and m.pagamentoAVista=:sim and i.status=:sim and p.status=:sim and (n.status=:autorizada or n.status=:autorizadaForaPrazo) and nat.gerarComissaoRep=:sim and n.dataEmissao between :dataIn and :dataFim" : " select  sum(i.valorTotal) from NFCe n inner join n.itens i where i.representante = :representante and i.status=:sim and (n.status=:autorizada or n.status=:autorizadaForaPrazo) and n.dataEmissao between :dataIn and :dataFim";
        Query q = this.query(hql);
        q.setShort("sim", (short)1);
        q.setEntity("representante", (Object)r);
        q.setDate("dataIn", dataInicial);
        q.setDate("dataFim", dataFinal);
        q.setInteger("autorizada", EnumConstNFeStatus.AUTORIZADA.getValue().intValue());
        q.setInteger("autorizadaForaPrazo", EnumConstNFeStatus.AUTORIZADA_FORA_PRAZO.getValue().intValue());
        Double ret = (Double)q.uniqueResult();
        if (ToolMethods.isNull((Object)ignorarFiltrosNFCe).booleanValue() || ToolMethods.isEquals((Object)ignorarFiltrosNFCe, (Object)0)) {
            return ret != null ? ret : 0.0;
        }
        Double valorTotal = ret != null ? ret : 0.0;
        return ToolFormatter.arrredondarNumero((Double)(valorTotal * (r.getPercentualComissao() / 100.0)), (int)2);
    }

    public Double getValoresRecVistaNFCeNFe(Representante r, Date dataInicial, Date dataFinal, Short ignorarFiltrosNFCe) {
        String hql = "";
        hql = ToolMethods.isNull((Object)ignorarFiltrosNFCe) != false || ToolMethods.isEquals((Object)ignorarFiltrosNFCe, (Object)0) ? "select sum((i.vrProduto - i.valorDesconto - ic.vrIcmsDesonerado)*(p.valor/t.valorTotal)*(i.percComissao/100)) from NotaFiscalPropria n inner join n.naturezaOperacao nat inner join n.nfceControleCaixa ncc inner join n.itensNotaPropria i inner join i.itemNotaLivroFiscal ic inner join n.infPagamentoNfPropria p inner join p.tipoPagamentoNFe tp inner join p.meioPagamento m inner join n.valoresNfPropria t where i.representante = :representante and m.pagamentoAVista=:sim and nat.gerarComissaoRep=:sim  and ncc is not null and (n.status=:autorizada or n.status=:autorizadaForaPrazo) and n.dataEmissaoNota between :dataIn and :dataFim" : "select sum(ic.valorTotal) from NotaFiscalPropria n inner join n.naturezaOperacao nat inner join n.nfceControleCaixa ncc inner join n.itensNotaPropria i inner join i.itemNotaLivroFiscal ic where i.representante = :representante and ncc is not null and (n.status=:autorizada or n.status=:autorizadaForaPrazo) and n.dataEmissaoNota between :dataIn and :dataFim";
        Query q = this.query(hql);
        if (ToolMethods.isNull((Object)ignorarFiltrosNFCe).booleanValue() || ToolMethods.isEquals((Object)ignorarFiltrosNFCe, (Object)0)) {
            q.setShort("sim", (short)1);
        }
        q.setEntity("representante", (Object)r);
        q.setDate("dataIn", dataInicial);
        q.setDate("dataFim", dataFinal);
        q.setInteger("autorizada", (int)EnumConstNFeStatus.AUTORIZADA.getValue().shortValue());
        q.setInteger("autorizadaForaPrazo", (int)EnumConstNFeStatus.AUTORIZADA_FORA_PRAZO.getValue().shortValue());
        Double ret = (Double)q.uniqueResult();
        if (ToolMethods.isNull((Object)ignorarFiltrosNFCe).booleanValue() || ToolMethods.isEquals((Object)ignorarFiltrosNFCe, (Object)0)) {
            return ret != null ? ret : 0.0;
        }
        Double valorTotal = ret != null ? ret : 0.0;
        return ToolFormatter.arrredondarNumero((Double)(valorTotal * (r.getPercentualComissao() / 100.0)), (int)2);
    }
}

