/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.dao.impl;

import com.touchcomp.basementor.constants.enums.situacaodocumento.EnumConstSituacaoDocumento;
import com.touchcomp.basementor.model.vo.ApuracaoLocacao;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.Produto;
import com.touchcomp.basementorservice.dao.DaoGenericEntityImpl;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import org.hibernate.query.Query;
import org.hibernate.transform.AliasToEntityMapResultTransformer;
import org.hibernate.transform.ResultTransformer;
import org.springframework.stereotype.Repository;

@Repository
public class DaoApuracaoLocacaoImpl
extends DaoGenericEntityImpl<ApuracaoLocacao, Long> {
    public List<HashMap> pesquisarSomatoriaQuantidadeLiquidaAjusteEstoqueEntrada(Pessoa pessoa, Empresa empresa, Produto produto, Date dataInicial, Date dataFinal) {
        Query q = this.query("SELECT n.numeroNota              AS NUMERO_NOTA_TERCEIROS, n.serie                   AS SERIE_NOTA_TERCEIROS, n.dataEntrada             AS DATA_ENT_SAIDA_NOTA_TERCEIROS, SUM(i.quantidadeTotal)    AS QUANTIDADE_BRUTO, SUM(a.qtdeLiquida)        AS PESO_LIQUIDO_AVALIACAO, SUM(a.qtdeUmidade)        AS UMIDADE, SUM(e.pesoLiquidoBalanca) AS PESO_LIQUIDO_BALANCA FROM TicketEntradaItemNota        t INNER JOIN t.itemNota             i INNER JOIN i.notaFiscalTerceiros  n INNER JOIN n.unidadeFatFornecedor u INNER JOIN u.fornecedor           o INNER JOIN t.ticketEntrada        e INNER JOIN e.loteFabricacao       l INNER JOIN l.fichaTecnica         f INNER JOIN f.ajusteEstoque        a WHERE o.pessoa  = :pessoa AND   n.empresa = :empresa AND   i.produto = :produto AND   (n.dataEntrada BETWEEN :dataInicial AND :dataFinal) GROUP BY n.numeroNota,          n.serie,          n.dataEntrada");
        q.setEntity("pessoa", (Object)pessoa);
        q.setEntity("empresa", (Object)empresa);
        q.setEntity("produto", (Object)produto);
        q.setDate("dataInicial", dataInicial);
        q.setDate("dataFinal", dataFinal);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        return q.list();
    }

    public List<HashMap> pesquisarSomatoriaQuantidadeLiquidaAjusteEstoqueSaida(Pessoa pessoa, Empresa empresa, Produto produto, Date dataInicial, Date dataFinal) {
        Query q = this.query("SELECT n.numeroNota           AS NUMERO_NOTA_PROPRIA, n.serie                AS SERIE_NOTA_PROPRIA, n.dataEmissaoNota      AS DATA_EMISSAO_NOTA_PROPRIA, SUM(i.quantidadeTotal) AS SALDO FROM ItemNotaFiscalPropria           i INNER JOIN i.notaFiscalPropria       n INNER JOIN n.unidadeFatCliente       u INNER JOIN u.cliente                 c INNER JOIN i.gradesNotaFiscalPropria g INNER JOIN n.situacaoDocumento       s WHERE c.pessoa  = :pessoa AND   n.empresa = :empresa AND   i.produto = :produto AND   (n.dataEntradaSaida BETWEEN :dataInicial AND :dataFinal) AND   s.codigo <> :situacaoDocumento1 AND   s.codigo <> :situacaoDocumento2 AND   s.codigo <> :situacaoDocumento3 AND   i.ajusteEstoque IS NULL AND   EXISTS (SELECT t.identificador FROM TicketFiscalTerceiros t WHERE t.loteFabricacao = g.loteFabricacao) GROUP BY n.numeroNota,          n.serie,          n.dataEmissaoNota");
        q.setEntity("pessoa", (Object)pessoa);
        q.setEntity("empresa", (Object)empresa);
        q.setEntity("produto", (Object)produto);
        q.setDate("dataInicial", dataInicial);
        q.setDate("dataFinal", dataFinal);
        q.setString("situacaoDocumento1", EnumConstSituacaoDocumento.CANCELADO.getValue());
        q.setString("situacaoDocumento2", EnumConstSituacaoDocumento.CANCELADO_EXTEMPORANEO.getValue());
        q.setString("situacaoDocumento3", EnumConstSituacaoDocumento.DENEGADO.getValue());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        return q.list();
    }

    public List<HashMap> pesquisarNotasSaidaEstoqueTerceirosMae(Long idPessoa, Long idEstoqueTerceiros, Long idProduto, Long idLoteFabricacao, Date dataInicial, Date dataFinal) {
        Query q = this.query("SELECT n.identificador    AS ID_NOTA_PROPRIA, n.dataEmissaoNota  AS DATA_ENTRADA_SAIDA, l.identificador    AS ID_LOTE_FABRICACAO, i.quantidadeTotal  AS QUANTIDADE FROM ItemNotaFiscalPropria           i INNER JOIN i.notaFiscalPropria       n INNER JOIN n.unidadeFatCliente       u INNER JOIN u.cliente                 c INNER JOIN c.pessoa                  p INNER JOIN i.produto                 r INNER JOIN i.gradesNotaFiscalPropria g INNER JOIN g.estoqueTerceiros        e INNER JOIN e.estoqueTerceirosMae     m INNER JOIN g.loteFabricacao          l INNER JOIN n.situacaoDocumento       s WHERE p.identificador   = :idPessoa AND   m.identificador   = :idEstoqueTerceiros AND   r.identificador   = :idProduto AND   l.identificador   = :idLoteFabricacao AND   s.codigo          <> :situacaoDocumento1 AND   s.codigo          <> :situacaoDocumento2 AND   s.codigo          <> :situacaoDocumento3 AND   n.dataEmissaoNota BETWEEN :dataInicial AND :dataFinal");
        q.setLong("idPessoa", idPessoa.longValue());
        q.setLong("idEstoqueTerceiros", idEstoqueTerceiros.longValue());
        q.setLong("idProduto", idProduto.longValue());
        q.setLong("idLoteFabricacao", idLoteFabricacao.longValue());
        q.setDate("dataInicial", dataInicial);
        q.setDate("dataFinal", dataFinal);
        q.setString("situacaoDocumento1", EnumConstSituacaoDocumento.CANCELADO.getValue());
        q.setString("situacaoDocumento2", EnumConstSituacaoDocumento.CANCELADO_EXTEMPORANEO.getValue());
        q.setString("situacaoDocumento3", EnumConstSituacaoDocumento.DENEGADO.getValue());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        return q.list();
    }

    public Date pesquisarPrimeiraNotaEntrada(Pessoa pessoa, Empresa empresa, Produto produto, Date data) {
        Query q = this.query("SELECT DISTINCT n.dataEntrada AS DATA_ENT_SAIDA_NOTA_TERCEIROS FROM TicketEntradaItemNota        t INNER JOIN t.itemNota             i INNER JOIN i.notaFiscalTerceiros  n INNER JOIN n.unidadeFatFornecedor u INNER JOIN u.fornecedor           o INNER JOIN t.ticketEntrada        e INNER JOIN e.loteFabricacao       l INNER JOIN l.fichaTecnica         f INNER JOIN f.ajusteEstoque        a WHERE o.pessoa  = :pessoa AND   n.empresa = :empresa AND   i.produto = :produto AND   n.dataEntrada >= :data ORDER BY n.dataEntrada");
        q.setEntity("pessoa", (Object)pessoa);
        q.setEntity("empresa", (Object)empresa);
        q.setEntity("produto", (Object)produto);
        q.setDate("data", data);
        q.setMaxResults(1);
        return (Date)q.uniqueResult();
    }

    public Date pesquisarPrimeiraNotaEntrada(Long idPessoa, Long IdEmpresa, Long idProduto, Date data) {
        Query q = this.query("SELECT DISTINCT n.dataEntrada AS DATA_ENT_SAIDA_NOTA_TERCEIROS FROM TicketEntradaItemNota        t INNER JOIN t.itemNota             i INNER JOIN i.produto              r INNER JOIN i.notaFiscalTerceiros  n INNER JOIN n.empresa              m INNER JOIN n.unidadeFatFornecedor u INNER JOIN u.fornecedor           o INNER JOIN o.pessoa               p INNER JOIN t.ticketEntrada        e INNER JOIN e.loteFabricacao       l INNER JOIN l.fichaTecnica         f INNER JOIN f.ajusteEstoque        a WHERE p.identificador  = :idPessoa AND   m.identificador  = :idEmpresa AND   r.identificador  = :idProduto AND   n.dataEntrada   >= :data ORDER BY n.dataEntrada");
        q.setLong("idPessoa", idPessoa.longValue());
        q.setLong("idEmpresa", IdEmpresa.longValue());
        q.setLong("idProduto", idProduto.longValue());
        q.setDate("data", data);
        q.setMaxResults(1);
        return (Date)q.uniqueResult();
    }
}

