/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.dao.impl;

import com.touchcomp.basementor.model.vo.ApuracaoReinf;
import com.touchcomp.basementorservice.dao.DaoGenericEntityImpl;
import com.touchcomp.basementorservice.dao.builders.AuxCriteriaBuilder;
import com.touchcomp.basementortools.tools.date.ToolDate;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import javax.persistence.criteria.From;
import javax.persistence.criteria.Join;
import org.springframework.stereotype.Repository;

@Repository
public class DaoApuracaoReinfImpl
extends DaoGenericEntityImpl<ApuracaoReinf, Long> {
    public List<HashMap> getDadosDetalhamentoImpostoItensReinf4020ByPeriodoGrupoEmpresa(Date dataPeriodo, Long grupoEmpresa) {
        AuxCriteriaBuilder aux = this.queryBuilder();
        Join jEmpresa = aux.join("empresa");
        Join jEmpresaDados = jEmpresa.join("empresaDados");
        Join jGrupoEmpresa = jEmpresaDados.join("grupoEmpresa");
        Join jItensReinf4020 = aux.join("itensReinf4020");
        Join jItemReinfNotas4020 = jItensReinf4020.join("itensNotas");
        aux.select(aux.getSum(AuxCriteriaBuilder.pair((From)jItemReinfNotas4020, "valorCofins", "valorCofins")));
        aux.select(aux.getSum(AuxCriteriaBuilder.pair((From)jItemReinfNotas4020, "valorPis", "valorPis")));
        aux.select(aux.getSum(AuxCriteriaBuilder.pair((From)jItemReinfNotas4020, "valorCsll", "valorCsll")));
        aux.select(aux.getSum(AuxCriteriaBuilder.pair((From)jItemReinfNotas4020, "valorAgregado", "valorAgregado")));
        aux.select(aux.getSum(AuxCriteriaBuilder.pair((From)jItemReinfNotas4020, "valorIrrf", "valorIrrf")));
        aux.between("periodo", ToolDate.getDataInicial((Date)dataPeriodo), (Comparable)ToolDate.getDataFinal((Date)dataPeriodo));
        aux.equal((From)jGrupoEmpresa, "identificador", grupoEmpresa);
        return aux.getResultMap();
    }

    public List<HashMap> getDadosDetalhamentoImpostoItensReinf4020NIByPeriodoGrupoEmpresa(Date dataPeriodo, Long grupoEmpresa) {
        AuxCriteriaBuilder aux = this.queryBuilder();
        Join jEmpresa = aux.join("empresa");
        Join jEmpresaDados = jEmpresa.join("empresaDados");
        Join jGrupoEmpresa = jEmpresaDados.join("grupoEmpresa");
        Join jItensReinf4020NI = aux.join("itensReinf4020NI");
        aux.select(aux.getSum(AuxCriteriaBuilder.pair((From)jItensReinf4020NI, "valorCofins", "valorCofins")));
        aux.select(aux.getSum(AuxCriteriaBuilder.pair((From)jItensReinf4020NI, "valorPis", "valorPis")));
        aux.select(aux.getSum(AuxCriteriaBuilder.pair((From)jItensReinf4020NI, "valorCsll", "valorCsll")));
        aux.select(aux.getSum(AuxCriteriaBuilder.pair((From)jItensReinf4020NI, "valorAgregado", "valorAgregado")));
        aux.select(aux.getSum(AuxCriteriaBuilder.pair((From)jItensReinf4020NI, "valorIrrf", "valorIrrf")));
        aux.between("periodo", ToolDate.getDataInicial((Date)dataPeriodo), (Comparable)ToolDate.getDataFinal((Date)dataPeriodo));
        aux.equal((From)jGrupoEmpresa, "identificador", grupoEmpresa);
        return aux.getResultMap();
    }

    public Double getDadosDetalhamentoImpostoItensReinf4010ByPeriodoGrupoEmpresa(Date dataPeriodo, Long grupoEmpresa) {
        AuxCriteriaBuilder aux = this.queryBuilder();
        Join jEmpresa = aux.join("empresa");
        Join jEmpresaDados = jEmpresa.join("empresaDados");
        Join jGrupoEmpresa = jEmpresaDados.join("grupoEmpresa");
        Join jItensReinf4010 = aux.join("itensReinf4010");
        Join jItemReinfNotas4010 = jItensReinf4010.join("itensNotas");
        Join jNotaFiscalTerceiros = jItemReinfNotas4010.join("notaTerceiros");
        Join jLivroFiscal = jNotaFiscalTerceiros.join("livrosFiscais");
        aux.select(aux.getSum(AuxCriteriaBuilder.pair((From)jLivroFiscal, "valorIrrf", "valorIrrf")));
        aux.between("periodo", ToolDate.getDataInicial((Date)dataPeriodo), (Comparable)ToolDate.getDataFinal((Date)dataPeriodo));
        aux.equal((From)jGrupoEmpresa, "identificador", grupoEmpresa);
        return (Double)aux.getUniqueResult();
    }

    public Double getDadosDetalhamentoImpostoItensReinf4040ByPeriodoGrupoEmpresa(Date dataPeriodo, Long grupoEmpresa) {
        AuxCriteriaBuilder aux = this.queryBuilder();
        Join jEmpresa = aux.join("empresa");
        Join jEmpresaDados = jEmpresa.join("empresaDados");
        Join jGrupoEmpresa = jEmpresaDados.join("grupoEmpresa");
        Join jItemReinf4040 = aux.join("itensReinf4040");
        aux.select(aux.getSum(AuxCriteriaBuilder.pair((From)jItemReinf4040, "vlrIrrf", "vlrIrrf")));
        aux.between("periodo", ToolDate.getDataInicial((Date)dataPeriodo), (Comparable)ToolDate.getDataFinal((Date)dataPeriodo));
        aux.equal((From)jGrupoEmpresa, "identificador", grupoEmpresa);
        return (Double)aux.getUniqueResult();
    }

    public List<HashMap> getDadosDetalhamentoImpostoItensReinf2010ByPeriodoGrupoEmpresa(Date dataPeriodo, Long grupoEmpresa) {
        AuxCriteriaBuilder aux = this.queryBuilder();
        Join jEmpresa = aux.join("empresa");
        Join jEmpresaDados = jEmpresa.join("empresaDados");
        Join jGrupoEmpresa = jEmpresaDados.join("grupoEmpresa");
        Join jItemReinf2010 = aux.join("itens2010");
        Join jPessoa = jItemReinf2010.join("pessoa");
        Join jComplemento = jPessoa.join("complemento");
        Join jItemReinfNotas2010 = jItemReinf2010.join("itens");
        Join jNotaFiscalTerceiros = jItemReinfNotas2010.join("notaTerceiros");
        Join jItemNotaTerceiros = jNotaFiscalTerceiros.join("itemNotaTerceiros");
        Join jItemNotaLivroFiscal = jItemNotaTerceiros.join("itemNotaLivroFiscal");
        aux.select(AuxCriteriaBuilder.pair((From)jComplemento, "cnpj", "cnpj"));
        aux.select(aux.getSum(AuxCriteriaBuilder.pair((From)jItemNotaLivroFiscal, "vrInss", "vrInss")));
        aux.between("periodo", ToolDate.getDataInicial((Date)dataPeriodo), (Comparable)ToolDate.getDataFinal((Date)dataPeriodo));
        aux.equal((From)jGrupoEmpresa, "identificador", grupoEmpresa);
        aux.groupBy(AuxCriteriaBuilder.pair((From)jComplemento, "cnpj"));
        return aux.getResultMap();
    }
}

