/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.dao.impl;

import com.touchcomp.basementor.model.vo.AnexoSimplesNacional;
import com.touchcomp.basementor.model.vo.ApuracaoSimplesNacional;
import com.touchcomp.basementor.model.vo.ApuracaoSimplesNacionalMes;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.TabelaSimplesNacional;
import com.touchcomp.basementorservice.dao.DaoGenericEntityImpl;
import java.util.Date;
import java.util.List;
import org.hibernate.query.Query;
import org.springframework.stereotype.Repository;

@Repository
public class DaoApuracaoSimplesNacionalImpl
extends DaoGenericEntityImpl<ApuracaoSimplesNacional, Long> {
    public List<ApuracaoSimplesNacionalMes> getPeriodosAnteriores(Date periodo, Empresa empresa, AnexoSimplesNacional anexoSimplesNacional) {
        String query = "select distinct a   from ApuracaoSimplesNacionalMes a where a.periodo < :periodo and a.empresa = :empresa and a.anexoSimplesNacional = :anexoSimplesNacional order by a.periodo desc";
        Query q = this.query(query);
        q.setEntity("empresa", (Object)empresa);
        q.setDate("periodo", periodo);
        q.setEntity("anexoSimplesNacional", (Object)anexoSimplesNacional);
        q.setMaxResults(12);
        return q.list();
    }

    public Double valorTotalFaturamentoAnexoIndustria(Date dataInicial, Date dataFinal, Empresa empresa) {
        Double valor = this.getValorNotasFiscaisProprias(dataInicial, dataFinal, empresa);
        return valor;
    }

    public Double valorTotalFaturamentoAnexoServicos(Date dataInicial, Date dataFinal, Empresa empresa) {
        Double valor = this.getValorNotasFiscaisPropriasServico(dataInicial, dataFinal, empresa);
        valor = valor + this.getValorRPS(dataInicial, dataFinal, empresa);
        return valor;
    }

    public Double valorTotalDevolucoesAnexoIndustria(Date dataInicial, Date dataFinal, Empresa empresa) {
        Query q = this.query("select  coalesce(sum(lv.valorTotal), 0)  from LivroFiscal lv where lv.dataLivro between :dataIn and :dataFim and lv.empresa = :empresa and (lv.entradaSaidaNaturezaOp = :entSaida1 or lv.entradaSaidaNaturezaOp = :entSaida2) and lv.cancelado = :cancelado and lv.cfop.cfopDevolucaoVenda = :cfopDevolucaoVenda");
        q.setDate("dataIn", dataInicial);
        q.setDate("dataFim", dataFinal);
        q.setEntity("empresa", (Object)empresa);
        q.setShort("entSaida1", (short)2);
        q.setShort("entSaida2", (short)0);
        q.setShort("cancelado", (short)0);
        q.setShort("cfopDevolucaoVenda", (short)1);
        return (Double)q.uniqueResult();
    }

    public boolean existeApuracoesPosteriores(ApuracaoSimplesNacional vo) {
        Query q = this.query("select a.identificador from ApuracaoSimplesNacional a where a.periodo > :periodo and a.empresa = :empresa");
        q.setDate("periodo", vo.getPeriodo());
        q.setEntity("empresa", (Object)vo.getEmpresa());
        Long id = (Long)q.uniqueResult();
        return id != null;
    }

    public TabelaSimplesNacional findAliquotaSimples(AnexoSimplesNacional anexo, Double valorAcumulado) {
        Query q = this.query("select distinct a from TabelaSimplesNacional a where a.valorInicial <= :valorAcumulado and a.valorFinal >= :valorAcumulado and a.anexoSimplesNacional = :anexo");
        q.setDouble("valorAcumulado", valorAcumulado.doubleValue());
        q.setEntity("anexo", (Object)anexo);
        return (TabelaSimplesNacional)q.uniqueResult();
    }

    private Double getValorNotasFiscaisProprias(Date dataInicial, Date dataFinal, Empresa empresa) {
        Query q = this.query("select  coalesce(sum(lv.valorTotal), 0) from NotaFiscalPropria n  inner join n.livrosFiscais lv  where lv.dataLivro between :dataIn and :dataFim and lv.empresa = :empresa and lv.entradaSaidaNaturezaOp = :entSaida and lv.cancelado = :cancelado and lv.cfop.cfopDevolucaoVenda = :nao and lv.cfop.cfopReceitaVenda = :sim and n.modeloDocFiscal.modeloServico = :nao");
        q.setDate("dataIn", dataInicial);
        q.setDate("dataFim", dataFinal);
        q.setEntity("empresa", (Object)empresa);
        q.setShort("entSaida", (short)1);
        q.setShort("cancelado", (short)0);
        q.setShort("nao", (short)0);
        q.setShort("sim", (short)1);
        return (Double)q.uniqueResult();
    }

    private Double getValorNotasFiscaisPropriasServico(Date dataInicial, Date dataFinal, Empresa empresa) {
        Query q = this.query("select  coalesce(sum(lv.valorTotal), 0) from NotaFiscalPropria n  inner join n.livrosFiscais lv  where lv.dataLivro between :dataIn and :dataFim and lv.empresa = :empresa and lv.entradaSaidaNaturezaOp = :entSaida and lv.cancelado = :cancelado and lv.cfop.cfopDevolucaoVenda = :nao and lv.cfop.cfopReceitaVenda = :sim and n.modeloDocFiscal.modeloServico = :sim");
        q.setDate("dataIn", dataInicial);
        q.setDate("dataFim", dataFinal);
        q.setEntity("empresa", (Object)empresa);
        q.setShort("entSaida", (short)1);
        q.setShort("cancelado", (short)0);
        q.setShort("nao", (short)0);
        q.setShort("sim", (short)1);
        return (Double)q.uniqueResult();
    }

    private Double getValorRPS(Date dataInicial, Date dataFinal, Empresa empresa) {
        Query q = this.query("select  coalesce(sum(lv.valorLiquidoNfse), 0) from Rps lv  where lv.dataEmissao between :dataIn and :dataFim and lv.empresa = :empresa and lv.status = :normal");
        q.setDate("dataIn", dataInicial);
        q.setDate("dataFim", dataFinal);
        q.setEntity("empresa", (Object)empresa);
        q.setShort("normal", (short)1);
        return (Double)q.uniqueResult();
    }
}

