/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.dao.impl;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.pessoa.EnumConstTipoPessoaComplementar;
import com.touchcomp.basementor.model.vo.BaixaTituloPisCofins;
import com.touchcomp.basementor.model.vo.GrupoEmpresa;
import com.touchcomp.basementorservice.dao.DaoGenericEntityImpl;
import com.touchcomp.basementortools.tools.date.ToolDate;
import java.util.Date;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.query.Query;
import org.springframework.stereotype.Repository;

@Repository
public class DaoBaixaTituloPisCofinsImpl
extends DaoGenericEntityImpl<BaixaTituloPisCofins, Long> {
    public List<BaixaTituloPisCofins> getBaixaTituloPisCofinsPorPeriodoAndGrupoEmpresa(Date dataInicial, Date dataFinal, GrupoEmpresa grupoEmpresa) {
        Query q = this.query(" select distinct b from BaixaTituloPisCofins b where b.baixaTitulo.grupoDeBaixaFormas.grupoDeBaixa.dataLiquidacao between :dataInicial and :dataFinal and b.baixaTitulo.titulo.empresa.empresaDados.grupoEmpresa = :grupoEmpresa");
        q.setEntity("grupoEmpresa", (Object)grupoEmpresa);
        q.setDate("dataInicial", dataInicial);
        q.setDate("dataFinal", dataFinal);
        return q.list();
    }

    public List<BaixaTituloPisCofins> apuracaoValores4020Impostos(GrupoEmpresa grupo, Date periodo) {
        Criteria criteria = this.criteria();
        criteria.createAlias("baixaTitulo", "a");
        criteria.createAlias("a.titulo", "t");
        criteria.createAlias("t.empresa", "e");
        criteria.createAlias("e.empresaDados", "m");
        criteria.createAlias("m.grupoEmpresa", "g");
        criteria.createAlias("a.grupoDeBaixaFormas", "u");
        criteria.createAlias("u.grupoDeBaixa", "p");
        criteria.createAlias("b.modeloDocFiscal", "o");
        criteria.createAlias("b.tituloPisCofins", "i");
        criteria.createAlias("i.titulo", "s");
        criteria.createAlias("s.pessoa", "x");
        criteria.createAlias("x.complemento", "l");
        criteria.createAlias("s.infPagamentoNfTerceiros", "ip");
        criteria.add(this.eq("g", grupo));
        criteria.add(this.between("p.dataLiquidacao", ToolDate.getDataInicial((Date)periodo), ToolDate.getDataFinal((Date)periodo)));
        criteria.add(this.eq("o.modeloServico", EnumConstantsMentorSimNao.SIM.getValue()));
        criteria.add(this.eq("l.tipoPessoa", EnumConstTipoPessoaComplementar.JURIDICA.getEnumId()));
        return criteria.list();
    }
}

