/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.dao.impl;

import com.touchcomp.basementor.model.vo.BoletoTitulo;
import com.touchcomp.basementor.model.vo.ItemAltBoletoHist;
import com.touchcomp.basementor.model.vo.Titulo;
import com.touchcomp.basementorservice.dao.DaoGenericEntityImpl;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.hibernate.query.Query;
import org.springframework.stereotype.Repository;

@Repository
public class DaoBoletoTituloImpl
extends DaoGenericEntityImpl<BoletoTitulo, Long> {
    public void deletarTituloBoleto(BoletoTitulo b) {
        String query = "UPDATE BoletoTitulo b SET b.titulo = null, b.ativo = :ativo WHERE b = :boleto";
        Query q = this.query(query);
        q.setShort("ativo", (short)0);
        q.setEntity("boleto", (Object)b);
        q.executeUpdate();
    }

    public List<ItemAltBoletoHist> findItensAltBoleto(Titulo titulo) {
        Criteria c = this.getSession().createCriteria(ItemAltBoletoHist.class);
        c.createAlias("boletoTitulo", "b");
        c.add((Criterion)Restrictions.eq((String)"b.titulo", (Object)titulo));
        c.setResultTransformer(Criteria.DISTINCT_ROOT_ENTITY);
        return c.list();
    }

    public BoletoTitulo getBoletoAtivo(Titulo titulo) {
        Criteria c = this.getSession().createCriteria(BoletoTitulo.class);
        c.add((Criterion)Restrictions.eq((String)"titulo", (Object)titulo));
        c.add((Criterion)Restrictions.eq((String)"ativo", (Object)1));
        c.setResultTransformer(Criteria.DISTINCT_ROOT_ENTITY);
        c.setMaxResults(1);
        c.addOrder(Order.desc((String)"dataCadastro"));
        return (BoletoTitulo)c.uniqueResult();
    }

    public void updateBolTitulosExclusao(Titulo titulo) {
        Query q = this.query("update BoletoTitulo l set l.titulo = null where l.titulo = :titulo");
        q.setEntity("titulo", (Object)titulo);
        q.executeUpdate();
    }

    public List<BoletoTitulo> findBoletoTituloByTitulo(Titulo titulo) {
        Query q = this.query(" select b  from BoletoTitulo b  where b.titulo = :titulo  and b.ativo = :sim ");
        q.setEntity("titulo", (Object)titulo);
        q.setShort("sim", (short)1);
        return q.list();
    }

    public List<BoletoTitulo> getBoletos(Titulo t) {
        return this.toList(this.restrictions(this.eq("titulo", t)));
    }

    public List<BoletoTitulo> getBoletosParaCentralCobranca(String cnpj) {
        String query = "select b as boleto\nfrom BoletoTitulo b\ninner join b.titulo t \nwhere t.pessoa.complemento.cnpj = :cnpj\nand t.valorSaldo > 0\nand b.ativo = 1\norder by b.titulo.dataVencimento ";
        Query q = this.query(query);
        q.setString("cnpj", cnpj);
        return q.list();
    }
}

