/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.dao.impl;

import com.touchcomp.basementor.model.vo.BorderoTitulos;
import com.touchcomp.basementor.model.vo.Titulo;
import com.touchcomp.basementorservice.dao.DaoGenericEntityImpl;
import java.util.ArrayList;
import java.util.LinkedList;
import java.util.List;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.hibernate.query.Query;
import org.springframework.stereotype.Repository;

@Repository
public class DaoBorderoTitulosImpl
extends DaoGenericEntityImpl<BorderoTitulos, Long> {
    public BorderoTitulos pesquisarBorderoTitulosPorTitulo(Titulo titulo) {
        Query q = this.query("SELECT DISTINCT t FROM BorderoTitulos t INNER JOIN t.itemBorderoCobranca i WHERE i.titulo = :titulo");
        q.setParameter("titulo", (Object)titulo);
        q.setMaxResults(1);
        return (BorderoTitulos)q.uniqueResult();
    }

    public List<BorderoTitulos> findBorderoTitulosByTitulo(Long idTitulo) {
        try {
            CriteriaBuilder builder = this.criteriaBuilder(BorderoTitulos.class);
            CriteriaQuery crit = builder.createQuery();
            LinkedList<Predicate> exps = new LinkedList<Predicate>();
            Root fromBaixaTitulo = crit.from(BorderoTitulos.class);
            Join jItemBorderoCobranca = fromBaixaTitulo.join("itemBorderoCobranca", JoinType.INNER);
            Join jTitulo = jItemBorderoCobranca.join("titulo", JoinType.INNER);
            crit.select((Selection)fromBaixaTitulo);
            exps.add(builder.equal((Expression)jTitulo.get("identificador"), (Object)idTitulo));
            crit.where(exps.toArray(new Predicate[0]));
            return this.getEntityManager().createQuery(crit).getResultList();
        }
        catch (Exception ex) {
            return new ArrayList<BorderoTitulos>();
        }
    }
}

