/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.dao.impl;

import com.touchcomp.basementor.model.vo.CadastroBeneficioRefeicaoCesta;
import com.touchcomp.basementor.model.vo.Colaborador;
import com.touchcomp.basementor.model.vo.PeriodoFolhaPagamento;
import com.touchcomp.basementorservice.dao.DaoGenericEntityImpl;
import java.util.LinkedList;
import java.util.List;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.springframework.stereotype.Repository;

@Repository
public class DaoCadastroBeneficioRefeicaoCestaImpl
extends DaoGenericEntityImpl<CadastroBeneficioRefeicaoCesta, Long> {
    public List<CadastroBeneficioRefeicaoCesta> getBeneficiosColabAtivos(PeriodoFolhaPagamento periodoFolhaPagamento) {
        String hql = " select distinct beneficio  from CadastroBeneficioRefeicaoCesta beneficio  where  beneficio.colaborador.empresa = :empresa   and  (beneficio.colaborador.dataDemissao is null or beneficio.colaborador.dataDemissao > :dataInicialFolha)  and  beneficio.colaborador.ativo = :sim  and  not exists ( select af.colaborador               from AfastamentoColaborador af               where               af.dataAfastamento != null               and               af.colaborador = beneficio.colaborador               and               af.afastamentoSefip.codigo != :aposentadoria               and               af.dataAfastamento < :dataInicio               and               (af.dataRetorno is null or af.dataRetorno > :dataFinal))  and  beneficio.periodoBeneficio = (select max(ben.periodoBeneficio)                               from CadastroBeneficioRefeicaoCesta ben                               where ben.colaborador = beneficio.colaborador                               and ben.periodoBeneficio <= :dataFinal )";
        List ret = this.query(hql).setDate("dataInicio", periodoFolhaPagamento.getDataInicialFolha()).setDate("dataFinal", periodoFolhaPagamento.getDataFinalFolha()).setDate("dataInicialFolha", periodoFolhaPagamento.getDataInicialFolha()).setString("aposentadoria", "U1").setEntity("empresa", (Object)periodoFolhaPagamento.getEmpresa()).setShort("sim", (short)1).list();
        return ret;
    }

    public CadastroBeneficioRefeicaoCesta getBeneficiosColabAtivosPorColaboradorAndTipoTicket(PeriodoFolhaPagamento periodoFolhaPagamento, Colaborador colaborador, Short tipoTicket) {
        String hql = " select distinct beneficio  from CadastroBeneficioRefeicaoCesta beneficio  where  beneficio.colaborador = :colaborador and  beneficio.tipoTicket = :tipoTicket and  beneficio.colaborador.empresa = :empresa   and  (beneficio.colaborador.dataDemissao is null or beneficio.colaborador.dataDemissao > :dataInicialFolha)  and  beneficio.colaborador.ativo = :sim  and  not exists ( select af.colaborador               from AfastamentoColaborador af               where               af.dataAfastamento != null               and               af.colaborador = beneficio.colaborador               and               af.afastamentoSefip.codigo != :aposentadoria               and               af.dataAfastamento < :dataInicio               and               (af.dataRetorno is null or af.dataRetorno > :dataFinal))  and  beneficio.periodoBeneficio = (select max(ben.periodoBeneficio)                               from CadastroBeneficioRefeicaoCesta ben                               where ben.colaborador = beneficio.colaborador                               and ben.periodoBeneficio <= :dataFinal )";
        return (CadastroBeneficioRefeicaoCesta)this.query(hql).setDate("dataInicio", periodoFolhaPagamento.getDataInicialVA()).setDate("dataFinal", periodoFolhaPagamento.getDataFinalVA()).setDate("dataInicialFolha", periodoFolhaPagamento.getDataInicialVA()).setString("aposentadoria", "U1").setEntity("empresa", (Object)periodoFolhaPagamento.getEmpresa()).setEntity("colaborador", (Object)colaborador).setShort("tipoTicket", tipoTicket.shortValue()).setShort("sim", (short)1).setMaxResults(1).uniqueResult();
    }

    public List<CadastroBeneficioRefeicaoCesta> getBeneficioRefeicaoCestaPorColaborador(Long idColaborador) {
        try {
            CriteriaBuilder builder = this.criteriaBuilder(CadastroBeneficioRefeicaoCesta.class);
            CriteriaQuery crit = builder.createQuery();
            LinkedList<Predicate> exps = new LinkedList<Predicate>();
            Root root = crit.from(CadastroBeneficioRefeicaoCesta.class);
            Join jColaborador = root.join("colaborador", JoinType.INNER);
            crit.select((Selection)root);
            exps.add(builder.equal((Expression)jColaborador.get("identificador"), (Object)idColaborador));
            crit.where(exps.toArray(new Predicate[0]));
            return this.getEntityManager().createQuery(crit).getResultList();
        }
        catch (Exception e) {
            return null;
        }
    }
}

