/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.dao.impl;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.model.vo.CadastroEventoConsignado;
import com.touchcomp.basementorservice.dao.DaoGenericEntityImpl;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Disjunction;
import org.hibernate.criterion.Restrictions;
import org.springframework.stereotype.Repository;

@Repository
public class DaoCadastroEventoConsignadoImpl
extends DaoGenericEntityImpl<CadastroEventoConsignado, Long> {
    public List<CadastroEventoConsignado> verificarExisteEventoConsignado(CadastroEventoConsignado cadastroEventoConsignado) {
        Criteria c = this.criteria();
        Disjunction dataInicio = Restrictions.or((Criterion[])new Criterion[0]);
        dataInicio.add(this.greatherEqual("dataInicioDesconto", cadastroEventoConsignado.getDataInicioDesconto()));
        dataInicio.add(this.lessEqual("dataFinalDesconto", cadastroEventoConsignado.getDataInicioDesconto()));
        Disjunction dataFinal = Restrictions.or((Criterion[])new Criterion[0]);
        dataFinal.add(this.greatherEqual("dataInicioDesconto", cadastroEventoConsignado.getDataFinalDesconto()));
        dataFinal.add(this.lessEqual("dataFinalDesconto", cadastroEventoConsignado.getDataFinalDesconto()));
        Disjunction intervalo = Restrictions.or((Criterion[])new Criterion[0]);
        intervalo.add((Criterion)dataInicio);
        intervalo.add((Criterion)dataFinal);
        c.add((Criterion)intervalo);
        c.add(this.eq("colaborador", cadastroEventoConsignado.getColaborador()));
        c.add(this.eq("eventoConsignado", cadastroEventoConsignado.getEventoConsignado()));
        c.add(this.eq("renegociado", EnumConstantsMentorSimNao.NAO.getValue()));
        if (cadastroEventoConsignado.getIdentificador() != null) {
            c.add(this.eq("identificador", cadastroEventoConsignado.getIdentificador()));
        }
        return c.list();
    }
}

