/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.dao.impl;

import com.touchcomp.basementor.model.vo.AberturaPeriodo;
import com.touchcomp.basementor.model.vo.CalculoInssEmpresa;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementorservice.dao.DaoGenericEntityImpl;
import com.touchcomp.basementorservice.dao.builders.AuxCriteriaBuilder;
import com.touchcomp.basementortools.tools.date.ToolDate;
import java.util.Date;
import java.util.HashMap;
import java.util.LinkedList;
import java.util.List;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.From;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.hibernate.query.Query;
import org.hibernate.transform.AliasToEntityMapResultTransformer;
import org.hibernate.transform.ResultTransformer;
import org.springframework.stereotype.Repository;

@Repository
public class DaoCalculoInssEmpresaImpl
extends DaoGenericEntityImpl<CalculoInssEmpresa, Long> {
    public Double getPercDesoneracao(AberturaPeriodo aberturaPeriodo) {
        String hql = " select coalesce(c.percDesoneracao,0)  from CalculoInssEmpresa c  inner join c.aberturasPeriodo abr  where  abr.aberturaPeriodo = :aberturaPeriodo ";
        Query q = this.query(hql);
        q.setParameter("aberturaPeriodo", (Object)aberturaPeriodo);
        return (Double)q.uniqueResult();
    }

    public Object getaDadosInssByPeriodoGrupoEmpresa(Date dataPeriodo, Long grupoEmpresa) {
        CriteriaBuilder builder = this.criteriaBuilder(CalculoInssEmpresa.class);
        CriteriaQuery crit = builder.createQuery();
        LinkedList<Predicate> exps = new LinkedList<Predicate>();
        LinkedList<Selection> selects = new LinkedList<Selection>();
        Root fromCalculoInssEmpresa = crit.from(CalculoInssEmpresa.class);
        Join jEmpresa = fromCalculoInssEmpresa.join("empresa", JoinType.INNER);
        Join jEmpresaDados = jEmpresa.join("empresaDados", JoinType.INNER);
        Join jGrupoEmpresa = jEmpresaDados.join("grupoEmpresa", JoinType.INNER);
        selects.add(builder.sum((Expression)fromCalculoInssEmpresa.get("valorTotalInssFunc")).alias("teste"));
        selects.add(builder.sum((Expression)fromCalculoInssEmpresa.get("vlrContribuinteIndividual")).alias("vlrContribuinteIndividual"));
        selects.add(builder.sum((Expression)fromCalculoInssEmpresa.get("vlrTotalAutonomoFrete")).alias("vlrTotalAutonomoFrete"));
        selects.add(builder.sum((Expression)fromCalculoInssEmpresa.get("valorTotalInssEmpresa")).alias("valorTotalInssEmpresa"));
        selects.add(builder.sum((Expression)fromCalculoInssEmpresa.get("vlrTotalAutonomo")).alias("vlrTotalAutonomo"));
        selects.add(builder.sum((Expression)fromCalculoInssEmpresa.get("vlrAutonomoFreteEmpresa")).alias("vlrAutonomoFreteEmpresa"));
        selects.add(builder.sum((Expression)fromCalculoInssEmpresa.get("valorAposentadoriaEspecial15")).alias("valorAposentadoriaEspecial15"));
        selects.add(builder.sum((Expression)fromCalculoInssEmpresa.get("valorAposentadoriaEspecial20")).alias("valorAposentadoriaEspecial20"));
        selects.add(builder.sum((Expression)fromCalculoInssEmpresa.get("valorAposentadoriaEspecial")).alias("valorAposentadoriaEspecial"));
        selects.add(builder.sum((Expression)fromCalculoInssEmpresa.get("valorFunruralFisica")).alias("valorFunruralFisica"));
        selects.add(builder.sum((Expression)fromCalculoInssEmpresa.get("valorFunruralJuridica")).alias("valorFunruralJuridica"));
        selects.add(builder.sum((Expression)fromCalculoInssEmpresa.get("valorFunruralFisicaOE")).alias("valorFunruralFisicaOE"));
        selects.add(builder.sum((Expression)fromCalculoInssEmpresa.get("valorFunruralJuridicaOE")).alias("valorFunruralJuridicaOE"));
        selects.add(builder.sum((Expression)fromCalculoInssEmpresa.get("vlrTerceiros")).alias("vlrTerceiros"));
        selects.add(builder.sum((Expression)fromCalculoInssEmpresa.get("valorTotalRat")).alias("valorTotalRat"));
        selects.add(builder.sum((Expression)fromCalculoInssEmpresa.get("vlrTotalSescSenac")).alias("vlrTotalSescSenac"));
        selects.add(builder.sum((Expression)fromCalculoInssEmpresa.get("vlrSalarioFamilia")).alias("vlrSalarioFamilia"));
        selects.add(builder.sum((Expression)fromCalculoInssEmpresa.get("salarioMaternidade")).alias("salarioMaternidade"));
        crit.multiselect(selects);
        exps.add(builder.between((Expression)fromCalculoInssEmpresa.get("periodoFolha"), (Comparable)dataPeriodo, (Comparable)ToolDate.getLastDateOnMonth((Date)dataPeriodo)));
        exps.add(builder.equal((Expression)jGrupoEmpresa.get("identificador"), (Object)grupoEmpresa));
        crit.where(exps.toArray(new Predicate[0]));
        return this.getEntityManager().createQuery(crit).getResultList();
    }

    public List<HashMap> getDadosInssByPeriodoGrupoEmpresa(Date dataPeriodo, Long grupoEmpresa) {
        AuxCriteriaBuilder aux = this.queryBuilder();
        Join jEmpresa = aux.join("empresa");
        Join jEmpresaDados = jEmpresa.join("empresaDados");
        Join jGrupoEmpresa = jEmpresaDados.join("grupoEmpresa");
        aux.select(aux.getSum(AuxCriteriaBuilder.pair(aux.from(), "valorTotalInssFunc", "valorTotalInssFunc")));
        aux.select(aux.getSum(AuxCriteriaBuilder.pair(aux.from(), "vlrContribuinteIndividual", "vlrContribuinteIndividual")));
        aux.select(aux.getSum(AuxCriteriaBuilder.pair(aux.from(), "vlrTotalAutonomoFrete", "vlrTotalAutonomoFrete")));
        aux.select(aux.getSum(AuxCriteriaBuilder.pair(aux.from(), "valorTotalInssEmpresa", "valorTotalInssEmpresa")));
        aux.select(aux.getSum(AuxCriteriaBuilder.pair(aux.from(), "vlrTotalAutonomo", "vlrTotalAutonomo")));
        aux.select(aux.getSum(AuxCriteriaBuilder.pair(aux.from(), "vlrAutonomoFreteEmpresa", "vlrAutonomoFreteEmpresa")));
        aux.select(aux.getSum(AuxCriteriaBuilder.pair(aux.from(), "valorAposentadoriaEspecial15", "valorAposentadoriaEspecial15")));
        aux.select(aux.getSum(AuxCriteriaBuilder.pair(aux.from(), "valorAposentadoriaEspecial20", "valorAposentadoriaEspecial20")));
        aux.select(aux.getSum(AuxCriteriaBuilder.pair(aux.from(), "valorAposentadoriaEspecial", "valorAposentadoriaEspecial")));
        aux.select(aux.getSum(AuxCriteriaBuilder.pair(aux.from(), "valorFunruralFisica", "valorFunruralFisica")));
        aux.select(aux.getSum(AuxCriteriaBuilder.pair(aux.from(), "valorFunruralJuridica", "valorFunruralJuridica")));
        aux.select(aux.getSum(AuxCriteriaBuilder.pair(aux.from(), "valorFunruralFisicaOE", "valorFunruralFisicaOE")));
        aux.select(aux.getSum(AuxCriteriaBuilder.pair(aux.from(), "valorFunruralJuridicaOE", "valorFunruralJuridicaOE")));
        aux.select(aux.getSum(AuxCriteriaBuilder.pair(aux.from(), "vlrTerceiros", "vlrTerceiros")));
        aux.select(aux.getSum(AuxCriteriaBuilder.pair(aux.from(), "valorTotalRat", "valorTotalRat")));
        aux.select(aux.getSum(AuxCriteriaBuilder.pair(aux.from(), "vlrTotalSescSenac", "vlrTotalSescSenac")));
        aux.select(aux.getSum(AuxCriteriaBuilder.pair(aux.from(), "vlrSalarioFamilia", "vlrSalarioFamilia")));
        aux.select(aux.getSum(AuxCriteriaBuilder.pair(aux.from(), "salarioMaternidade", "salarioMaternidade")));
        aux.between("periodoFolha", ToolDate.getDataInicial((Date)dataPeriodo), (Comparable)ToolDate.getDataFinal((Date)dataPeriodo));
        aux.equal((From)jGrupoEmpresa, "identificador", grupoEmpresa);
        return aux.getResultMap();
    }

    public List<HashMap> findCalculoInssEmpresaPorDataPagamentoEmpresa(Date dataPagamento, Empresa empresa) {
        return this.query("SELECT c.identificador AS ID_CALCULO_INSS_EMPRESA, COALESCE(c.gps, 0) AS GPS,  b.dataFinal AS DATA_FINAL FROM CalculoInssEmpresa c INNER JOIN c.aberturasPeriodo a INNER JOIN a.aberturaPeriodo b WHERE b.dataPagamento = :dataPagamento  AND not exists (select i from ItemOutrosTitulosFolha i where i.aberturaPeriodoFgts = a) AND c.empresa = :empresa").setParameter("dataPagamento", (Object)dataPagamento).setParameter("empresa", (Object)empresa).setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE).list();
    }
}

