/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.dao.impl;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.situacaocobranca.EnumConstSituacaoCobranca;
import com.touchcomp.basementor.model.vo.CarteiraCobranca;
import com.touchcomp.basementor.model.vo.InstituicaoValores;
import com.touchcomp.basementorservice.dao.DaoGenericEntityImpl;
import com.touchcomp.basementorservice.dao.builders.AuxCriteriaBuilder;
import java.util.LinkedList;
import java.util.List;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.From;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.springframework.stereotype.Repository;

@Repository
public class DaoCarteiraCobrancaImpl
extends DaoGenericEntityImpl<CarteiraCobranca, Long> {
    public CarteiraCobranca findCarteiraCobrancaByColaborador(Long instituicaoValor, Long grupoEmpresa) {
        try {
            CriteriaBuilder builder = this.criteriaBuilder(CarteiraCobranca.class);
            CriteriaQuery crit = builder.createQuery();
            LinkedList<Predicate> exps = new LinkedList<Predicate>();
            Root fromCarteiraCobranca = crit.from(CarteiraCobranca.class);
            Join jContaValores = fromCarteiraCobranca.join("contaValor", JoinType.INNER);
            Join jAgenciaValores = jContaValores.join("agenciaValor", JoinType.INNER);
            Join jBanco = jAgenciaValores.join("instituicaoValor", JoinType.INNER);
            Join jEmpresaFinanceiro = jContaValores.join("empresaFinanceiro", JoinType.INNER);
            Join jEmpresa = fromCarteiraCobranca.join("empresa", JoinType.INNER);
            Join jEmpresaDados = jEmpresa.join("empresaDados", JoinType.INNER);
            Join jgrupoEmpresa = jEmpresaDados.join("grupoEmpresa", JoinType.INNER);
            crit.select((Selection)fromCarteiraCobranca);
            exps.add(builder.equal((Expression)jBanco.get("identificador"), (Object)instituicaoValor));
            exps.add(builder.equal((Expression)fromCarteiraCobranca.get("pagamentoCnab"), (Object)EnumConstantsMentorSimNao.SIM.getValue()));
            exps.add(builder.equal((Expression)jgrupoEmpresa.get("identificador"), (Object)grupoEmpresa));
            exps.add(builder.equal((Expression)fromCarteiraCobranca.get("ativo"), (Object)EnumConstantsMentorSimNao.SIM.getValue()));
            crit.where(exps.toArray(new Predicate[0]));
            return (CarteiraCobranca)this.getEntityManager().createQuery(crit).getSingleResult();
        }
        catch (Exception e) {
            return null;
        }
    }

    public CarteiraCobranca get(String branchNumber, String accountNumber, InstituicaoValores instituicaoValores, EnumConstSituacaoCobranca tipoCobranca) {
        AuxCriteriaBuilder builder = this.queryBuilder();
        Join jContaValor = builder.join("contaValor");
        Join jAgenciaValor = jContaValor.join("agenciaValor");
        Join jSituacaoCobranca = builder.join("situacaoCobranca");
        builder.equal((From)jAgenciaValor, "instituicaoValor", instituicaoValores);
        builder.equal((From)jAgenciaValor, "nrAgencia", branchNumber);
        builder.equal((From)jContaValor, "nrConta", accountNumber);
        builder.equal("ativo", (short)1);
        builder.equal((From)jSituacaoCobranca, "tipoCobranca", tipoCobranca.getCodigo());
        return (CarteiraCobranca)builder.getUniqueResult();
    }

    public CarteiraCobranca getByConvenio(List<String> convenios, InstituicaoValores instituicaoValores, EnumConstSituacaoCobranca tipoCobranca) {
        AuxCriteriaBuilder builder = this.queryBuilder();
        Join jContaValor = builder.join("contaValor");
        Join jAgenciaValor = jContaValor.join("agenciaValor");
        Join jSituacaoCobranca = builder.join("situacaoCobranca");
        builder.equal((From)jAgenciaValor, "instituicaoValor", instituicaoValores);
        builder.equal((From)jAgenciaValor, "nrAgencia", builder);
        builder.inString((From)jContaValor, "numeroConvenio", convenios);
        builder.equal("ativo", (short)1);
        builder.equal((From)jSituacaoCobranca, "tipoCobranca", tipoCobranca.getCodigo());
        return (CarteiraCobranca)builder.getUniqueResult();
    }
}

