/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.dao.impl;

import com.touchcomp.basementor.model.vo.CategoriaProduto;
import com.touchcomp.basementor.model.vo.TabelaPrecoBase;
import com.touchcomp.basementorservice.dao.DaoGenericEntityImpl;
import com.touchcomp.basementorservice.dao.builders.AuxCriteriaBuilder;
import com.touchcomp.touchvomodel.vo.categoriaproduto.web.DTOCategoriaProdutoArvore;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.persistence.criteria.From;
import javax.persistence.criteria.Join;
import org.hibernate.query.Query;
import org.springframework.stereotype.Repository;

@Repository
public class DaoCategoriaProdutoImpl
extends DaoGenericEntityImpl<CategoriaProduto, Long> {
    public List<CategoriaProduto> getAltCriaVincProdTabBase(Date lastSinc, TabelaPrecoBase tabBase, int firstRes, int maxRes) {
        Query query = this.query("select distinct cat from TabelaPrecoBaseProduto t inner join t.produto p inner join p.categoriasProduto cats inner join cats.categoriaProduto cat left join cat.categoriaPai pai where cat.dataAtualizacao>=:dataBase and t.tabelaPrecoBase = :tabBase order by pai.codigo, cat.identificador");
        query.setEntity("tabBase", (Object)tabBase);
        query.setDate("dataBase", lastSinc);
        query.setFirstResult(firstRes);
        query.setMaxResults(maxRes);
        return query.list();
    }

    public List<DTOCategoriaProdutoArvore> getDadosCategoriaAtivas() {
        AuxCriteriaBuilder builder = this.queryBuilder();
        Join jPai = builder.joinLeft("categoriaPai");
        builder.select(AuxCriteriaBuilder.pair("identificador", "F_IDENTIFICADOR"), AuxCriteriaBuilder.pair("codigo", "F_CODIGO"), AuxCriteriaBuilder.pair("descricao", "F_DESCRICAO"), AuxCriteriaBuilder.pair((From)jPai, "identificador", "F_CATEGORIA_PAI"));
        builder.equal("ativo", (short)1);
        builder.orderAsc((From)jPai, "identificador");
        List<Map<String, Object>> ret = builder.getResultMap();
        LinkedList<DTOCategoriaProdutoArvore> aux = new LinkedList<DTOCategoriaProdutoArvore>();
        for (Map<String, Object> map : ret) {
            Long id = (Long)map.get("F_IDENTIFICADOR");
            Long idPai = (Long)map.get("F_CATEGORIA_PAI");
            String descricao = (String)map.get("F_DESCRICAO");
            String codigo = (String)map.get("F_CODIGO");
            DTOCategoriaProdutoArvore dto = new DTOCategoriaProdutoArvore();
            dto.setCategoriaPaiIdentificador(idPai);
            dto.setCodigo(codigo);
            dto.setDescricao(descricao);
            dto.setIdentificador(id);
            aux.add(dto);
        }
        return aux;
    }
}

