/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.dao.impl;

import com.touchcomp.basementor.constants.enums.centroestoque.EnumConstCentroEstTipoPropTerc;
import com.touchcomp.basementor.constants.enums.statusobjeto.EnumConstStatusObjeto;
import com.touchcomp.basementor.model.vo.CelulaProdCentroEstoque;
import com.touchcomp.basementor.model.vo.CelulaProdutiva;
import com.touchcomp.basementor.model.vo.CelulaProdutivaEquipamento;
import com.touchcomp.basementor.model.vo.CentroEstoque;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementorservice.dao.DaoGenericEntityImpl;
import com.touchcomp.basementorservice.dao.builders.AuxCriteriaBuilder;
import com.touchcomp.basementortools.tools.methods.TMethods;
import java.util.Date;
import java.util.List;
import java.util.Map;
import javax.persistence.criteria.From;
import javax.persistence.criteria.Join;
import org.hibernate.Query;
import org.springframework.stereotype.Repository;

@Repository
public class DaoCelulaProdutivaImpl
extends DaoGenericEntityImpl<CelulaProdutiva, Long> {
    public List<Map<String, Object>> getValorHoraCelulasProd() {
        org.hibernate.query.Query q = this.query("select a.identificador as ID_CELULA_PRODUTIVA,  a.valorCustoHora as VALOR_HORA from CelulaProdutiva a");
        return this.toHashList((Query)q);
    }

    public Double getValorCustoHoraAnalise(CelulaProdutiva celulaProdutiva, Date data) {
        org.hibernate.query.Query q = this.query("select a.custoHoraInicial from AnaliseCustoCelProd a inner join a.analiseCustoProd ap where :data between ap.dataInicial and ap.dataFinal and a.celulaProdutiva = :celula");
        q.setEntity("celula", (Object)celulaProdutiva);
        q.setDate("data", data);
        return (Double)q.uniqueResult();
    }

    public List<CelulaProdutiva> getCelulasAtivas(Empresa emp, Short filtrarCelula, List<Long> idCelulas) {
        AuxCriteriaBuilder aux = this.queryBuilder();
        aux.equal("empresa", emp);
        if (TMethods.isAffirmative((Number)filtrarCelula)) {
            aux.inNumber("identificador", idCelulas);
        }
        return aux.getResultEnt();
    }

    public CentroEstoque getCentroEstoqueComProd(CelulaProdutiva cel, Empresa empresa) {
        AuxCriteriaBuilder aux = this.queryBuilder(CelulaProdCentroEstoque.class);
        Join jCentroEstoque = aux.join("centroEstoque");
        aux.equal("celulaProdutiva", cel);
        aux.equal("utilizarCom", (short)1);
        aux.equal((From)jCentroEstoque, "empresa", empresa);
        aux.equal((From)jCentroEstoque, "tipoEstProprioTerceiros", EnumConstCentroEstTipoPropTerc.TIPO_CENTRO_ESTOQUE_PROPRIO.getValue());
        CelulaProdCentroEstoque found = (CelulaProdCentroEstoque)aux.getUniqueResult();
        return found != null ? found.getCentroEstoque() : null;
    }

    public List getCentroEstoqueComProd(Long idCelulaProdutiva, Empresa empresa) {
        AuxCriteriaBuilder aux = this.queryBuilder(CelulaProdCentroEstoque.class);
        Join jCentroEstoque = aux.join("centroEstoque");
        Join jCelulaProdutiva = aux.join("celulaProdutiva");
        aux.equal((From)jCelulaProdutiva, "identificador", idCelulaProdutiva);
        aux.equal("utilizarCom", (short)1);
        aux.equal((From)jCentroEstoque, "empresa", empresa);
        aux.equal((From)jCentroEstoque, "tipoEstProprioTerceiros", EnumConstCentroEstTipoPropTerc.TIPO_CENTRO_ESTOQUE_PROPRIO.getValue());
        return aux.getResultEnt();
    }

    public List getCentrosEstoqueRequisicao(Long idCelulaProdutiva, Empresa empresa) {
        AuxCriteriaBuilder aux = this.queryBuilder(CelulaProdCentroEstoque.class);
        Join jCentroEstoque = aux.join("centroEstoque");
        Join jCelulaProdutiva = aux.join("celulaProdutiva");
        aux.equal((From)jCelulaProdutiva, "identificador", idCelulaProdutiva);
        aux.equal("utilizarReq", (short)1);
        aux.equal((From)jCentroEstoque, "empresa", empresa);
        aux.equal((From)jCentroEstoque, "tipoEstProprioTerceiros", EnumConstCentroEstTipoPropTerc.TIPO_CENTRO_ESTOQUE_PROPRIO.getValue());
        return aux.getResultEnt();
    }

    public List getCentrosEstoqueComProdFaseProdutiva(Long idFaseProdutiva, Empresa empresa) {
        String query = "select cc from CelulaProdCentroEstoque cc inner join cc.centroEstoque c inner join FaseProdutiva f on(f.celulaProdutiva=cc.celulaProdutiva) where c.empresa=:empresa and c.tipoEstProprioTerceiros=:proprio and cc.utilizarCom=:sim and f.identificador=:idFase ";
        org.hibernate.query.Query qu = this.query(query);
        qu.setEntity("empresa", (Object)empresa);
        qu.setShort("proprio", EnumConstCentroEstTipoPropTerc.TIPO_CENTRO_ESTOQUE_PROPRIO.getValue().shortValue());
        qu.setShort("sim", (short)1);
        qu.setLong("idFase", idFaseProdutiva.longValue());
        return qu.getResultList();
    }

    public List getCentrosEstoqueRequisicaoFaseProdutiva(Long idFaseProdutiva, Empresa empresa) {
        String query = "select cc from CelulaProdCentroEstoque cc inner join cc.centroEstoque c inner join FaseProdutiva f on(f.celulaProdutiva=cc.celulaProdutiva) where c.empresa=:empresa and c.tipoEstProprioTerceiros=:proprio and cc.utilizarReq=:sim and f.identificador=:idFase ";
        org.hibernate.query.Query qu = this.query(query);
        qu.setEntity("empresa", (Object)empresa);
        qu.setShort("proprio", EnumConstCentroEstTipoPropTerc.TIPO_CENTRO_ESTOQUE_PROPRIO.getValue().shortValue());
        qu.setShort("sim", (short)1);
        qu.setLong("idFase", idFaseProdutiva.longValue());
        return qu.getResultList();
    }

    public List<CelulaProdutivaEquipamento> getEquipamentos(Short filtrarCelula, List<Long> idCelulas, Short filtrarEquipamentos, List<Long> idEquipamentos, Short filtrarCentroCusto, List<Long> idCentrosCusto, Short filtrarEmpresaProprietarias, List<Long> idEmpresasProprietarias, Short filtrarFabricantes, List<Long> idFabricantes, Short filtrarFornecedores, List<Long> idFornecedores, Short filtrarTipoEquipamento, List<Long> idTipoEquipamentos) {
        AuxCriteriaBuilder aux = this.queryBuilder(CelulaProdutivaEquipamento.class);
        Join jCelula = aux.join("celulaProdutiva");
        Join jEquip = aux.join("equipamento");
        Join jEquipColIOTEquipFab = aux.joinLeft((From)jEquip, "fabricante");
        Join jEquipColIOTEquipFor = aux.joinLeft((From)jEquip, "fornecedor");
        Join jEquipColIOTEquipEmpProp = aux.joinLeft((From)jEquip, "empresaProprietaria");
        Join jEquipColIOTTipoEquip = aux.joinLeft((From)jEquip, "tipoEquipamento");
        Join jEquipColIOTTipoCentCusto = aux.joinLeft((From)jEquip, "centroCusto");
        if (TMethods.isAffirmative((Number)filtrarCentroCusto)) {
            aux.inNumber((From)jEquipColIOTTipoCentCusto, "identificador", idCentrosCusto);
        }
        if (TMethods.isAffirmative((Number)filtrarCelula)) {
            aux.inNumber((From)jCelula, "identificador", idCelulas);
        }
        if (TMethods.isAffirmative((Number)filtrarEmpresaProprietarias)) {
            aux.inNumber((From)jEquipColIOTEquipEmpProp, "identificador", idEmpresasProprietarias);
        }
        if (TMethods.isAffirmative((Number)filtrarFabricantes)) {
            aux.inNumber((From)jEquipColIOTEquipFab, "identificador", idFabricantes);
        }
        if (TMethods.isAffirmative((Number)filtrarFornecedores)) {
            aux.inNumber((From)jEquipColIOTEquipFor, "identificador", idFornecedores);
        }
        if (TMethods.isAffirmative((Number)filtrarTipoEquipamento)) {
            aux.inNumber((From)jEquipColIOTTipoEquip, "identificador", idTipoEquipamentos);
        }
        if (TMethods.isAffirmative((Number)filtrarEquipamentos)) {
            aux.inNumber("identificador", idEquipamentos);
        }
        aux.equal("ativo", (short)1);
        aux.equal((From)jEquip, "ativo", (short)1);
        return aux.getResultEnt();
    }

    public List<CelulaProdutiva> getCelulasProdutivasEmpresa(Empresa empresa) {
        return this.toList(this.restrictions(this.eq("empresa", empresa), this.eq("ativo", EnumConstStatusObjeto.ATIVO.getValue())));
    }
}

