/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.dao.impl;

import com.touchcomp.basementor.model.vo.CentroCusto;
import com.touchcomp.basementor.model.vo.Colaborador;
import com.touchcomp.basementorclientwebservices.ponto.model.departamento.DTOPontoDepartamento;
import com.touchcomp.basementorservice.dao.DaoGenericEntityImpl;
import com.touchcomp.basementortools.tools.methods.TMethods;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import javax.persistence.criteria.Subquery;
import org.hibernate.Query;
import org.springframework.stereotype.Repository;

@Repository
public class DaoCentroCustoImpl
extends DaoGenericEntityImpl<CentroCusto, Long> {
    public CentroCusto findByCodigo(String codigo) {
        return (CentroCusto)this.toUnique(this.restrictions(this.criteria(), this.eq("codigo", codigo)));
    }

    public List<CentroCusto> findCentroCustoColaborador() {
        String query = " from CentroCusto c  where c in (select colaborador.centroCusto from Colaborador colaborador )";
        org.hibernate.query.Query q = this.query(query);
        List<CentroCusto> list = this.toList((Query)q);
        return list;
    }

    public List<DTOPontoDepartamento> findDepartamentosPonto(Date dataBaseSincSistemaPonto, Date dataUltimaSincronizacao) {
        CriteriaBuilder builder = this.criteriaBuilder(CentroCusto.class);
        CriteriaQuery crit = builder.createQuery();
        LinkedList<Object> exps = new LinkedList<Object>();
        Root root = crit.from(CentroCusto.class);
        Join jCentoCustoEmpresa = root.join("centroCustoEmpresa");
        Join jEmpresa = jCentoCustoEmpresa.join("empresa");
        Join jPessoa = jEmpresa.join("pessoa");
        Join jComplemento = jPessoa.join("complemento");
        Join jEndereco = jPessoa.join("endereco");
        Join jCidade = jEndereco.join("cidade");
        Join jUf = jCidade.join("uf");
        Subquery subquery = crit.subquery(Colaborador.class);
        Root subRoot = subquery.from(Colaborador.class);
        Join jCentroCusto = subRoot.join("centroCusto", JoinType.INNER);
        subquery.where((Expression)builder.equal((Expression)jCentroCusto.get("identificador"), (Expression)root.get("identificador")));
        exps.add(builder.in((Expression)root.get("identificador")).value((Expression)subquery.select((Expression)jCentroCusto.get("identificador"))));
        exps.add(builder.and((Expression)builder.isNotNull((Expression)root.get("dataCadastro")), (Expression)builder.greaterThan((Expression)root.get("dataCadastro"), (Comparable)dataBaseSincSistemaPonto)));
        if (TMethods.isNotNull((Object)dataUltimaSincronizacao).booleanValue()) {
            exps.add(builder.greaterThan((Expression)root.get("dataAtualizacao"), (Comparable)dataUltimaSincronizacao));
        }
        crit.multiselect(new Selection[]{root.get("codigo"), root.get("nome"), root.get("identificador"), jEmpresa.get("identificador"), jComplemento.get("emailPrincipal"), jComplemento.get("cel1"), jEndereco.get("cep"), jEndereco.get("complemento"), jEndereco.get("bairro"), jCidade.get("descricao"), jUf.get("sigla")});
        crit.where(exps.toArray(new Predicate[0]));
        List data = this.getEntityManager().createQuery(crit).getResultList();
        LinkedList<DTOPontoDepartamento> result = new LinkedList<DTOPontoDepartamento>();
        for (Object[] obj : data) {
            DTOPontoDepartamento dto = new DTOPontoDepartamento();
            dto.setConta((String)obj[0]);
            dto.setDescricao((String)obj[1]);
            dto.setExternalId(String.valueOf(obj[2]));
            dto.setIdEmpresa((Long)obj[3]);
            dto.setEmail((String)obj[4]);
            dto.setCelular((String)obj[5]);
            dto.setCep((String)obj[6]);
            dto.setComplemento((String)obj[7]);
            dto.setBairro((String)obj[8]);
            dto.setCidade((String)obj[9]);
            dto.setUf((String)obj[10]);
            result.add(dto);
        }
        return result;
    }
}

