/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.dao.impl;

import com.touchcomp.basementor.constants.enums.centroestoque.EnumConstCentroEstPadraoOutros;
import com.touchcomp.basementor.model.vo.CentroEstoque;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.Produto;
import com.touchcomp.basementorservice.dao.DaoGenericEntityImpl;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.hibernate.query.Query;
import org.springframework.stereotype.Repository;

@Repository
public class DaoCentroEstoqueImpl
extends DaoGenericEntityImpl<CentroEstoque, Long> {
    public CentroEstoque findCentroEstoquePadraoEmp(Empresa empresa) {
        Criteria crit = this.criteria();
        crit.add((Criterion)Restrictions.eq((String)"empresa", (Object)empresa));
        crit.add((Criterion)Restrictions.eq((String)"tipoCentroEstoque", (Object)EnumConstCentroEstPadraoOutros.TIPO_CENTRO_ESTOQUE_PADRAO.getValue()));
        return (CentroEstoque)this.toUnique(crit);
    }

    public CentroEstoque findCentroEstoquePorLocalizacaoProdutos(Empresa empresa, Produto produto) {
        Query q = this.query("select c.prodLocCentroEstoque.centroEstoque FROM ProdLocCentroEstoqueItem c WHERE c.gradeCor.produtoGrade.produto = :produto  and c.prodLocCentroEstoque.centroEstoque.empresa = :empresa");
        q.setEntity("produto", (Object)produto);
        q.setEntity("empresa", (Object)empresa);
        q.setMaxResults(1);
        return (CentroEstoque)q.uniqueResult();
    }

    public CentroEstoque getPorEmpresaParceiro(Empresa empresa, Pessoa parceiro) {
        Criteria crit = this.criteria();
        crit.add((Criterion)Restrictions.eq((String)"empresa", (Object)empresa));
        crit.add((Criterion)Restrictions.eq((String)"parceiro", (Object)parceiro));
        return (CentroEstoque)this.toUnique(crit);
    }

    public CentroEstoque getByCodigoSincronizacao(String codigoSincronizacao) {
        return (CentroEstoque)this.toUnique(this.restrictions(this.eq("codigoSincronizacao", codigoSincronizacao)));
    }

    public CentroEstoque getCentroEstoqueNome(String centroEstoque) {
        Criteria crit = this.criteria();
        crit.add((Criterion)Restrictions.eq((String)"descricao", (Object)centroEstoque));
        return (CentroEstoque)this.toUnique(crit);
    }

    public List<CentroEstoque> getCentrosEstoqueEmpresa(Empresa logedEmpresa) {
        return this.toList(this.restrictions(this.eq("empresa", logedEmpresa)));
    }
}

