/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.dao.impl;

import com.touchcomp.basementor.constants.enums.naturezaoperacao.EnumConstNatOpEntSaidaFaturamento;
import com.touchcomp.basementor.constants.enums.nfe.EnumConstNFeIndicadorPresConsumidor;
import com.touchcomp.basementor.model.vo.Cfop;
import com.touchcomp.basementor.model.vo.ModeloFiscal;
import com.touchcomp.basementor.model.vo.UnidadeFederativa;
import com.touchcomp.basementorservice.dao.DaoGenericEntityImpl;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.util.ArrayList;
import java.util.List;
import org.hibernate.query.Query;
import org.springframework.stereotype.Repository;

@Repository
public class DaoCfopImpl
extends DaoGenericEntityImpl<Cfop, Long> {
    public Cfop findCfopEntrada(UnidadeFederativa ufEmpresa, UnidadeFederativa ufDestinoOrigem, ModeloFiscal mod) throws Exception {
        Object codigo = mod.getTipoCfop() != null && mod.getTipoCfop() == 2 ? "3." : (mod.getTipoCfop() != null && mod.getTipoCfop() == 1 ? "7." : (ufEmpresa.equals((Object)ufDestinoOrigem) ? "1." : (!ufEmpresa.equals((Object)ufDestinoOrigem) ? "2." : "3.")));
        Cfop cfop = this.getCfopPorCodigo((String)(codigo = (String)codigo + mod.getCfop()));
        if (cfop == null) {
            throw new Exception("Nao foi encontrado nenhuma CFOP com o codigo " + (String)codigo);
        }
        return cfop;
    }

    public Cfop findCfopSaida(UnidadeFederativa ufEmpresa, UnidadeFederativa uf2, ModeloFiscal mod, EnumConstNFeIndicadorPresConsumidor indPresenca) throws Exception {
        Object codigo = "";
        codigo = mod.getTipoCfop() != null && mod.getTipoCfop() == 2 ? "3." : (mod.getTipoCfop() != null && mod.getTipoCfop() == 1 ? "7." : (ufEmpresa.equals((Object)uf2) || indPresenca != null && ToolMethods.isEquals((Object)indPresenca, (Object)EnumConstNFeIndicadorPresConsumidor.OPERACAO_PRESENCIAL) ? "5." : (!ufEmpresa.equals((Object)uf2) ? "6." : "7.")));
        Cfop cfop = this.getCfopPorCodigo((String)(codigo = (String)codigo + mod.getCfop()));
        if (cfop == null) {
            throw new Exception("Nao foi encontrado nenhuma CFOP com o codigo " + (String)codigo);
        }
        return cfop;
    }

    private Cfop getCfopPorCodigo(String codigo) {
        String query = " from Cfop n  where n.codigo = :codigo ";
        Query q = this.query(query);
        q.setString("codigo", codigo);
        q.setMaxResults(1);
        return (Cfop)q.uniqueResult();
    }

    public Cfop findCfopByCodigo(String codigo) {
        String query = " from Cfop n  where n.codigo = :codigo ";
        Query q = this.query(query);
        q.setString("codigo", codigo);
        q.setMaxResults(1);
        return (Cfop)q.uniqueResult();
    }

    public List<Cfop> findCfopByEntradaSaida(EnumConstNatOpEntSaidaFaturamento value) {
        Object query = " from Cfop c ";
        if (value == null) {
            return new ArrayList<Cfop>();
        }
        switch (value) {
            case ENT_SAI_ENTRADA: 
            case ENT_SAI_FATURAMENTO_ENTRADA: {
                query = (String)query + " where (c.codigo LIKE '1%' OR c.codigo LIKE '2%' or c.codigo LIKE '3%') and c.codigo NOT LIKE '%00'";
                break;
            }
            case ENT_SAI_FATURAMENTO_SAIDA: {
                query = (String)query + " where (c.codigo LIKE '5%' OR c.codigo LIKE '6%' or c.codigo LIKE '7%') and c.codigo NOT LIKE '%00'";
                break;
            }
            default: {
                return new ArrayList<Cfop>();
            }
        }
        Query q = this.query((String)query);
        return q.list();
    }
}

