/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.dao.impl;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.borderochequesterceiros.EnumConstChequeTerceiros;
import com.touchcomp.basementor.model.vo.BorderoChequeTerceirosMovBancario;
import com.touchcomp.basementor.model.vo.CarteiraCobranca;
import com.touchcomp.basementor.model.vo.ChequeTerceiros;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.GrupoEmpresa;
import com.touchcomp.basementorservice.dao.DaoGenericEntityImpl;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.hibernate.Criteria;
import org.hibernate.query.Query;
import org.springframework.stereotype.Repository;

@Repository
public class DaoChequeTerceirosImpl
extends DaoGenericEntityImpl<ChequeTerceiros, Long> {
    public Double valorChequesNaoCompensados(Long idPessoa) {
        Query q = this.query("SELECT  sum(c.valor) FROM ChequeTerceiros c INNER JOIN c.pessoa p left JOIN c.grupoDeBaixaFormasPag g left JOIN c.compensacaoCheque cc left JOIN cc.tipoCompensacaoChTerceiros tc left JOIN c.baixaChequeTerceiros dv WHERE p.identificador = :pessoa AND cc is null AND g is null and ( tc is null or tc.codigo != :tipoCompensacao)");
        q.setLong("pessoa", idPessoa.longValue());
        q.setShort("tipoCompensacao", (short)2);
        Double ret = (Double)q.uniqueResult();
        ret = ret == null ? 0.0 : ret;
        return ret;
    }

    public Double valorChequesDevolvidos(Long idPessoa) {
        Query q = this.query("SELECT  sum(c.valor) FROM ChequeTerceiros c inner JOIN c.compensacaoCheque cc inner JOIN cc.tipoCompensacaoChTerceiros t inner JOIN c.pessoa p left JOIN c.baixaChequeTerceiros dv WHERE p.identificador = :pessoa AND (t.codigo = :devolvido) and dv is null and cc.titulo is null");
        q.setLong("pessoa", idPessoa.longValue());
        q.setShort("devolvido", (short)2);
        Double ret = (Double)q.uniqueResult();
        ret = ret == null ? 0.0 : ret;
        return ret;
    }

    public Double valorChequesNaoCompensadosGrupoPessoa(Long idGrupoPessoa) {
        Query q = this.query("SELECT  sum(c.valor) FROM ChequeTerceiros c INNER JOIN c.pessoa p inner join p.grupoPessoas g left JOIN c.grupoDeBaixaFormasPag g left JOIN c.compensacaoCheque cc left JOIN cc.tipoCompensacaoChTerceiros tc left JOIN c.baixaChequeTerceiros dv WHERE g.identificador = :pessoa AND cc is null AND g is null and tc.codigo != :tipoCompensacao");
        q.setLong("pessoa", idGrupoPessoa.longValue());
        q.setShort("tipoCompensacao", (short)2);
        Double ret = (Double)q.uniqueResult();
        ret = ret == null ? 0.0 : ret;
        return ret;
    }

    public Double valorChequesDevolvidosGrupoPessoas(Long idGrupoPessoa) {
        Query q = this.query("SELECT  sum(c.valor) FROM ChequeTerceiros c inner JOIN c.compensacaoCheque cc inner JOIN cc.tipoCompensacaoChTerceiros t inner JOIN c.pessoa p inner JOIN p.grupoPessoas g left JOIN c.baixaChequeTerceiros dv WHERE g.identificador = :pessoa AND (t.codigo = :devolvido) and dv is null and cc.titulo is null");
        q.setLong("pessoa", idGrupoPessoa.longValue());
        q.setShort("devolvido", (short)2);
        Double ret = (Double)q.uniqueResult();
        ret = ret == null ? 0.0 : ret;
        return ret;
    }

    public List<ChequeTerceiros> getChequesTerceirosByDataVencimento(Date dataVencInicial, Date dataVencFinal, GrupoEmpresa grupoEmpresa, Empresa empresa, Short visualizarDadosOutrasEmp) {
        CriteriaBuilder builder = this.criteriaBuilder(ChequeTerceiros.class);
        CriteriaQuery crit = builder.createQuery();
        LinkedList<Predicate> exps = new LinkedList<Predicate>();
        Root fromChequeTerceiros = crit.from(ChequeTerceiros.class);
        Join jEmpresa = fromChequeTerceiros.join("empresa", JoinType.INNER);
        Join jEmpresaDados = jEmpresa.join("empresaDados", JoinType.INNER);
        Join jGrupoDeBaixaFormasPag = fromChequeTerceiros.join("grupoDeBaixaFormasPag", JoinType.LEFT);
        Join jCompensacaoCheque = fromChequeTerceiros.join("compensacaoCheque", JoinType.LEFT);
        Join jTipoCompensacaoChTerceiros = jCompensacaoCheque.join("tipoCompensacaoChTerceiros", JoinType.LEFT);
        Join jBaixaChequeTerceiros = fromChequeTerceiros.join("baixaChequeTerceiros", JoinType.LEFT);
        crit.select((Selection)fromChequeTerceiros);
        if (!ToolMethods.isAffirmative((Number)visualizarDadosOutrasEmp)) {
            exps.add(builder.equal((Expression)jEmpresa.get("identificador"), (Object)empresa.getIdentificador()));
        }
        exps.add(builder.equal((Expression)jEmpresaDados.get("grupoEmpresa"), (Object)grupoEmpresa));
        exps.add(builder.between((Expression)fromChequeTerceiros.get("dataVencimento"), (Comparable)dataVencInicial, (Comparable)dataVencFinal));
        exps.add(builder.gt((Expression)fromChequeTerceiros.get("valorSaldo"), (Number)0.0));
        exps.add(builder.isNull((Expression)jCompensacaoCheque));
        exps.add(builder.isNull((Expression)jGrupoDeBaixaFormasPag));
        exps.add(builder.isNull((Expression)jBaixaChequeTerceiros));
        crit.where(exps.toArray(new Predicate[0]));
        return this.getEntityManager().createQuery(crit).getResultList();
    }

    public ChequeTerceiros getUltChequeTerceirosSugestao(String banco, String agencia, String conta) {
        return (ChequeTerceiros)this.toUnique(this.restrictions(this.eq("banco", banco), this.eq("agencia", agencia), this.like("contaCorrente", "%" + conta)));
    }

    public List<ChequeTerceiros> verificarDadosCheque(ChequeTerceiros cheque) {
        return this.toList(this.restrictions(this.eq("numero", cheque.getNumero()), this.eq("agencia", cheque.getAgencia()), this.eq("contaCorrente", cheque.getContaCorrente()), this.eq("banco", cheque.getBanco())));
    }

    public ChequeTerceiros getByIdentificadorAndEmpresa(Long id, Empresa empresa) {
        Criteria crit = this.criteria();
        if (empresa != null) {
            crit.createAlias("empresa", "e");
        }
        crit.add(this.eq("identificador", id));
        if (empresa != null) {
            crit.add(this.eq("e.identificador", empresa.getIdentificador()));
        }
        return (ChequeTerceiros)crit.uniqueResult();
    }

    public ChequeTerceiros getChequeTerceiros(String agencia, String banco, String conta, String numero) {
        return (ChequeTerceiros)this.toUnique(this.restrictions(this.eq("banco", banco), this.eq("agencia", agencia), this.eq("conta", conta), this.eq("numero", numero)));
    }

    public List<ChequeTerceiros> findChequeTerceiros(Date dataEmissaoInicial, Date dataEmissaoFinal, Date dataVencimentoInicial, Date dataVencimentoFinal, CarteiraCobranca carteiraCobranca) {
        Query q = this.query(" SELECT DISTINCT t   FROM ChequeTerceiros t   LEFT JOIN t.compensacaoCheque c   LEFT JOIN c.tipoCompensacaoChTerceiros tc   WHERE       (t.dataEntrada  >= :dataEmissaoInicial and t.dataEntrada <= :dataEmissaoFinal)  AND (t.dataVencimento >= :dataVencimentoInicial and t.dataVencimento <= :dataVencimentoFinal)  AND ((c is null or tc.codigo <> :tipo ) and t.valorSaldo > 0)  AND t.carteiraCobranca = :carteira");
        q.setDate("dataEmissaoInicial", dataEmissaoInicial);
        q.setDate("dataEmissaoFinal", dataEmissaoFinal);
        q.setDate("dataVencimentoInicial", dataVencimentoInicial);
        q.setDate("dataVencimentoFinal", dataVencimentoFinal);
        q.setShort("tipo", EnumConstChequeTerceiros.COMPENSADO.getValue().shortValue());
        q.setEntity("carteira", (Object)carteiraCobranca);
        return q.list();
    }

    public ChequeTerceiros getChequeTerceirosNaoCompensados(Long cheque, Empresa empresa, Short filtrarEmpresa) {
        CriteriaBuilder builder = this.criteriaBuilder(ChequeTerceiros.class);
        CriteriaQuery crit = builder.createQuery();
        LinkedList<Predicate> exps = new LinkedList<Predicate>();
        Root fromChequeTerceiro = crit.from(ChequeTerceiros.class);
        Join jCompensacaoChequeTerceiros = fromChequeTerceiro.join("compensacaoCheque", JoinType.LEFT);
        if (ToolMethods.isEquals((Object)filtrarEmpresa, (Object)EnumConstantsMentorSimNao.SIM.getValue())) {
            Join jEmpresa = fromChequeTerceiro.join("empresa", JoinType.INNER);
            exps.add(builder.equal((Expression)jEmpresa.get("identificador"), (Object)empresa.getIdentificador()));
        }
        crit.select((Selection)fromChequeTerceiro);
        exps.add(builder.isNull((Expression)jCompensacaoChequeTerceiros));
        exps.add(builder.equal((Expression)fromChequeTerceiro.get("identificador"), (Object)cheque));
        crit.where(exps.toArray(new Predicate[0]));
        return (ChequeTerceiros)this.getEntityManager().createQuery(crit).getSingleResult();
    }

    public List<ChequeTerceiros> getChequeTerceirosPeloBorderoNaoCompensados(Long bordero, Empresa empresa, Short filtrarEmpresa) {
        CriteriaBuilder builder = this.criteriaBuilder(ChequeTerceiros.class);
        CriteriaQuery crit = builder.createQuery();
        LinkedList<Predicate> exps = new LinkedList<Predicate>();
        Root fromChequeTerceiro = crit.from(ChequeTerceiros.class);
        Join jCompensacaoChequeTerceiros = fromChequeTerceiro.join("compensacaoChequeTerceiros", JoinType.LEFT);
        if (ToolMethods.isEquals((Object)filtrarEmpresa, (Object)EnumConstantsMentorSimNao.SIM.getValue())) {
            Join jEmpresa = fromChequeTerceiro.join("empresa", JoinType.INNER);
            exps.add(builder.equal((Expression)jEmpresa.get("identificador"), (Object)empresa.getIdentificador()));
        }
        crit.select((Selection)fromChequeTerceiro);
        Root fromBorderoChequeTerceirosMovBancario = crit.from(BorderoChequeTerceirosMovBancario.class);
        Join jChequeTerceiros = fromBorderoChequeTerceirosMovBancario.join("chequeTerceiros");
        Join jBorderoChequeTerceiros = fromBorderoChequeTerceirosMovBancario.join("borderoChequeTerceiros");
        exps.add(builder.equal((Expression)fromChequeTerceiro.get("identificador"), (Expression)jChequeTerceiros.get("identificador")));
        exps.add(builder.isNull((Expression)jCompensacaoChequeTerceiros));
        exps.add(builder.equal((Expression)jBorderoChequeTerceiros.get("identificador"), (Object)bordero));
        crit.where(exps.toArray(new Predicate[0]));
        return this.getEntityManager().createQuery(crit).getResultList();
    }
}

