/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.dao.impl;

import com.touchcomp.basementor.model.vo.Cidade;
import com.touchcomp.basementorservice.dao.DaoGenericEntityImpl;
import java.util.List;
import org.hibernate.Query;
import org.hibernate.criterion.Order;
import org.springframework.stereotype.Repository;

@Repository
public class DaoCidadeImpl
extends DaoGenericEntityImpl<Cidade, Long> {
    public Cidade getByCodigoIBGE(String ibge) {
        return (Cidade)this.toUnique(this.restrictions(this.eq("codIbge", ibge)));
    }

    public Cidade getByCodigoIBGECompleto(String ibge) {
        return (Cidade)this.toUnique(this.restrictions(this.eq("codIbgeCompleto", ibge)));
    }

    public Cidade getByCep(String cep) {
        return (Cidade)this.toUnique(this.restrictions(this.eq("cep", cep)));
    }

    public Cidade getByNomeAndUF(String nome, String siglaUF) {
        String query = "select distinct c  from Cidade c  where c.descricao = :nome and c.uf.sigla = :uf";
        org.hibernate.query.Query q = this.query(query);
        q.setString("nome", nome);
        q.setString("uf", siglaUF);
        return (Cidade)this.toUnique((Query)q);
    }

    public List<Cidade> getCidadeByUnidadeFederativa(Long idUnidadeFederativa) {
        return this.toList(this.restrictions(this.eq("uf.identificador", idUnidadeFederativa)).addOrder(Order.asc((String)"descricao")));
    }
}

