/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.dao.impl;

import com.touchcomp.basementor.constants.enums.documentofiscal.EnumConstModeloDocumentoFiscal;
import com.touchcomp.basementor.constants.enums.paramtribcbsibs.EnumParamTribCbsIbsTipoDoc;
import com.touchcomp.basementor.model.vo.ClassificacaoTributariaCbsIbs;
import com.touchcomp.basementorservice.dao.DaoGenericEntityImpl;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import org.hibernate.query.Query;
import org.springframework.stereotype.Repository;

@Repository
public class DaoClassificacaoTributariaCbsIbsImpl
extends DaoGenericEntityImpl<ClassificacaoTributariaCbsIbs, Long> {
    public List<ClassificacaoTributariaCbsIbs> getClassificacoesAtivas(Long idIncidenciaCbsIbs, EnumParamTribCbsIbsTipoDoc tipoDoc) {
        String str = "select distinct c\nfrom ClassificacaoTributariaCbsIbs c\ninner join c.modelosDocFiscais m\ninner join m.modeloDocFiscal mm\nwhere ((c.dataFinal is null and c.dataInicial<=:dataLimite)\nor (c.dataInicial <= :dataLimite and c.dataFinal >= :dataLimite))\nand c.incidenciaCbsIbs.identificador=:idIncidenciaCbsIbs\nand mm.codigo in(:docs)\norder by c.codigo desc\n";
        Query q = this.query(str);
        q.setParameter("idIncidenciaCbsIbs", (Object)idIncidenciaCbsIbs);
        q.setParameter("dataLimite", (Object)new Date());
        LinkedList<String> docs = new LinkedList<String>();
        if (tipoDoc != null) {
            switch (tipoDoc) {
                case CTE: {
                    docs.add(EnumConstModeloDocumentoFiscal.CTE.getEnumId());
                    break;
                }
                case NOTAS_FISCAIS_SERVICO: {
                    docs.add(EnumConstModeloDocumentoFiscal.NFSE.getEnumId());
                    break;
                }
                default: {
                    docs.add(EnumConstModeloDocumentoFiscal.NFE.getEnumId());
                    docs.add(EnumConstModeloDocumentoFiscal.NFCE.getEnumId());
                    break;
                }
            }
        } else {
            docs.add(EnumConstModeloDocumentoFiscal.NFE.getEnumId());
            docs.add(EnumConstModeloDocumentoFiscal.NFCE.getEnumId());
            docs.add(EnumConstModeloDocumentoFiscal.CTE.getEnumId());
            docs.add(EnumConstModeloDocumentoFiscal.NFSE.getEnumId());
        }
        q.setParameter("docs", docs);
        return q.getResultList();
    }
}

