/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.dao.impl;

import com.touchcomp.basementor.constants.enums.clientetouchcomp.EnumStatTreinamentoUsuario;
import com.touchcomp.basementor.model.vo.ClienteContSistemas;
import com.touchcomp.basementor.model.vo.LogConsultaAtendimentos;
import com.touchcomp.basementor.model.vo.Nodo;
import com.touchcomp.basementor.model.vo.ServidorCliente;
import com.touchcomp.basementor.model.vo.UsuarioBasico;
import com.touchcomp.basementor.model.vo.UsuarioClienteContSistemas;
import com.touchcomp.basementorservice.dao.DaoGenericEntityImpl;
import com.touchcomp.basementorservice.dao.builders.AuxCriteriaBuilder;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.touchvomodel.res.DTOEntidadeCodigoRes;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import javax.persistence.criteria.From;
import javax.persistence.criteria.Join;
import org.hibernate.query.Query;
import org.springframework.stereotype.Repository;

@Repository
public class DaoClienteContSistemasImpl
extends DaoGenericEntityImpl<ClienteContSistemas, Long> {
    public ClienteContSistemas findCliente(String cnpjEmp) {
        String query = "select c from ClienteContSistemas c inner join c.tomadorPrestadorRps t inner join t.pessoa p inner join p.complemento cc where cc.cnpj = :cnpjEmp";
        Query q = this.query(query);
        q.setString("cnpjEmp", cnpjEmp);
        q.setMaxResults(1);
        return (ClienteContSistemas)q.uniqueResult();
    }

    public ClienteContSistemas findClienteEmpCNPJFiliais(String cnpjEmp) {
        String query = "select c from ClienteContSistemas c inner join c.clienteContSistCnpj t inner join t.pessoa p inner join p.complemento cc where cc.cnpj = :cnpjEmp";
        Query q = this.query(query);
        q.setString("cnpjEmp", cnpjEmp);
        q.setMaxResults(1);
        return (ClienteContSistemas)q.uniqueResult();
    }

    public ServidorCliente getServidorCliente(String cnpj, Integer tipoAplicacao) {
        String query = "select c.servidorCliente from ClienteContSistemas c inner join c.servidorCliente s inner join c.tomadorPrestadorRps t inner join t.pessoa p inner join p.complemento cc inner join c.clienteContSistCnpj tc inner join tc.pessoa pc inner join pc.complemento pcc where (cc.cnpj = :cnpjEmp or pcc.cnpj=:cnpjEmp) and s.tipoAplicacao=:tipoAplicacao";
        Query q = this.query(query);
        q.setString("cnpjEmp", cnpj);
        q.setInteger("tipoAplicacao", tipoAplicacao.intValue());
        q.setMaxResults(1);
        return (ServidorCliente)q.uniqueResult();
    }

    public ServidorCliente getServidorCliente(String cnpj, String macAddress, Integer tipoAplicacao) {
        String query = "select c.servidorCliente from ClienteContSistemas c inner join c.servidorCliente s inner join s.dispositivos ds inner join c.tomadorPrestadorRps t inner join t.pessoa p inner join p.complemento cc inner join c.clienteContSistCnpj tc inner join tc.pessoa pc inner join pc.complemento pcc where (cc.cnpj = :cnpjEmp or pcc.cnpj=:cnpjEmp) and s.tipoAplicacao=:tipoAplicacao and ds.macsAddress like :address";
        Query q = this.query(query);
        q.setString("cnpjEmp", cnpj);
        q.setString("cnpjEmp", "%" + macAddress + "%");
        q.setInteger("tipoAplicacao", tipoAplicacao.intValue());
        q.setMaxResults(1);
        return (ServidorCliente)q.uniqueResult();
    }

    public void resetarLogConsulta(Date data, UsuarioClienteContSistemas u) {
        String query = "delete from " + LogConsultaAtendimentos.class.getName() + " l where l.usuarioClienteContSistemas=:usuario and l.dataConsulta >=:data";
        this.query(query).setDate("data", data).setEntity("usuario", (Object)u).executeUpdate();
    }

    public boolean isUsuarioTreinado(UsuarioClienteContSistemas user, Nodo n) {
        Query q = this.query("select count(nm.identificador) from ClienteContSistemas c inner join c.usuariosContSistemas u inner join u.treinamentos t inner join t.modulo m inner join NodoModulo nm on(m.identificador=nm.idModuloSistema) where  nm.nodo=:nodo and u=:user and t.status=:aprovado ");
        q.setEntity("user", (Object)user);
        q.setEntity("nodo", (Object)n);
        q.setShort("aprovado", EnumStatTreinamentoUsuario.TREINADO_APROVADO.getValue());
        Long count = (Long)q.uniqueResult();
        return count != null && count > 0L;
    }

    public List<DTOEntidadeCodigoRes> getPerfisClientesAcessoUsuario(UsuarioBasico loggedUsuarioBasico) {
        AuxCriteriaBuilder aux = this.queryBuilder();
        Join usu = aux.join("usuariosContSistemas");
        Join toma = aux.join("tomadorPrestadorRps");
        Join tomaPess = aux.join((From)toma, "pessoa");
        aux.equal((From)usu, "pessoa", loggedUsuarioBasico.getPessoa());
        aux.equal((From)usu, "ativoNoCliente", (short)1);
        aux.select("identificador", "codigoCliente");
        aux.select((From)tomaPess, "nome", "nomeFantasia");
        List res = aux.getResult();
        LinkedList<DTOEntidadeCodigoRes> ret = new LinkedList<DTOEntidadeCodigoRes>();
        for (Object[] ob : res) {
            DTOEntidadeCodigoRes d = new DTOEntidadeCodigoRes();
            d.setIdentificador((Long)ob[0]);
            d.setCodigo((String)ob[1]);
            ret.add(d);
            String nome = (String)ob[2];
            String nomeFantasia = (String)ob[3];
            d.setDescricao(nome);
            if (!TMethods.isStrWithData((String)nomeFantasia)) continue;
            d.setDescricao(nomeFantasia);
        }
        return ret;
    }

    public ClienteContSistemas getByCodigoCliente(String codigoCliente) {
        AuxCriteriaBuilder aux = this.queryBuilder();
        aux.equal("codigoCliente", codigoCliente);
        return (ClienteContSistemas)aux.getUniqueResult();
    }
}

