/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.dao.impl;

import com.touchcomp.basementor.constants.enums.statusobjeto.EnumConstStatusObjeto;
import com.touchcomp.basementor.model.impl.DadosEstatisticosFaturamento;
import com.touchcomp.basementor.model.impl.TempVOInfoProdCliente;
import com.touchcomp.basementor.model.vo.Cliente;
import com.touchcomp.basementor.model.vo.CondicoesPagamento;
import com.touchcomp.basementor.model.vo.NotaFiscalPropria;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementor.model.vo.PlanoConta;
import com.touchcomp.basementorservice.dao.DaoGenericEntityImpl;
import com.touchcomp.basementorservice.dao.builders.AuxCriteriaBuilder;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.persistence.Query;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.From;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import javax.persistence.criteria.Subquery;
import org.hibernate.Criteria;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.hibernate.transform.AliasToEntityMapResultTransformer;
import org.hibernate.transform.ResultTransformer;
import org.springframework.stereotype.Repository;

@Repository
public class DaoClienteImpl
extends DaoGenericEntityImpl<Cliente, Long> {
    public List<Cliente> get(Pessoa pessoa, Short ativo) {
        return this.toList(this.restrictions(this.eq("pessoa", pessoa), this.eq("ativo", ativo)));
    }

    public PlanoConta getPlanoContaClienteIdPessoa(Long idPessoa) {
        Criteria crit = this.criteria();
        crit.createAlias("pessoa", "p");
        crit.createAlias("p.contasPessoa", "cp");
        crit.setProjection((Projection)Projections.property((String)"cp.planoContaAtivo"));
        crit.add(this.eq("p.identificador", idPessoa));
        return (PlanoConta)crit.uniqueResult();
    }

    public Cliente findClienteByPessoa(Pessoa pessoa) {
        return (Cliente)this.toUnique(this.restrictions(this.criteria(), this.eq("pessoa", pessoa)));
    }

    public List<Cliente> findClienteByPessoa(Pessoa ... pessoa) {
        if (pessoa == null || pessoa.length == 0) {
            return new LinkedList<Cliente>();
        }
        return this.toList(this.restrictions(this.criteria(), this.in("pessoa", pessoa)));
    }

    public List<Cliente> findClienteByPessoa(Long ... idPessoa) {
        if (idPessoa == null || idPessoa.length == 0) {
            return new LinkedList<Cliente>();
        }
        return this.toList(this.restrictions(this.criteria(), this.in("pessoa.identificador", idPessoa)));
    }

    public Cliente findClienteByPessoa(Long idPessoa) {
        String sql = " select c from Cliente c  where c.pessoa.identificador = :idPessoa ";
        org.hibernate.query.Query q = this.query(sql);
        q.setLong("idPessoa", idPessoa.longValue());
        q.setMaxResults(1);
        return (Cliente)q.uniqueResult();
    }

    public Cliente getClienteCpfCpnj(String cnpj) {
        Criteria crit = this.criteria();
        crit.createAlias("pessoa", "p");
        crit.createAlias("p.complemento", "c");
        crit.setMaxResults(1);
        return (Cliente)this.toUnique(this.restrictions(crit, this.eq("c.cnpj", cnpj)));
    }

    public Cliente getClienteCpfCpnjAtivo(String cnpj) {
        Criteria crit = this.criteria();
        crit.createAlias("pessoa", "p");
        crit.createAlias("p.complemento", "c");
        crit.setMaxResults(1);
        return (Cliente)this.toUnique(this.restrictions(crit, this.eq("c.cnpj", cnpj), this.eq("ativo", (short)1)));
    }

    public DadosEstatisticosFaturamento getPrimeiroFaturamentoNf(Cliente cliente) {
        org.hibernate.query.Query q = this.query(" select  nfp.dataEmissaoNota as DATA_EMISSAO, nfp.valoresNfPropria.valorTotal as VALOR_TOTAL_ULTIMA_FATURA,  cast(nfp.numeroNota as long) as NUMERO_NOTA_ULTIMA_FATURA,  nfp.serie as SERIE_NOTA_ULTIMA_FATURA  from NotaFiscalPropria nfp  where  nfp.dataEmissaoNota = (  select min(nfp2.dataEmissaoNota)  from NotaFiscalPropria nfp2  where nfp2.unidadeFatCliente.cliente = :cliente)  and nfp.unidadeFatCliente.cliente = :cliente");
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        q.setEntity("cliente", (Object)cliente);
        q.setMaxResults(1);
        Map m = (Map)q.uniqueResult();
        if (m != null) {
            DadosEstatisticosFaturamento e = new DadosEstatisticosFaturamento();
            e.setData((Date)m.get("DATA_EMISSAO"));
            e.setValor((Double)m.get("VALOR_TOTAL_ULTIMA_FATURA"));
            e.setSerie((String)m.get("SERIE_NOTA_ULTIMA_FATURA"));
            e.setNumero(String.valueOf(m.get("NUMERO_NOTA_ULTIMA_FATURA")));
            return e;
        }
        return null;
    }

    public DadosEstatisticosFaturamento getUltimoFaturamentoNf(Cliente cliente) {
        org.hibernate.query.Query q = this.query(" select  nfp.valoresNfPropria.valorTotal as VALOR_NOTA_MAIOR_FATURA,  cast(nfp.numeroNota as long) as NUMERO_NOTA_MAIOR_FATURA,  nfp.serie as SERIE_NOTA_MAIOR_FATURA,  nfp.dataEmissaoNota as DATA_NOTA_MAIOR_FATURA  from NotaFiscalPropria nfp  where  nfp.dataEntradaSaida = (select max(nfp2.dataEntradaSaida)  from NotaFiscalPropria nfp2  where  nfp2.unidadeFatCliente.cliente = :cliente ) and nfp.unidadeFatCliente.cliente = :cliente");
        q.setEntity("cliente", (Object)cliente);
        q.setMaxResults(1);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        Map m = (Map)q.uniqueResult();
        if (m != null) {
            DadosEstatisticosFaturamento e = new DadosEstatisticosFaturamento();
            e.setData((Date)m.get("DATA_NOTA_MAIOR_FATURA"));
            e.setValor((Double)m.get("VALOR_NOTA_MAIOR_FATURA"));
            e.setSerie((String)m.get("SERIE_NOTA_MAIOR_FATURA"));
            e.setNumero(String.valueOf(m.get("NUMERO_NOTA_MAIOR_FATURA")));
            return e;
        }
        return null;
    }

    public DadosEstatisticosFaturamento getMaiorFaturamentoNf(Cliente cliente) {
        org.hibernate.query.Query q = this.query(" select  nfp.valoresNfPropria.valorTotal as VALOR_NOTA_MAIOR_FATURA,  cast(nfp.numeroNota as long) as NUMERO_NOTA_MAIOR_FATURA,  nfp.serie as SERIE_NOTA_MAIOR_FATURA,  nfp.dataEmissaoNota as DATA_NOTA_MAIOR_FATURA  from NotaFiscalPropria nfp  where  nfp.valoresNfPropria.valorTotal = (select max(nfp2.valoresNfPropria.valorTotal)  from NotaFiscalPropria nfp2  where  nfp2.unidadeFatCliente.cliente = :cliente ) and nfp.unidadeFatCliente.cliente = :cliente");
        q.setEntity("cliente", (Object)cliente);
        q.setMaxResults(1);
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        Map m = (Map)q.uniqueResult();
        if (m != null) {
            DadosEstatisticosFaturamento e = new DadosEstatisticosFaturamento();
            e.setData((Date)m.get("DATA_NOTA_MAIOR_FATURA"));
            e.setValor((Double)m.get("VALOR_NOTA_MAIOR_FATURA"));
            e.setSerie((String)m.get("SERIE_NOTA_MAIOR_FATURA"));
            e.setNumero(String.valueOf(m.get("NUMERO_NOTA_MAIOR_FATURA")));
            return e;
        }
        return null;
    }

    public List<TempVOInfoProdCliente> getProdutosNuncaCompradosCliente(Long idCliente, Long idEmpresa, Long idEspecie, Long idSubEspecie, Integer nrMaxRegistros) {
        String query = "select distinct pr.identificador as ID_PRODUTO, pr.codigoAuxiliar as CODIGO_AUXILIAR,  pr.nome as PRODUTO  from TabelaPrecoBase t inner join t.produtos tp inner join tp.produto pr inner join pr.especie esp inner join pr.subEspecie sub inner join t.empresa e where not exists(select p1.identificador from Pedido p1 inner join p1.itemPedido i1 inner join p1.unidadeFatCliente u1 inner join u1.cliente c1 inner join p1.empresa e1 where i1.produto = pr and c1.identificador=:idCliente and e1.identificador = :idEmp) and (t.dataFinal is null or :dataBase < t.dataFinal) and e.identificador =:idEmp  and (:idEspecie = 0 or esp.identificador = :idEspecie) and (:idSubespecie = 0 or sub.identificador = :idSubespecie) order by pr.nome asc";
        org.hibernate.query.Query q = this.query(query);
        q.setLong("idCliente", idCliente.longValue());
        q.setLong("idEmp", idEmpresa.longValue());
        q.setLong("idEspecie", idEspecie.longValue());
        q.setLong("idSubespecie", idSubEspecie.longValue());
        q.setMaxResults(nrMaxRegistros.intValue());
        q.setDate("dataBase", new Date());
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List<Map<String, Object>> data = this.toHashList((org.hibernate.Query)q);
        LinkedList<TempVOInfoProdCliente> temp = new LinkedList<TempVOInfoProdCliente>();
        for (Map<String, Object> map : data) {
            TempVOInfoProdCliente t = new TempVOInfoProdCliente();
            t.setIdProduto((Long)map.get("ID_PRODUTO"));
            t.setCodigoAuxiliar((String)map.get("CODIGO_AUXILIAR"));
            t.setNomeProduto((String)map.get("PRODUTO"));
            temp.add(t);
        }
        return temp;
    }

    public List<TempVOInfoProdCliente> getProdutosSemGiroCliente(Long idCliente, Long idEmpresa, Long idEspecie, Long idSubEspecie, Integer dias, Integer nrMaxRegistros) {
        String query = "select distinct pr.identificador as ID_PRODUTO, pr.codigoAuxiliar as CODIGO_AUXILIAR,  pr.nome as PRODUTO,  i.quantidadeTotal as QUANTIDADE_TOTAL, i.valorTotal as VALOR_TOTAL, p.dataEmissao as DATA_EMISSAO from Pedido p inner join p.itemPedido i inner join i.produto pr inner join pr.especie esp inner join pr.subEspecie sub inner join p.unidadeFatCliente u inner join u.cliente c inner join p.empresa e where c.identificador = :idCliente and p.dataEmissao <= :dataBase and e.identificador = :idEmp and (:idEspecie = 0 or esp.identificador = :idEspecie) and (:idSubespecie = 0 or sub.identificador = :idSubespecie) and not exists( select p1.identificador from Pedido p1 inner join p1.itemPedido i1 inner join p1.unidadeFatCliente u1 inner join p1.empresa e1 where i1.produto = i.produto and u1.cliente=u.cliente and p.dataEmissao>:dataBase and e1.identificador =:idEmp ) and p.dataEmissao = ( select max(p2.dataEmissao) from Pedido p2 inner join p2.itemPedido i2 inner join p2.unidadeFatCliente u2 inner join p2.empresa e2 where i2.produto = i.produto and u2.cliente=u.cliente and p.dataEmissao<=:dataBase and e2.identificador =:idEmp ) order by p.dataEmissao desc,pr.nome asc";
        org.hibernate.query.Query q = this.query(query);
        q.setLong("idCliente", idCliente.longValue());
        q.setLong("idEmp", idEmpresa.longValue());
        q.setLong("idEspecie", idEspecie.longValue());
        q.setLong("idSubespecie", idSubEspecie.longValue());
        q.setMaxResults(nrMaxRegistros.intValue());
        q.setDate("dataBase", ToolDate.previousDays((Date)new Date(), (int)dias));
        q.setResultTransformer((ResultTransformer)AliasToEntityMapResultTransformer.INSTANCE);
        List<Map<String, Object>> data = this.toHashList((org.hibernate.Query)q);
        LinkedList<TempVOInfoProdCliente> temp = new LinkedList<TempVOInfoProdCliente>();
        for (Map<String, Object> map : data) {
            TempVOInfoProdCliente t = new TempVOInfoProdCliente();
            t.setIdProduto((Long)map.get("ID_PRODUTO"));
            t.setCodigoAuxiliar((String)map.get("CODIGO_AUXILIAR"));
            t.setNomeProduto((String)map.get("PRODUTO"));
            t.setQuantidade((Double)map.get("QUANTIDADE_TOTAL"));
            t.setValor((Double)map.get("VALOR_TOTAL"));
            Date d = (Date)map.get("DATA_EMISSAO");
            t.setDataEmissao(d != null ? Long.valueOf(d.getTime()) : null);
            temp.add(t);
        }
        return temp;
    }

    public Cliente findClienteByCodCliente(String codCliente) {
        org.hibernate.query.Query q = this.query("FROM Cliente c where c.codigoCliente = :codCliente and c.ativo = :ativo");
        q.setString("codCliente", codCliente);
        q.setShort("ativo", (short)1);
        q.setMaxResults(1);
        return (Cliente)q.uniqueResult();
    }

    public List<CondicoesPagamento> getCondicoesPagamentoConfCliente(Cliente c) {
        Query query = this.getEntityManager().createQuery("select distinct cp from ClienteNFCeMeioPagamento c inner join MeioPagamento m on(m.tipoPagamentoNFe=c.tipoPagamentoNFe) inner join CondicoesPagamento cp on(cp.meioPagamento=m)where c.cliente=:cliente");
        query.setParameter("cliente", (Object)c);
        return query.getResultList();
    }

    public List<Cliente> findClientesByRamoAtvComComprasNaDataLim(Short filtrarRamoAtividade, Long ramoAtividadeInicial, Long ramoAtividadeFinal, Date dataLimite) {
        CriteriaBuilder builder = this.criteriaBuilder(Cliente.class);
        CriteriaQuery crit = builder.createQuery();
        LinkedList<Predicate> exps = new LinkedList<Predicate>();
        Root root = crit.from(Cliente.class);
        if (ToolMethods.isAffirmative((Number)filtrarRamoAtividade) && ramoAtividadeInicial != null && ramoAtividadeInicial > 0L && ramoAtividadeFinal != null && ramoAtividadeFinal > 0L && ramoAtividadeFinal > ramoAtividadeInicial) {
            Join jFaturamento = root.join("faturamento", JoinType.INNER);
            Join jRamoAtividade = jFaturamento.join("ramoAtividade", JoinType.INNER);
            exps.add(builder.between((Expression)jRamoAtividade.get("identificador"), (Comparable)ramoAtividadeInicial, (Comparable)ramoAtividadeFinal));
        }
        exps.add(builder.equal((Expression)root.get("ativo"), (Object)EnumConstStatusObjeto.ATIVO.getValue()));
        Subquery subquery = crit.subquery(NotaFiscalPropria.class);
        Root fromProject = subquery.from(NotaFiscalPropria.class);
        Join jUnidadeFatCliente = fromProject.join("unidadeFatCliente", JoinType.INNER);
        Join jClienteSub = jUnidadeFatCliente.join("cliente", JoinType.INNER);
        subquery.where((Expression)builder.and((Expression)builder.equal((Expression)jClienteSub.get("identificador"), (Expression)root.get("identificador")), (Expression)builder.greaterThan((Expression)fromProject.get("dataEmissaoNota"), (Comparable)dataLimite)));
        subquery.select((Expression)fromProject);
        exps.add(builder.not((Expression)builder.exists(subquery)));
        crit.select((Selection)root);
        crit.where(exps.toArray(new Predicate[0]));
        return this.getEntityManager().createQuery(crit).getResultList();
    }

    public List<String> getCnpjClientesAtivos() {
        AuxCriteriaBuilder builder = this.queryBuilder();
        Join jPessoa = builder.join("pessoa");
        Join jComplemento = jPessoa.join("complemento");
        builder.equal("ativo", (short)1);
        builder.select((From)jComplemento, "cnpj");
        return builder.getResult();
    }
}

