/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.dao.impl;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.model.vo.ColaboradorEvtOsProdSobEnc;
import com.touchcomp.basementorservice.dao.DaoGenericEntityImpl;
import com.touchcomp.basementorservice.dao.builders.AuxCriteriaBuilder;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import javax.persistence.criteria.From;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.Predicate;
import org.springframework.stereotype.Repository;

@Repository
public class DaoColaboradorEvtOsProdSobEncImpl
extends DaoGenericEntityImpl<ColaboradorEvtOsProdSobEnc, Long> {
    public List<ColaboradorEvtOsProdSobEnc> getEventosByColaborador(Long colaborador) {
        AuxCriteriaBuilder aux = this.queryBuilder();
        Join jColaborador = aux.join("colaborador");
        ArrayList<Predicate> where = new ArrayList<Predicate>();
        where.add(aux.equal((From)jColaborador, "identificador", colaborador));
        where.add(aux.equal((From)jColaborador, "ativo", EnumConstantsMentorSimNao.SIM.getValue()));
        where.add(aux.isNull((From)jColaborador, "dataDemissao"));
        aux.where(where);
        return aux.getResultEnt();
    }

    public List<ColaboradorEvtOsProdSobEnc> getColaboradoresAtivosEventos(Long departamento, Long turnoDeTrabalho) {
        AuxCriteriaBuilder aux = this.queryBuilder();
        Join jColaborador = aux.join("colaborador");
        Join jEventoOsProdSobEnc = aux.join("eventoOsProdSobEnc");
        ArrayList<Predicate> where = new ArrayList<Predicate>();
        if (departamento != null && departamento > 0L) {
            Join jDepartamento = jColaborador.join("departamento");
            where.add(aux.equal((From)jDepartamento, "identificador", departamento));
        }
        if (turnoDeTrabalho != null && turnoDeTrabalho > 0L) {
            Join jTurnoDeTrabalho = jEventoOsProdSobEnc.join("turnoDeTrabalho");
            where.add(aux.equal((From)jTurnoDeTrabalho, "identificador", turnoDeTrabalho));
        }
        where.add(aux.equal((From)jColaborador, "ativo", EnumConstantsMentorSimNao.SIM.getValue()));
        aux.where(where);
        return aux.getResultEnt();
    }

    public List<ColaboradorEvtOsProdSobEnc> getColaboradorPorDataInicialFinal(Long departamento, Long turnoDeTrabalho, Long idColaborador, Date dataInicial, Date dataFinal) {
        AuxCriteriaBuilder aux = this.queryBuilder();
        Join jColaborador = aux.join("colaborador");
        Join jEventoOsProdSobEnc = aux.join("eventoOsProdSobEnc");
        ArrayList<Predicate> where = new ArrayList<Predicate>();
        if (departamento != null && departamento > 0L) {
            Join jDepartamento = jColaborador.join("departamento");
            where.add(aux.equal((From)jDepartamento, "identificador", departamento));
        }
        if (turnoDeTrabalho != null && turnoDeTrabalho > 0L) {
            Join jTurnoDeTrabalho = jEventoOsProdSobEnc.join("turnoDeTrabalho");
            where.add(aux.equal((From)jTurnoDeTrabalho, "identificador", turnoDeTrabalho));
        }
        where.add(aux.equal((From)jColaborador, "ativo", EnumConstantsMentorSimNao.SIM.getValue()));
        where.add(aux.equal((From)jColaborador, "identificador", idColaborador));
        where.add(aux.between((From)jEventoOsProdSobEnc, "dataFechamento", dataInicial, (Comparable)dataFinal));
        aux.where(where);
        return aux.getResultEnt();
    }
}

