/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.dao.impl;

import com.touchcomp.basementor.constants.ConstantsESocial;
import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.colaborador.EnumConstTipoColaborador;
import com.touchcomp.basementor.constants.enums.statusobjeto.EnumConstStatusObjeto;
import com.touchcomp.basementor.model.vo.Colaborador;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.GrupoEmpresa;
import com.touchcomp.basementor.model.vo.ItemSaneamentoDadosColaborador;
import com.touchcomp.basementor.model.vo.OpcoesESocial;
import com.touchcomp.basementor.model.vo.TipoEventoEsocial;
import com.touchcomp.basementorclientwebservices.ponto.model.funcionario.DTOPontoFuncionario;
import com.touchcomp.basementorservice.dao.DaoGenericEntityImpl;
import com.touchcomp.basementorservice.dao.builders.AuxCriteriaBuilder;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import com.touchcomp.touchvomodel.vo.colaborador.web.DTOColaboradorRes;
import java.sql.Timestamp;
import java.util.Collection;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import java.util.Map;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.From;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import javax.persistence.criteria.Subquery;
import org.hibernate.Criteria;
import org.hibernate.query.Query;
import org.springframework.stereotype.Repository;

@Repository
public class DaoColaboradorImpl
extends DaoGenericEntityImpl<Colaborador, Long> {
    public Colaborador pesquisarColaboradorPorNumeroRegistro(String numeroRegistro) {
        return (Colaborador)this.toUnique(this.restrictions(this.eq("numeroRegistro", numeroRegistro)));
    }

    public Double getHorasTrabDiaEvtSobEnc(Colaborador colab, Date data) {
        Query q = this.query(" select sum(e.eventoOsProdSobEnc.horaEvento) from ColaboradorEvtOsProdSobEnc e where e.eventoOsProdSobEnc.dataFechamento<:data and  cast(e.eventoOsProdSobEnc.dataFechamento as date) = :dataDia and e.colaborador.identificador=:identificador");
        q.setParameter("data", (Object)data);
        q.setParameter("dataDia", (Object)ToolDate.strToDate((String)ToolDate.dateToStr((Date)data)));
        q.setParameter("identificador", (Object)colab.getIdentificador());
        Double d = (Double)q.uniqueResult();
        return d != null ? d : 0.0;
    }

    public Double getHorasTrabDiaEvtLinProd(Colaborador colab, Date data) {
        Query q = this.query(" select sum(e.eventoOsProducao.horaEvento) from ColabEvtOsProdLinhaProd e where e.eventoOsProducao.dataFechamento<:data and  cast(e.eventoOsProducao.dataFechamento as date) = :dataDia and e.colaborador.identificador=:identificador");
        q.setParameter("data", (Object)data);
        q.setParameter("dataDia", (Object)ToolDate.strToDate((String)ToolDate.dateToStr((Date)data)));
        q.setParameter("identificador", (Object)colab.getIdentificador());
        Double d = (Double)q.uniqueResult();
        return d != null ? d : 0.0;
    }

    public List findColaboradoresPrevisaoFeriasSemAfastados(Date dataInicial, Date dataFinal, Long centroCusto, Empresa empresa) {
        Query q = this.query(" SELECT c  FROM Colaborador c  INNER JOIN c.centroCusto cc  INNER JOIN c.tipoColaborador tc  WHERE      (:centroCusto = 0 or c.centroCusto.identificador = :centroCusto )  AND c.ativo = 1  AND c.empresa = :empresa  AND ((c.tipoColaborador.identificador = 0 or c.tipoColaborador.identificador = 3)  AND c.dataAdmissao <= :dataFinal )  AND (c.dataDemissao is null or c.dataDemissao >= :dataFinal ) AND not exists ( select af.colaborador                   FROM AfastamentoColaborador af                   INNER JOIN af.afastamentoSefip afs                   WHERE                       af.dataAfastamento != null                   AND af.colaborador = c                   AND af.dataRetorno is null                   AND af.dataAfastamento < :dataInicial                   AND (af.afastamentoSefip.codigo != :cod1                   AND afs.codigo != :cod2 and afs.codigo != :cod3) )");
        q.setDate("dataInicial", dataInicial);
        q.setDate("dataFinal", dataFinal);
        q.setLong("centroCusto", centroCusto.longValue());
        q.setEntity("empresa", (Object)empresa);
        q.setString("cod1", "Q1");
        q.setString("cod2", "Z1");
        q.setString("cod3", "U1");
        return q.list();
    }

    public List findColaboradoresPrevisaoFeriasComAfastados(Date dataInicial, Date dataFinal, Long centroCusto, Empresa empresa) {
        Query q = this.query(" SELECT DISTINCT c  FROM Colaborador c INNER JOIN c.centroCusto cc  INNER JOIN c.tipoColaborador tc  WHERE      (:centroCusto = 0 or cc.identificador = :centroCusto )  AND c.ativo = 1  AND c.empresa = :empresa  AND ((tc.identificador = 0 or tc.identificador = 3)  AND c.dataAdmissao <= :dataFinal )  AND (c.dataDemissao is null or c.dataDemissao >= :dataFinal ) ");
        q.setDate("dataFinal", dataFinal);
        q.setLong("centroCusto", centroCusto.longValue());
        q.setEntity("empresa", (Object)empresa);
        return q.list();
    }

    public Colaborador getColaboradorPorNumeroRegistro(String numeroRegistroMatricula) {
        return (Colaborador)this.toUnique(this.restrictions(this.eq("numeroRegistro", numeroRegistroMatricula), this.eq("ativo", EnumConstantsMentorSimNao.SIM.getValue())));
    }

    public DTOColaboradorRes getColaboradorPorNumeroRegistroResumido(String numeroRegistroMatricula) {
        AuxCriteriaBuilder aux = this.queryBuilder();
        aux.where(aux.equal("numeroRegistro", numeroRegistroMatricula), aux.equal("ativo", (short)1));
        Join jPessoa = aux.join("pessoa");
        aux.select(new AuxCriteriaBuilder.Pair("dataAdmissao", "dataAdmissao"), new AuxCriteriaBuilder.Pair("dataAtualizacao", "dataAtualizacao"), new AuxCriteriaBuilder.Pair("dataCadastro", "dataCadastro"), new AuxCriteriaBuilder.Pair("dataDemissao", "dataDemissao"), new AuxCriteriaBuilder.Pair("identificador", "identificador"), new AuxCriteriaBuilder.Pair("numeroRegistro", "numeroRegistro"), new AuxCriteriaBuilder.Pair((From)jPessoa, "nome", "nome"));
        Map m = aux.getUniqueResultMap();
        if (m == null) {
            return null;
        }
        DTOColaboradorRes d = new DTOColaboradorRes();
        d.setDataAdmissao((Date)m.get("dataAdmissao"));
        d.setDataAtualizacao((Timestamp)m.get("dataAtualizacao"));
        d.setDataCadastro((Date)m.get("dataCadastro"));
        d.setDataDemissao((Date)m.get("dataDemissao"));
        d.setIdentificador((Long)m.get("identificador"));
        d.setNumeroRegistro((String)m.get("numeroRegistro"));
        d.setPessoa((String)m.get("nome"));
        return d;
    }

    public DTOColaboradorRes getColaboradorAtivoPorNumeroRegistroResumido(String numeroRegistroMatricula) {
        AuxCriteriaBuilder aux = this.queryBuilder();
        Join jPessoa = aux.join("pessoa");
        aux.where(aux.equal("numeroRegistro", numeroRegistroMatricula), aux.equal("ativo", (short)1), aux.equal((From)jPessoa, "ativo", (short)1), aux.isNull("dataDemissao"));
        aux.select(new AuxCriteriaBuilder.Pair("dataAdmissao", "dataAdmissao"), new AuxCriteriaBuilder.Pair("dataAtualizacao", "dataAtualizacao"), new AuxCriteriaBuilder.Pair("dataCadastro", "dataCadastro"), new AuxCriteriaBuilder.Pair("dataDemissao", "dataDemissao"), new AuxCriteriaBuilder.Pair("identificador", "identificador"), new AuxCriteriaBuilder.Pair("numeroRegistro", "numeroRegistro"), new AuxCriteriaBuilder.Pair((From)jPessoa, "nome", "nome"));
        Map m = aux.getUniqueResultMap();
        if (m == null) {
            return null;
        }
        DTOColaboradorRes d = new DTOColaboradorRes();
        d.setDataAdmissao((Date)m.get("dataAdmissao"));
        d.setDataAtualizacao((Timestamp)m.get("dataAtualizacao"));
        d.setDataCadastro((Date)m.get("dataCadastro"));
        d.setDataDemissao((Date)m.get("dataDemissao"));
        d.setIdentificador((Long)m.get("identificador"));
        d.setNumeroRegistro((String)m.get("numeroRegistro"));
        d.setPessoa((String)m.get("nome"));
        return d;
    }

    public boolean validaColaboradorSenhaAcesso(String numeroRegistroColaborador, String senhaAcessoColab) {
        AuxCriteriaBuilder aux = this.queryBuilder();
        aux.where(aux.equal("numeroRegistro", numeroRegistroColaborador), aux.equal("senhaAcessoColab", senhaAcessoColab), aux.equal("ativo", (short)1));
        aux.select(aux.getCount("identificador"));
        Long res = (Long)aux.getUniqueResult();
        return TMethods.isWithData((Number)res);
    }

    public List<Colaborador> getColaboradorAtivos(Empresa empresa) {
        CriteriaBuilder builder = this.criteriaBuilder(Colaborador.class);
        CriteriaQuery crit = builder.createQuery();
        LinkedList<Predicate> exps = new LinkedList<Predicate>();
        Root fromColaborador = crit.from(Colaborador.class);
        Join jEmpresa = fromColaborador.join("empresa", JoinType.INNER);
        crit.select((Selection)fromColaborador);
        exps.add(builder.equal((Expression)fromColaborador.get("ativo"), (Object)EnumConstantsMentorSimNao.SIM.getValue()));
        exps.add(builder.isNull((Expression)fromColaborador.get("dataDemissao")));
        exps.add(builder.equal((Expression)jEmpresa.get("identificador"), (Object)empresa.getIdentificador()));
        crit.where(exps.toArray(new Predicate[0]));
        return this.getEntityManager().createQuery(crit).getResultList();
    }

    public Colaborador getColaboradorByIdPessoa(Long idPessoa) {
        Criteria c = this.criteria();
        c.createAlias("pessoa", "pes");
        c.add(this.eq("pes.identificador", idPessoa));
        c.setMaxResults(1);
        return (Colaborador)c.uniqueResult();
    }

    public List<Colaborador> findColaboradoresSemEventosESocial(OpcoesESocial opcoes, GrupoEmpresa grupo) {
        CriteriaBuilder builder = this.criteriaBuilder(Colaborador.class);
        CriteriaQuery crit = builder.createQuery();
        LinkedList<Predicate> exps = new LinkedList<Predicate>();
        Root root = crit.from(Colaborador.class);
        Join jTipoColaborador = root.join("tipoColaborador", JoinType.INNER);
        Join jEmpresa = root.join("empresa", JoinType.INNER);
        Join jEmpresaDados = jEmpresa.join("empresaDados", JoinType.INNER);
        exps.add(builder.isNull((Expression)root.get("dataDemissao")));
        exps.add(builder.equal((Expression)jEmpresaDados.get("grupoEmpresa"), (Object)grupo));
        exps.add(builder.greaterThanOrEqualTo((Expression)root.get("dataAdmissao"), (Comparable)opcoes.getDataInicio()));
        exps.add(builder.equal((Expression)root.get("ativo"), (Object)EnumConstStatusObjeto.ATIVO.getValue()));
        exps.add(builder.or((Expression)builder.equal((Expression)jTipoColaborador.get("identificador"), (Object)EnumConstTipoColaborador.MENOR_APRENDIZ.getValue()), (Expression)builder.equal((Expression)jTipoColaborador.get("identificador"), (Object)EnumConstTipoColaborador.EMPREGADO.getValue())));
        Subquery subquery = crit.subquery(ItemSaneamentoDadosColaborador.class);
        Root fromItemSaneamentoColab = subquery.from(ItemSaneamentoDadosColaborador.class);
        Join jColaborador = fromItemSaneamentoColab.join("colaborador", JoinType.INNER);
        subquery.where(new Predicate[]{builder.equal((Expression)jColaborador.get("identificador"), (Expression)root.get("identificador")), builder.equal((Expression)fromItemSaneamentoColab.get("liberado"), (Object)EnumConstantsMentorSimNao.SIM.getValue())});
        exps.add(builder.not((Expression)builder.in((Expression)root.get("identificador")).value((Expression)subquery.select((Expression)jColaborador.get("identificador")))));
        crit.select((Selection)root);
        crit.where(exps.toArray(new Predicate[0]));
        return this.getEntityManager().createQuery(crit).getResultList();
    }

    public List<Colaborador> findColaboradoresByTipoColaboradorEsoc(TipoEventoEsocial tipoEvento, GrupoEmpresa grupo, Date dataInicial, Date dataFinal) {
        CriteriaBuilder builder = this.criteriaBuilder(Colaborador.class);
        CriteriaQuery crit = builder.createQuery();
        LinkedList<Predicate> exps = new LinkedList<Predicate>();
        Root root = crit.from(Colaborador.class);
        Join jTipoColaborador = root.join("tipoColaborador", JoinType.INNER);
        Join jEmpresa = root.join("empresa", JoinType.INNER);
        Join jEmpresaDados = jEmpresa.join("empresaDados", JoinType.INNER);
        if (ToolMethods.isEquals((Object)tipoEvento.getIdentificador(), (Object)ConstantsESocial.REGISTRO_2200)) {
            exps.add(builder.or((Expression)builder.equal((Expression)jTipoColaborador.get("identificador"), (Object)EnumConstTipoColaborador.EMPREGADO.getValue()), (Expression)builder.equal((Expression)jTipoColaborador.get("identificador"), (Object)EnumConstTipoColaborador.MENOR_APRENDIZ.getValue())));
        } else {
            exps.add(builder.or(new Predicate[]{builder.equal((Expression)jTipoColaborador.get("identificador"), (Object)EnumConstTipoColaborador.AUTONOMO.getValue()), builder.equal((Expression)jTipoColaborador.get("identificador"), (Object)EnumConstTipoColaborador.AUTONOMO_FRETE.getValue()), builder.equal((Expression)jTipoColaborador.get("identificador"), (Object)EnumConstTipoColaborador.SOCIO_DIRETOR.getValue()), builder.equal((Expression)jTipoColaborador.get("identificador"), (Object)EnumConstTipoColaborador.ESTAGIARIO.getValue())}));
        }
        exps.add(builder.isNull((Expression)root.get("dataDemissao")));
        exps.add(builder.equal((Expression)root.get("ativo"), (Object)EnumConstantsMentorSimNao.SIM.getValue()));
        exps.add(builder.equal((Expression)jEmpresaDados.get("grupoEmpresa"), (Object)grupo));
        if (TMethods.isNotNull((Object)dataInicial).booleanValue() && TMethods.isNotNull((Object)dataFinal).booleanValue()) {
            exps.add(builder.between((Expression)root.get("dataAdmissao"), (Comparable)dataInicial, (Comparable)dataFinal));
        }
        Subquery subquery = crit.subquery(ItemSaneamentoDadosColaborador.class);
        Root fromItemSaneamentoColab = subquery.from(ItemSaneamentoDadosColaborador.class);
        Join jColaborador = fromItemSaneamentoColab.join("colaborador", JoinType.INNER);
        subquery.where(new Predicate[]{builder.equal((Expression)jColaborador.get("identificador"), (Expression)root.get("identificador")), builder.equal((Expression)fromItemSaneamentoColab.get("liberado"), (Object)EnumConstantsMentorSimNao.SIM.getValue())});
        exps.add(builder.not((Expression)builder.in((Expression)root.get("identificador")).value((Expression)subquery.select((Expression)jColaborador.get("identificador")))));
        crit.select((Selection)root);
        crit.where(exps.toArray(new Predicate[0]));
        return this.getEntityManager().createQuery(crit).getResultList();
    }

    public List<DTOPontoFuncionario> findColaboradoresPonto(Date dataBaseSincSistemaPonto, Date dataUltimaSincronizacao) {
        AuxCriteriaBuilder aux = this.queryBuilder();
        Join jCentroCusto = aux.join("centroCusto");
        Join jEstadoCivil = aux.join("estadoCivil");
        Join jNacionalidade = aux.join("nacionalidade");
        Join jFuncao = aux.join("funcao");
        Join jEmpresa = aux.join("empresa");
        Join jPessoaEmpresa = jEmpresa.join("pessoa");
        Join jComplementoEmpresa = jPessoaEmpresa.join("complemento");
        Join jPessoa = aux.join("pessoa");
        Join jComplemento = jPessoa.join("complemento");
        Join jEndereco = jPessoa.join("endereco");
        Join jEnderecoEmpresa = jPessoaEmpresa.join("endereco");
        Join jCidade = jEndereco.join("cidade");
        Join jCidadeEmpresa = jEnderecoEmpresa.join("cidade");
        Join jUf = jCidade.join("uf");
        Join jUfEmpresa = jCidadeEmpresa.join("uf");
        Join jPaisEmpresa = jUfEmpresa.join("pais");
        aux.select((From)jPessoa, "nome");
        aux.select("numeroRegistro");
        aux.select((From)jComplemento, "rg");
        aux.select((From)jComplemento, "cnpj");
        aux.select("numeroPis");
        aux.select("dataAdmissao");
        aux.select((From)jComplemento, "emailPrincipal");
        aux.select((From)jEmpresa, "identificador");
        aux.select((From)jEndereco, "cep");
        aux.select((From)jEndereco, "logradouro");
        aux.select((From)jCidade, "descricao");
        aux.select((From)jUf, "sigla");
        aux.select((From)jComplemento, "orgaoEmissor");
        aux.select("carteiraProfissional");
        aux.select((From)jCentroCusto, "identificador");
        aux.select((From)jEndereco, "bairro");
        aux.select((From)jComplemento, "dataNascimento");
        aux.select("sexo");
        aux.select((From)jEstadoCivil, "nome");
        aux.select("nomePai");
        aux.select("nomeMae");
        aux.select((From)jNacionalidade, "descricao");
        aux.select("senhaAcessoColab");
        aux.select((From)jComplemento, "fone1");
        aux.select((From)jComplemento, "cel1");
        aux.select((From)jComplementoEmpresa, "emailPrincipal");
        aux.select((From)jFuncao, "identificador");
        aux.select("identificador");
        aux.select((From)jEnderecoEmpresa, "logradouro");
        aux.select((From)jCidadeEmpresa, "descricao");
        aux.select((From)jPessoaEmpresa, "nome");
        aux.select((From)jPaisEmpresa, "descricao");
        aux.select((From)jComplementoEmpresa, "cnpj");
        aux.select((From)jEnderecoEmpresa, "numero");
        aux.select((From)jComplementoEmpresa, "fone1");
        aux.select((From)jUfEmpresa, "sigla");
        LinkedList<Predicate> where = new LinkedList<Predicate>();
        where.add(aux.isNotNull((From)jComplemento, "emailPrincipal"));
        where.add(aux.isNotNull((From)jComplementoEmpresa, "emailPrincipal"));
        where.add(aux.notEqual((From)jComplemento, "emailPrincipal", ""));
        where.add(aux.and(aux.isNotNull("dataCadastro"), aux.gt("dataCadastro", dataBaseSincSistemaPonto)));
        if (TMethods.isNotNull((Object)dataUltimaSincronizacao).booleanValue()) {
            where.add(aux.gt("dataAtualizacao", dataUltimaSincronizacao));
        }
        aux.where(where);
        List data = aux.getResult();
        LinkedList<DTOPontoFuncionario> result = new LinkedList<DTOPontoFuncionario>();
        for (Object[] obj : data) {
            DTOPontoFuncionario dto = new DTOPontoFuncionario();
            dto.setName((String)obj[0]);
            dto.setMatricula((String)obj[1]);
            dto.setRg((String)obj[2]);
            dto.setCpf((String)obj[3]);
            dto.setPis((String)obj[4]);
            dto.setDtaadmissao((Date)obj[5]);
            dto.setEmail((String)obj[6]);
            dto.setIdEmpresa((Long)obj[7]);
            dto.setCep((String)obj[8]);
            dto.setEndereco((String)obj[9]);
            dto.setCidade((String)obj[10]);
            dto.setUf((String)obj[11]);
            dto.setOrgaoExpedidor((String)obj[12]);
            dto.setCtps((String)obj[13]);
            dto.setIdDepartamento((Long)obj[14]);
            dto.setBairro((String)obj[15]);
            dto.setDtnascimento((Date)obj[16]);
            dto.setSexo((Short)obj[17]);
            dto.setEstadoCivil((String)obj[18]);
            dto.setNomePai((String)obj[19]);
            dto.setNomeMae((String)obj[20]);
            dto.setNacionalidade((String)obj[21]);
            dto.setLogin((String)obj[3]);
            dto.setSenha((String)obj[22]);
            dto.setPhone((String)obj[23]);
            dto.setCellphone((String)obj[24]);
            dto.setEmailCorporativo((String)obj[25]);
            dto.setIdFuncao((Long)obj[26]);
            dto.setIdentificador((Long)obj[27]);
            result.add(dto);
        }
        return result;
    }

    public String buscarUltimoNumRegistro(Long empresa, Long tipo) {
        Query q = this.query(" SELECT max(cast(c.numeroRegistro as integer))  FROM Colaborador c INNER JOIN c.empresa e  INNER JOIN c.tipoColaborador tc  WHERE      e.identificador = :empresa   AND tc.identificador = :tipo ");
        q.setParameter("empresa", (Object)empresa);
        q.setParameter("tipo", (Object)tipo);
        Integer result = (Integer)q.getSingleResult();
        return ToolMethods.isNotNull((Object)result) != false ? result.toString() : "";
    }

    public List<Colaborador> getColaboradoresAtivos(Date dataFinal, List<Long> centroCusto, List<Long> departamentos, List<String> nrRegColaboradores, Empresa empresa) {
        int filtrarColaborador;
        centroCusto = ToolMethods.clearNumberList(centroCusto);
        departamentos = ToolMethods.clearNumberList(departamentos);
        nrRegColaboradores = ToolMethods.clearStringList(nrRegColaboradores);
        int filtrarCentroCusto = ToolMethods.isWithData((Collection)centroCusto) ? 1 : 0;
        int filtrarDepartamento = ToolMethods.isWithData((Collection)departamentos) ? 1 : 0;
        int n = filtrarColaborador = ToolMethods.isWithData((Collection)nrRegColaboradores) ? 1 : 0;
        if (!ToolMethods.isWithData((Collection)centroCusto)) {
            centroCusto.add(0L);
        }
        if (!ToolMethods.isWithData((Collection)departamentos)) {
            departamentos.add(0L);
        }
        if (!ToolMethods.isWithData((Collection)nrRegColaboradores)) {
            nrRegColaboradores.add("");
        }
        String hql = "select distinct c\nfrom Colaborador c\ninner join c.tipoColaborador cc\ninner join c.pessoa p\nleft join c.departamento dep\nleft join c.centroCusto cen\nwhere\n(:filtrarCentroCusto = 0 or cen.identificador in(:centroCusto)) and\n(:filtrarDepartamento = 0 or dep.identificador in (:departamentos)) and\n(:filtrarColaborador = 0 or c.numeroRegistro in(:nrRegColaboradores)) and\nc.ativo = 1  and\nc.empresa = :empresa and\n(c.tipoColaborador.identificador in(:tipoColaboradorCLT)) and\n(c.dataAdmissao <= :dataFinal ) and\n(c.dataDemissao is null or c.dataDemissao >= :dataFinal )\norder by p.nome";
        Query q = this.query(hql);
        q.setParameter("dataFinal", (Object)dataFinal);
        q.setParameter("empresa", (Object)empresa);
        q.setParameterList("tipoColaboradorCLT", (Collection)EnumConstTipoColaborador.getTiposColaboradorCLTValue());
        q.setParameter("filtrarCentroCusto", (Object)filtrarCentroCusto);
        q.setParameter("centroCusto", (Object)centroCusto);
        q.setParameter("filtrarDepartamento", (Object)filtrarDepartamento);
        q.setParameter("departamentos", (Object)departamentos);
        q.setParameter("filtrarColaborador", (Object)filtrarColaborador);
        q.setParameter("nrRegColaboradores", (Object)nrRegColaboradores);
        return q.getResultList();
    }

    public Date getUltimaDataDemissaoPorPessoaEmpresa(Long idEmpresa, Long idPessoa) {
        try {
            CriteriaBuilder builder = this.criteriaBuilder(Colaborador.class);
            CriteriaQuery crit = builder.createQuery();
            LinkedList<Predicate> exps = new LinkedList<Predicate>();
            Root root = crit.from(Colaborador.class);
            Join jPessoa = root.join("pessoa", JoinType.INNER);
            Join jEmpresa = root.join("empresa", JoinType.INNER);
            crit.select((Selection)builder.greatest((Expression)root.get("dataDemissao")));
            exps.add(builder.equal((Expression)jPessoa.get("identificador"), (Object)idPessoa));
            exps.add(builder.equal((Expression)jEmpresa.get("identificador"), (Object)idEmpresa));
            exps.add(builder.isNotNull((Expression)root.get("dataDemissao")));
            crit.where(exps.toArray(new Predicate[0]));
            return (Date)this.getEntityManager().createQuery(crit).getSingleResult();
        }
        catch (Exception e) {
            return null;
        }
    }

    public Colaborador findColaboradorCarteiraPlanoSaude(String numeroCarteiraPlanoSaude) {
        AuxCriteriaBuilder builder = this.queryBuilder();
        builder.equal("numeroCarteiraPlanoSaude", numeroCarteiraPlanoSaude);
        builder.equal("ativo", (short)1);
        return (Colaborador)builder.getUniqueResult();
    }

    public List<Colaborador> findColaboradorByCentroCustoAndEmpresa(Long empresa, Long centroCusto) {
        CriteriaBuilder builder = this.criteriaBuilder(Colaborador.class);
        CriteriaQuery crit = builder.createQuery();
        LinkedList<Predicate> exps = new LinkedList<Predicate>();
        Root fromColaborador = crit.from(Colaborador.class);
        Join jEmpresa = fromColaborador.join("empresa", JoinType.INNER);
        Join jCentroCusto = fromColaborador.join("centroCusto", JoinType.INNER);
        exps.add(builder.equal((Expression)fromColaborador.get("ativo"), (Object)EnumConstantsMentorSimNao.SIM.getEnumId()));
        exps.add(builder.isNull((Expression)fromColaborador.get("dataDemissao")));
        exps.add(builder.equal((Expression)jEmpresa.get("identificador"), (Object)empresa));
        exps.add(builder.equal((Expression)jCentroCusto.get("identificador"), (Object)centroCusto));
        crit.select((Selection)fromColaborador).distinct(true);
        crit.where(exps.toArray(new Predicate[0]));
        return this.getEntityManager().createQuery(crit).getResultList();
    }
}

