/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.dao.impl;

import com.touchcomp.basementor.model.vo.Colaborador;
import com.touchcomp.basementor.model.vo.ColaboradorSalario;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.Funcao;
import com.touchcomp.basementor.model.vo.TipoColaborador;
import com.touchcomp.basementorexceptions.exceptions.ExceptionRuntimeBase;
import com.touchcomp.basementorservice.dao.DaoGenericEntityImpl;
import com.touchcomp.basementortools.tools.date.ToolDate;
import java.util.ArrayList;
import java.util.Date;
import java.util.LinkedList;
import java.util.List;
import javax.persistence.criteria.CriteriaBuilder;
import javax.persistence.criteria.CriteriaDelete;
import javax.persistence.criteria.CriteriaQuery;
import javax.persistence.criteria.Expression;
import javax.persistence.criteria.Join;
import javax.persistence.criteria.JoinType;
import javax.persistence.criteria.Predicate;
import javax.persistence.criteria.Root;
import javax.persistence.criteria.Selection;
import org.hibernate.Criteria;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Disjunction;
import org.hibernate.criterion.Order;
import org.hibernate.criterion.Restrictions;
import org.hibernate.query.Query;
import org.springframework.stereotype.Repository;

@Repository
public class DaoColaboradorSalarioImpl
extends DaoGenericEntityImpl<ColaboradorSalario, Long> {
    public Double getMaiorVrSalarioColaboradorNoPeriodo(Colaborador c, Date periodo) {
        Query q = this.query(" select c.valorSalario  from ColaboradorSalario c where c.periodo = (select max(cc.periodo)  from ColaboradorSalario cc                    where (cc.periodo <= :periodo) and cc.colaborador.identificador = :colaborador) and c.colaborador.identificador = :colaborador");
        q.setLong("colaborador", c.getIdentificador().longValue());
        q.setDate("periodo", periodo);
        q.setMaxResults(1);
        return (Double)q.uniqueResult();
    }

    public Double findVrSalarioMaiorColaboradorSalarioNoPeriodo(Colaborador c, Date periodo) {
        String hql = " select c.valorSalario  from ColaboradorSalario c where c.periodo = (select max(cc.periodo)  from ColaboradorSalario cc                    where (cc.periodo <= :periodo) and cc.colaborador = :colaborador) and c.colaborador = :colaborador";
        Query query = this.query(hql);
        query.setParameter("periodo", (Object)periodo);
        query.setParameter("colaborador", (Object)c);
        if (query.list().size() > 1 || query.uniqueResult() == null) {
            throw new ExceptionRuntimeBase("Verifique as informa\u00e7\u00f5es referentes ao Salario do colaborador: " + c.getNumeroRegistro() + " " + c.getPessoa().getNome());
        }
        return (Double)query.uniqueResult();
    }

    public List<ColaboradorSalario> getColaboradores(List<TipoColaborador> tipos, Empresa empresa, Date periodo) {
        Criteria crit = this.criteria();
        crit.add((Criterion)Restrictions.gt((String)"periodo", (Object)ToolDate.strToDate((String)"11/11/1111")));
        crit.addOrder(Order.asc((String)"periodo"));
        crit = crit.add((Criterion)Restrictions.lt((String)"periodo", (Object)periodo)).createCriteria("colaborador");
        crit = crit.add(Restrictions.isEmpty((String)"recisoes"));
        crit = crit.add((Criterion)Restrictions.eq((String)"empresa", (Object)empresa));
        crit = crit.createCriteria("tipoColaborador");
        Disjunction disj = Restrictions.or((Criterion[])new Criterion[0]);
        for (TipoColaborador vo : tipos) {
            disj.add(this.eq("identificador", vo.getIdentificador()));
        }
        crit.add((Criterion)disj);
        crit.setResultTransformer(Criteria.DISTINCT_ROOT_ENTITY);
        return crit.list();
    }

    public List<ColaboradorSalario> getColaboradoresColaboradores(List<Colaborador> colaboradores, Empresa empresa, Date periodo) {
        Criteria crit = this.criteria();
        crit.add((Criterion)Restrictions.gt((String)"periodo", (Object)ToolDate.strToDate((String)"11/11/1111")));
        crit.addOrder(Order.asc((String)"periodo"));
        crit = crit.add((Criterion)Restrictions.lt((String)"periodo", (Object)periodo)).createCriteria("colaborador");
        crit = crit.add(Restrictions.isEmpty((String)"recisoes"));
        crit = crit.add((Criterion)Restrictions.eq((String)"empresa", (Object)empresa));
        Disjunction disj = Restrictions.or((Criterion[])new Criterion[0]);
        for (Colaborador vo : colaboradores) {
            disj.add(this.eq("identificador", vo.getIdentificador()));
        }
        crit.add((Criterion)disj);
        crit.setResultTransformer(Criteria.DISTINCT_ROOT_ENTITY);
        return crit.list();
    }

    public Funcao findFuncaoColaboradorNoPeriodo(Colaborador c, Date periodo) {
        Query q = this.query(" select c.funcao  from ColaboradorSalario c where c.periodo = (select max(cc.periodo)  from ColaboradorSalario cc                    where (cc.periodo <= :periodo) and cc.colaborador.identificador = :colaborador) and c.colaborador.identificador = :colaborador");
        q.setLong("colaborador", c.getIdentificador().longValue());
        q.setDate("periodo", periodo);
        return (Funcao)q.uniqueResult();
    }

    public List<ColaboradorSalario> getColaboradorSalarioPorColaborador(Long idColaborador) {
        try {
            CriteriaBuilder builder = this.criteriaBuilder(ColaboradorSalario.class);
            CriteriaQuery crit = builder.createQuery();
            LinkedList<Predicate> exps = new LinkedList<Predicate>();
            Root fromColaboradorSalario = crit.from(ColaboradorSalario.class);
            Join jColaborador = fromColaboradorSalario.join("colaborador", JoinType.INNER);
            crit.select((Selection)fromColaboradorSalario);
            exps.add(builder.equal((Expression)jColaborador.get("identificador"), (Object)idColaborador));
            crit.where(exps.toArray(new Predicate[0]));
            return this.getEntityManager().createQuery(crit).getResultList();
        }
        catch (Exception ex) {
            return new ArrayList<ColaboradorSalario>();
        }
    }

    public void deleteColaboradorSalarioPorColaborador(Long idColaborador) {
        CriteriaBuilder builder = this.criteriaBuilder(ColaboradorSalario.class);
        CriteriaDelete criteriaDelete = builder.createCriteriaDelete(ColaboradorSalario.class);
        LinkedList<Predicate> exps = new LinkedList<Predicate>();
        Root root = criteriaDelete.from(ColaboradorSalario.class);
        Join jColaborador = root.join("colaborador", JoinType.INNER);
        exps.add(builder.equal((Expression)jColaborador.get("identificador"), (Object)idColaborador));
        criteriaDelete.where(exps.toArray(new Predicate[0]));
        this.getSession().createQuery(criteriaDelete).executeUpdate();
    }
}

