/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.dao.impl;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorStatus;
import com.touchcomp.basementor.model.vo.ColetaDadosAtivo;
import com.touchcomp.basementor.model.vo.EquipColetaDadosAtivoSensorIOT;
import com.touchcomp.basementor.model.vo.Equipamento;
import com.touchcomp.basementorservice.dao.DaoGenericEntityImpl;
import com.touchcomp.basementorservice.dao.builders.AuxCriteriaBuilder;
import com.touchcomp.basementorservice.model.genericmap.GenericMapValues;
import com.touchcomp.basementorservice.model.genericmap.impl.GenMapColetaDadosDiariaIOT;
import java.util.Date;
import java.util.List;
import javax.persistence.criteria.From;
import javax.persistence.criteria.Join;
import org.hibernate.Criteria;
import org.springframework.stereotype.Repository;

@Repository
public class DaoColetaDadosAtivoImpl
extends DaoGenericEntityImpl<ColetaDadosAtivo, Long> {
    public List<ColetaDadosAtivo> getColetasProcPendente() {
        Criteria c = this.criteria();
        return this.toList(this.restrictions(this.notEqual("statusProcessamento", EnumConstantsMentorStatus.SUCESSO.getValue())));
    }

    public ColetaDadosAtivo getUltColetaAberta(String sensor, Equipamento equipamentoMensurado, Equipamento equipamentoColeta) {
        AuxCriteriaBuilder crit = this.queryBuilder();
        Join jColeta = crit.join("equipColetaDadosAtivoIOT");
        crit.equal((From)jColeta, "equipamentoColeta", equipamentoColeta);
        crit.equal("equipamento", equipamentoMensurado);
        crit.equal("identificacaoSensor", sensor);
        crit.equal("statusColeta", (short)0);
        crit.orderDesc("dataHoraUltColeta");
        return (ColetaDadosAtivo)crit.getUniqueResult();
    }

    public List<GenericMapValues<GenMapColetaDadosDiariaIOT>> getColetasDiarias(EquipColetaDadosAtivoSensorIOT sensorIOT, Date dataInicial, Date dataFinal) {
        AuxCriteriaBuilder crit = this.queryBuilder();
        crit.equal("equipColetaDadosAtSensorIOT", sensorIOT);
        crit.equal("statusColeta", (short)1);
        crit.between("dataColeta", dataInicial, (Comparable)dataFinal);
        AuxCriteriaBuilder.Pair data = AuxCriteriaBuilder.pair("dataColeta", GenMapColetaDadosDiariaIOT.DATA_COLETA.getValue());
        AuxCriteriaBuilder.Pair tempo = AuxCriteriaBuilder.pair("tempoDuracaoColeta", GenMapColetaDadosDiariaIOT.TEMPO_COLETA.getValue());
        crit.select(data);
        crit.select(crit.getSum(tempo));
        crit.groupBy(data);
        return this.toGenMapList(crit.getResultMap(), GenMapColetaDadosDiariaIOT.class);
    }
}

