/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.dao.impl;

import com.touchcomp.basementor.model.vo.Coleta;
import com.touchcomp.basementor.model.vo.ColetaDadosAtivo;
import com.touchcomp.basementor.model.vo.Equipamento;
import com.touchcomp.basementor.model.vo.TipoPontoControle;
import com.touchcomp.basementorservice.dao.DaoGenericEntityImpl;
import java.util.Date;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.query.Query;
import org.springframework.stereotype.Repository;

@Repository
public class DaoColetaImpl
extends DaoGenericEntityImpl<Coleta, Long> {
    public Coleta findColetaAnterior(Equipamento ativo, TipoPontoControle tipoPontoControle) {
        String query = "SELECT min(c) FROM Coleta c LEFT JOIN c.coletaPosterior p WHERE c.ativo.identificador = :idEquipamento AND c.tipoPontoControle.identificador = :idTipoPontoControle AND p.identificador IS NULL";
        Query q = this.query(query);
        q.setParameter("idEquipamento", (Object)ativo.getIdentificador());
        q.setParameter("idTipoPontoControle", (Object)tipoPontoControle.getIdentificador());
        return (Coleta)q.uniqueResult();
    }

    public Coleta getColeta(ColetaDadosAtivo coleta) {
        return (Coleta)this.toUnique(this.restrictions(this.eq("coletaDadosAtivo", coleta)));
    }

    public Double getColetaAnterior(String codigoAtivoPlaca, Date dataColeta) {
        Query q = this.query("SELECT c.valorColeta FROM Coleta c WHERE c.dataHoraColeta = ( SELECT MAX(t.dataHoraColeta) FROM Coleta t WHERE t.ativo = c.ativo AND   t.dataHoraColeta < :dataConsumo) and c.ativo.codigo = :codigoAtivoPlaca order by c.identificador desc");
        q.setString("codigoAtivoPlaca", codigoAtivoPlaca);
        q.setDate("dataConsumo", dataColeta);
        q.setMaxResults(1);
        Integer hodo = (Integer)q.uniqueResult();
        if (hodo != null) {
            return Double.valueOf(hodo.toString());
        }
        return 0.0;
    }

    public List<Coleta> buscaColetasAtivoComExclusao(Coleta coleta) {
        Criteria c = this.criteria();
        c.add(this.eq("ativo", coleta.getAtivo()));
        c.add(this.eq("tipoPontoControle", coleta.getTipoPontoControle()));
        c.add(this.notEqual("identificador", coleta.getIdentificador()));
        this.orderDesc(c, "numeroColeta");
        return c.list();
    }

    public Coleta findByNumero(Long numero, Long ativo) {
        return (Coleta)this.toUnique(this.restrictions(this.eq("numeroColeta", numero), this.eq("ativo.identificador", ativo)));
    }
}

