/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.dao.impl;

import com.touchcomp.basementor.constants.enums.opcoescontabeis.EnumConstOpContabeisTipoContComunicado;
import com.touchcomp.basementor.model.vo.ComunicadoProducao;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.IntegComuProdEspecie;
import com.touchcomp.basementor.model.vo.IntegComuProdSubEspecie;
import com.touchcomp.basementor.model.vo.OpcoesContabeis;
import com.touchcomp.basementorservice.dao.DaoGenericEntityImpl;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.touchvomodel.vo.lotefabricacao.web.DTORastreioLoteFabricacao;
import java.util.Date;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Disjunction;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.ProjectionList;
import org.hibernate.criterion.Projections;
import org.hibernate.criterion.Restrictions;
import org.hibernate.query.Query;
import org.hibernate.transform.AliasToBeanResultTransformer;
import org.hibernate.transform.ResultTransformer;
import org.springframework.stereotype.Repository;

@Repository
public class DaoComunicadoProducaoImpl
extends DaoGenericEntityImpl<ComunicadoProducao, Long> {
    public Double getUltimoCusto(Long idProduto, Long idEmpresa) {
        String query = "select g.valorUnitario  from ComunicadoProducao c inner join c.itemComunicadoProducao i inner join i.gradeItemComunicadoProducao g where i.produto.identificador = :idProduto and c.empresa.identificador = :idEmpresa and c.dataEntradaSaida=( select max(c1.dataEntradaSaida) from ComunicadoProducao c1 inner join c1.itemComunicadoProducao i1 where c1.empresa = c.empresa and i1.produto = i.produto)  order by c.identificador desc";
        Query q = this.query(query);
        q.setLong("idEmpresa", idEmpresa.longValue());
        q.setLong("idProduto", idProduto.longValue());
        q.setMaxResults(1);
        return (Double)q.uniqueResult();
    }

    public Double getUltimoCusto(Long idProduto, Long idEmpresa, Date dataBase) {
        String query = "select g.valorUnitario  from ComunicadoProducao c inner join c.itemComunicadoProducao i inner join i.gradeItemComunicadoProducao g where i.produto.identificador = :idProduto and c.empresa.identificador = :idEmpresa and c.dataEntradaSaida=( select max(c1.dataEntradaSaida) from ComunicadoProducao c1 inner join c1.itemComunicadoProducao i1 where c1.empresa = c.empresa and i1.produto = i.produto and c1.dataEntradaSaida >=:dataBase)  order by c.identificador desc";
        Query q = this.query(query);
        q.setDate("dataBase", dataBase);
        q.setLong("idEmpresa", idEmpresa.longValue());
        q.setLong("idProduto", idProduto.longValue());
        q.setMaxResults(1);
        return (Double)q.uniqueResult();
    }

    public Double getUltimoCusto(Long idProduto) {
        String query = "select g.valorUnitario  from ComunicadoProducao c inner join c.itemComunicadoProducao i inner join i.gradeItemComunicadoProducao g where i.produto.identificador = :idProduto and c.dataEntradaSaida=( select max(c1.dataEntradaSaida) from ComunicadoProducao c1 inner join c1.itemComunicadoProducao i1 where i1.produto = i.produto)  order by c.identificador desc";
        Query q = this.query(query);
        q.setLong("idProduto", idProduto.longValue());
        q.setMaxResults(1);
        return (Double)q.uniqueResult();
    }

    public Double getUltimoCusto(Long idProduto, Date dataBase) {
        String query = "select g.valorUnitario  from ComunicadoProducao c inner join c.itemComunicadoProducao i inner join i.gradeItemComunicadoProducao g where i.produto.identificador = :idProduto and c.dataEntradaSaida=( select max(c1.dataEntradaSaida) from ComunicadoProducao c1 inner join c1.itemComunicadoProducao i1 where i1.produto = i.produto and c.dataEntradaSaida>=:dataBase)  order by c.identificador desc";
        Query q = this.query(query);
        q.setDate("dataBase", dataBase);
        q.setLong("idProduto", idProduto.longValue());
        q.setMaxResults(1);
        return (Double)q.uniqueResult();
    }

    public List<ComunicadoProducao> getComunicadosProducaoPorPeriodo(Date dataInicial, Date dataFinal, Empresa empresa, OpcoesContabeis opcoesContabeis, List<IntegComuProdSubEspecie> listSubEspecie, List<IntegComuProdEspecie> listEspecie) {
        Criteria c = this.criteria();
        c.createAlias("itemComunicadoProducao", "i");
        c.createAlias("i.produto", "p");
        c.createAlias("integComProdItemComunicadoProd", "gg", Criteria.LEFT_JOIN);
        if (!TMethods.isEquals((Object)opcoesContabeis.getOpcoesContabeisComProdReq().getTipoContabComunicado(), (Object)EnumConstOpContabeisTipoContComunicado.CONTABILIZAR_CUSTO_ITEM.getValue())) {
            c.add(Restrictions.between((String)"dataEntradaSaida", (Object)dataInicial, (Object)dataFinal));
        } else {
            c.createAlias("i.itemComposicaoCusto", "icc");
            c.add(Restrictions.between((String)"icc.dataReferencia", (Object)dataInicial, (Object)dataFinal));
        }
        c.add((Criterion)Restrictions.eq((String)"empresa", (Object)empresa));
        c.add(Restrictions.isNull((String)"gg.identificador"));
        Disjunction subDis = Restrictions.or((Criterion[])new Criterion[0]);
        for (IntegComuProdSubEspecie subEspecie : listSubEspecie) {
            subDis.add((Criterion)Restrictions.eq((String)"p.subEspecie", (Object)subEspecie.getSubEspecie()));
        }
        c.add((Criterion)subDis);
        Disjunction espDis = Restrictions.or((Criterion[])new Criterion[0]);
        for (IntegComuProdEspecie especie : listEspecie) {
            espDis.add((Criterion)Restrictions.eq((String)"p.especie", (Object)especie.getEspecie()));
        }
        c.add((Criterion)espDis);
        c.setResultTransformer(Criteria.DISTINCT_ROOT_ENTITY);
        return c.list();
    }

    public List<DTORastreioLoteFabricacao> rastreioLoteComunicadoProducao(Date dataInicial, Date dataFinal, List lotes, Long produtoInicial, Long produtoFinal) {
        Criteria c = this.criteria();
        c.createAlias("itemComunicadoProducao", "i");
        c.createAlias("i.gradeItemComunicadoProducao", "g");
        c.createAlias("g.loteFabricacao", "lf");
        c.createAlias("g.gradeCor", "gc");
        c.createAlias("gc.produtoGrade", "pg");
        c.createAlias("pg.produto", "p");
        c.createAlias("gc.cor", "cor");
        ProjectionList select = Projections.projectionList();
        select.add((Projection)Projections.property((String)"identificador"), "identificador");
        select.add((Projection)Projections.property((String)"dataEntradaSaida"), "dataEntradaSaida");
        select.add((Projection)Projections.property((String)"dataCadastro"), "dataCadastro");
        select.add((Projection)Projections.property((String)"g.quantidade"), "quantidade");
        select.add((Projection)Projections.property((String)"lf.loteFabricacao"), "loteFabricacao");
        select.add((Projection)Projections.property((String)"p.identificador"), "produtoIdentificador");
        select.add((Projection)Projections.property((String)"p.nome"), "produto");
        select.add((Projection)Projections.property((String)"cor.nome"), "cor");
        c.setProjection((Projection)select);
        c.add(this.in("lf.identificador", lotes));
        if (dataInicial != null) {
            c.add(this.greatherEqual("dataEntradaSaida", dataInicial));
        }
        if (dataFinal != null) {
            c.add(this.lessEqual("dataEntradaSaida", dataFinal));
        }
        if (produtoInicial != null) {
            c.add(this.greatherEqual("p.identificador", produtoInicial));
        }
        if (produtoFinal != null) {
            c.add(this.lessEqual("p.identificador", produtoFinal));
        }
        c.setResultTransformer((ResultTransformer)new AliasToBeanResultTransformer(DTORastreioLoteFabricacao.class));
        return c.list();
    }

    public List<Long> getComunicadosProducaoPorPeriodo(Date dataIn, Date dataFim, Empresa empresa, int firstReg, int maxreg) {
        Criteria c = this.restrictions(this.between("dataFinal", dataIn, dataFim), this.eq("empresa", empresa));
        c.setFirstResult(firstReg);
        c.setMaxResults(maxreg);
        c.setProjection((Projection)Projections.property((String)"identificador"));
        return c.list();
    }
}

