/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.dao.impl;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.constants.enums.tipopagamentonfe.EnumConstTipoPagamentoNFe;
import com.touchcomp.basementor.model.vo.CondicoesPagamento;
import com.touchcomp.basementorservice.dao.DaoGenericEntityImpl;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.criterion.Criterion;
import org.hibernate.criterion.Restrictions;
import org.springframework.stereotype.Repository;

@Repository
public class DaoCondicoesPagamentoImpl
extends DaoGenericEntityImpl<CondicoesPagamento, Long> {
    public List<CondicoesPagamento> getCondicoesPagamentoSaida() {
        Criteria c = this.criteria();
        this.restrictions(c, new Criterion[]{Restrictions.eq((String)"tipoCondSaida", (Object)EnumConstantsMentorSimNao.SIM.value)});
        this.restrictions(c, new Criterion[]{Restrictions.eq((String)"ativo", (Object)EnumConstantsMentorSimNao.SIM.value)});
        this.order(c, "nome");
        return this.toList(c);
    }

    public List<CondicoesPagamento> getCondicoesPagamentoEntrada() {
        Criteria c = this.criteria();
        this.restrictions(c, new Criterion[]{Restrictions.eq((String)"tipoCondEntrada", (Object)EnumConstantsMentorSimNao.SIM.value)});
        this.restrictions(c, new Criterion[]{Restrictions.eq((String)"ativo", (Object)EnumConstantsMentorSimNao.SIM.value)});
        this.order(c, "nome");
        return this.toList(c);
    }

    public List<CondicoesPagamento> getCondicoesSemPagDev() {
        Criteria c = this.criteria();
        c.createAlias("meioPagamento", "m");
        c.createAlias("m.tipoPagamentoNFe", "t");
        this.restrictions(c, new Criterion[]{Restrictions.eq((String)"ativo", (Object)EnumConstantsMentorSimNao.SIM.value)});
        this.restrictions(c, new Criterion[]{Restrictions.eq((String)"t.codigo", (Object)EnumConstTipoPagamentoNFe.SEM_PAGAMENTO.getValue())});
        this.order(c, "nome");
        return this.toList(c);
    }

    public List<CondicoesPagamento> getCondicaoPagamentoMutante() {
        Criteria c = this.criteria();
        this.restrictions(c, new Criterion[]{Restrictions.eq((String)"condMutante", (Object)EnumConstantsMentorSimNao.SIM.getValue())});
        this.restrictions(c, new Criterion[]{Restrictions.eq((String)"tipoCondEntrada", (Object)EnumConstantsMentorSimNao.SIM.getValue())});
        this.order(c, "nome");
        return this.toList(c);
    }

    public List<CondicoesPagamento> getCondicaoPagMutanteSemFixo() {
        Criteria c = this.criteria();
        this.restrictions(c, new Criterion[]{Restrictions.eq((String)"condMutante", (Object)EnumConstantsMentorSimNao.SIM.getValue())});
        this.restrictions(c, new Criterion[]{Restrictions.eq((String)"tipoCondEntrada", (Object)EnumConstantsMentorSimNao.SIM.getValue())});
        this.restrictions(c, new Criterion[]{Restrictions.eq((String)"mutanteFixa", (Object)EnumConstantsMentorSimNao.NAO.getValue())});
        this.order(c, "nome");
        return this.toList(c);
    }

    public CondicoesPagamento getCondicoesPagamentoByCodSincronizacao(String codigo) {
        Criteria c = this.criteria();
        this.restrictions(c, new Criterion[]{Restrictions.eq((String)"codigoSincronizacao", (Object)codigo)});
        c.setMaxResults(1);
        return (CondicoesPagamento)this.toUnique(c);
    }
}

