/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.dao.impl;

import com.touchcomp.basementor.constants.enums.notasfiscais.EnumConstStatLancNFTerceiros;
import com.touchcomp.basementor.model.vo.ConsultaCTeDestDocs;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementorservice.dao.DaoGenericEntityImpl;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.methods.TMethods;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.util.Date;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.criterion.Order;
import org.hibernate.sql.JoinType;
import org.springframework.stereotype.Repository;

@Repository
public class DaoConsultaCTeDestDocsImpl
extends DaoGenericEntityImpl<ConsultaCTeDestDocs, Long> {
    public ConsultaCTeDestDocs getByChave(String chave) {
        return (ConsultaCTeDestDocs)this.toUnique(this.restrictions(this.eq("chave", chave)));
    }

    public List<ConsultaCTeDestDocs> getUltimosDocsConsultados(Integer maxRegs, int page, Empresa empresa) {
        Criteria crit = this.criteria();
        crit.add(this.eq("cnpjTomador", empresa.getPessoa().getComplemento().getCnpj()));
        crit.setMaxResults(maxRegs.intValue());
        crit.setFirstResult(page);
        crit.addOrder(Order.desc((String)"dataEmissao"));
        return crit.list();
    }

    public List<ConsultaCTeDestDocs> getDocs(Short filtrarData, Date dataInicial, Date dataFinal, Short filtrarParceiro, String parceiro, Short filtrarStatus, EnumConstStatLancNFTerceiros statusManifesto, Short filtrarChave, String chaveConsulta, Integer maxRegs, int page, Empresa empresa) {
        Criteria crit = this.criteria();
        crit.setMaxResults(maxRegs.intValue());
        crit.setFirstResult(page);
        crit.add(this.eq("cnpjTomador", empresa.getPessoa().getComplemento().getCnpj()));
        if (ToolMethods.isEquals((Object)filtrarData, (Object)1)) {
            crit.add(this.between("dataEmissao", ToolDate.dataSemHora((Date)dataInicial), ToolDate.getLastDateOnDay((Date)dataFinal)));
        }
        if (ToolMethods.isEquals((Object)filtrarParceiro, (Object)1)) {
            crit.add(this.ilike("nome", parceiro));
        }
        if (ToolMethods.isEquals((Object)filtrarStatus, (Object)1)) {
            crit.add(this.eq("statusSistema", statusManifesto.getValue()));
        }
        if (ToolMethods.isEquals((Object)filtrarChave, (Object)1)) {
            crit.add(this.eq("chave", chaveConsulta));
        }
        crit.addOrder(Order.desc((String)"dataEmissao"));
        return crit.list();
    }

    public List<ConsultaCTeDestDocs> getDocsAguardandoLancNFTerceiros(Short filtrarData, Date dataInicial, Date dataFinal, Short filtrarParceiro, Pessoa pessoa, EnumConstStatLancNFTerceiros statusManifesto, Short filtrarChave, String chaveConsulta, int maxRegs, int page, Empresa empresa, Short filtrarSerieNr, String serie, Long numero) {
        Criteria crit = this.criteria();
        crit.createAlias("notaFiscalTerceiros", "n", JoinType.LEFT_OUTER_JOIN);
        crit.createAlias("consultaCTeDest", "c", JoinType.INNER_JOIN);
        crit.setMaxResults(maxRegs);
        crit.setFirstResult(page);
        if (ToolMethods.isEquals((Object)filtrarData, (Object)1)) {
            crit.add(this.between("dataEmissao", ToolDate.dataSemHora((Date)dataInicial), ToolDate.getLastDateOnDay((Date)dataFinal)));
        }
        if (ToolMethods.isEquals((Object)filtrarParceiro, (Object)1)) {
            crit.add(this.eq("cnpjEmitente", pessoa.getComplemento().getCnpj()));
        }
        if (ToolMethods.isEquals((Object)filtrarSerieNr, (Object)1)) {
            if (TMethods.isStrWithData((String)serie)) {
                crit.add(this.eq("serieDoc", serie));
            }
            crit.add(this.eq("numeroDoc", numero));
        }
        crit.add(this.isNull("n.identificador"));
        crit.add(this.eq("statusSistema", statusManifesto.getValue()));
        crit.add(this.eq("c.empresa", empresa));
        if (ToolMethods.isEquals((Object)filtrarChave, (Object)1)) {
            crit.add(this.eq("chave", chaveConsulta));
        }
        crit.addOrder(Order.desc((String)"dataEmissao"));
        return crit.list();
    }
}

