/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.dao.impl;

import com.touchcomp.basementor.constants.enums.notasfiscais.EnumConstStatLancNFTerceiros;
import com.touchcomp.basementor.model.vo.ConsultaNFSeDestDocsDist;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementorservice.dao.DaoGenericEntityImpl;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.util.Date;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.criterion.Order;
import org.springframework.stereotype.Repository;

@Repository
public class DaoConsultaNFSeDestDocsDistImpl
extends DaoGenericEntityImpl<ConsultaNFSeDestDocsDist, Long> {
    public ConsultaNFSeDestDocsDist getByChave(String chave) {
        return (ConsultaNFSeDestDocsDist)this.toUnique(this.restrictions(this.eq("chave", chave)));
    }

    public List<ConsultaNFSeDestDocsDist> getUltimosDocsConsultados(Integer maxRegs, int page, Empresa empresa) {
        Criteria crit = this.criteria();
        crit.add(this.eq("cnpjDestinatarioTomador", empresa.getPessoa().getComplemento().getCnpj()));
        crit.setMaxResults(maxRegs.intValue());
        crit.setFirstResult(page);
        crit.addOrder(Order.desc((String)"dataEmissaoDPS"));
        return crit.list();
    }

    public List<ConsultaNFSeDestDocsDist> getDocs(Short filtrarData, Date dataInicial, Date dataFinal, Short filtrarParceiro, String parceiro, Short filtrarStatus, EnumConstStatLancNFTerceiros statusManifesto, Short filtrarChave, String chaveConsulta, Integer maxRegs, int page, Empresa empresa) {
        Criteria crit = this.criteria();
        crit.setMaxResults(maxRegs.intValue());
        crit.setFirstResult(page);
        crit.add(this.eq("cnpjDestinatarioTomador", empresa.getPessoa().getComplemento().getCnpj()));
        if (ToolMethods.isEquals((Object)filtrarData, (Object)1)) {
            crit.add(this.between("dataEmissaoDPS", ToolDate.dataSemHora((Date)dataInicial), ToolDate.getLastDateOnDay((Date)dataFinal)));
        }
        if (ToolMethods.isEquals((Object)filtrarParceiro, (Object)1)) {
            crit.add(this.ilike("nome", parceiro));
        }
        if (ToolMethods.isEquals((Object)filtrarStatus, (Object)1)) {
            crit.add(this.eq("statusSistema", statusManifesto.getValue()));
        }
        if (ToolMethods.isEquals((Object)filtrarChave, (Object)1)) {
            crit.add(this.eq("chave", chaveConsulta));
        }
        crit.addOrder(Order.desc((String)"dataProcessamento"));
        return crit.list();
    }
}

