/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.dao.impl;

import com.touchcomp.basementor.constants.enums.cte.EnumConstCTeStatus;
import com.touchcomp.basementor.constants.enums.naturezaoperacao.EnumConstNatOpEntSaidaFaturamento;
import com.touchcomp.basementor.constants.enums.notasfiscais.EnumConstStatLancNFTerceiros;
import com.touchcomp.basementor.constants.enums.ordemcompra.EnumConstOrdemCompraStatus;
import com.touchcomp.basementor.model.vo.ConsultaNFeDestDocsDist;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.NotaFiscalTerceiros;
import com.touchcomp.basementorservice.dao.DaoGenericEntityImpl;
import com.touchcomp.basementortools.tools.date.TDate;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.util.Date;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.hibernate.criterion.Order;
import org.hibernate.sql.JoinType;
import org.springframework.stereotype.Repository;

@Repository
public class DaoConsultaNFeDestDocsDistImpl
extends DaoGenericEntityImpl<ConsultaNFeDestDocsDist, Long> {
    public ConsultaNFeDestDocsDist getByChave(String chave) {
        return (ConsultaNFeDestDocsDist)this.toUnique(this.restrictions(this.eq("chave", chave)));
    }

    public List<ConsultaNFeDestDocsDist> getAllDocsEfetuarCiencia(Date dataIn, Empresa empresa, Integer page, Integer maxRegsPerTime) {
        org.hibernate.query.Query q = this.query("select c from ConsultaNFeDestDocsDist c where c.empresa=:empresa  and c.statusSistema=:status_ciencia_auto and c.dataEmissao>:dataInicial order by c.dataEmissao desc");
        q.setShort("status_ciencia_auto", EnumConstStatLancNFTerceiros.STAT_INICIAL_DOWNLOAD_RESUMIDO.getValue());
        q.setEntity("empresa", (Object)empresa);
        q.setDate("dataInicial", dataIn);
        q.setMaxResults(maxRegsPerTime.intValue());
        q.setFirstResult(page.intValue());
        return q.list();
    }

    public List<ConsultaNFeDestDocsDist> getDocsCienciaFornCadastrados(Date dataIn, Empresa empresa, Integer page, Integer maxRegsPerTime) {
        org.hibernate.query.Query q = this.query("select c from ConsultaNFeDestDocsDist c inner join c.unidadeFatFornecedor u  inner join u.fornecedor f inner join u.pessoa p inner join p.complemento cl  where c.empresa=:empresa  and cl.cnpj=c.cnpjEmitente and c.statusSistema=:status_ciencia_auto and p.ativo =:ativo and f.ativo =:ativo and c.dataEmissao>:dataInicial order by c.dataEmissao desc");
        q.setShort("status_ciencia_auto", EnumConstStatLancNFTerceiros.STAT_INICIAL_DOWNLOAD_RESUMIDO.getValue());
        q.setShort("ativo", (short)1);
        q.setEntity("empresa", (Object)empresa);
        q.setDate("dataInicial", dataIn);
        q.setMaxResults(maxRegsPerTime.intValue());
        q.setFirstResult(page.intValue());
        return this.toList((Query)q);
    }

    public List<ConsultaNFeDestDocsDist> getDocsCienciaOCAbertas(Date dataIn, Empresa empresa, Integer page, Integer maxRegsPerTime) {
        org.hibernate.query.Query q = this.query("select c from ConsultaNFeDestDocsDist c inner join c.unidadeFatFornecedor u  inner join OrdemCompra oc on (u=oc.unidadeFatFornecedor) inner join oc.statusOrdemCompra s inner join u.pessoa p inner join p.complemento cl  where c.empresa=:empresa  and cl.cnpj=c.cnpjEmitente and c.statusSistema=:status_ciencia_auto and s.status=:aberto and c.dataEmissao>:dataInicial order by c.dataEmissao desc");
        q.setShort("status_ciencia_auto", EnumConstStatLancNFTerceiros.STAT_INICIAL_DOWNLOAD_RESUMIDO.getValue());
        q.setShort("aberto", EnumConstOrdemCompraStatus.ABERTO.getValue());
        q.setEntity("empresa", (Object)empresa);
        q.setDate("dataInicial", dataIn);
        q.setMaxResults(maxRegsPerTime.intValue());
        q.setFirstResult(page.intValue());
        return this.toList((Query)q);
    }

    public List<ConsultaNFeDestDocsDist> getDocsAgDownloadXML(Empresa empresa, Integer delayAposCiencia, Integer regsPerTime, Integer page) {
        org.hibernate.query.Query q = this.query("select c from ConsultaNFeDestDocsDist c where c.empresa=:empresa  and (c.statusSistema=:status_ciencia_auto) and (c.idRegXMLTerc is null or c.idRegXMLTerc<=0) order by c.dataEmissao desc");
        q.setShort("status_ciencia_auto", EnumConstStatLancNFTerceiros.STAT_INTER_CIENCIA_OPERACAO.getValue());
        q.setEntity("empresa", (Object)empresa);
        q.setMaxResults(regsPerTime.intValue());
        q.setFirstResult(page.intValue());
        List<ConsultaNFeDestDocsDist> aux = this.toList((Query)q);
        return aux;
    }

    public List<ConsultaNFeDestDocsDist> getUltimosDocsConsultados(Integer maxRegs, Integer page, Empresa empresa) {
        Criteria crit = this.criteria();
        crit.add(this.eq("empresa", empresa));
        crit.setMaxResults(maxRegs.intValue());
        crit.setFirstResult(page * maxRegs);
        crit.addOrder(Order.desc((String)"dataEmissao"));
        return crit.list();
    }

    public List<ConsultaNFeDestDocsDist> getDocs(Short filtrarData, Date dataInicial, Date dataFinal, Short filtrarParceiro, String parceiro, Short filtrarStatus, EnumConstStatLancNFTerceiros statusManifesto, Short filtrarChave, String chaveConsulta, Empresa empresa, Integer maxRegs, int page) {
        Criteria crit = this.criteria();
        crit.setMaxResults(maxRegs.intValue());
        crit.setFirstResult(page);
        crit.add(this.eq("empresa", empresa));
        if (ToolMethods.isEquals((Object)filtrarData, (Object)1)) {
            crit.add(this.between("dataEmissao", ToolDate.dataSemHora((Date)dataInicial), ToolDate.getLastDateOnDay((Date)dataFinal)));
        }
        if (ToolMethods.isEquals((Object)filtrarParceiro, (Object)1)) {
            crit.add(this.ilike("nome", parceiro));
        }
        if (ToolMethods.isEquals((Object)filtrarStatus, (Object)1)) {
            crit.add(this.eq("statusSistema", statusManifesto.getEnumId()));
        }
        if (ToolMethods.isEquals((Object)filtrarChave, (Object)1)) {
            crit.add(this.eq("chave", chaveConsulta));
        }
        crit.addOrder(Order.desc((String)"dataEmissao"));
        return crit.list();
    }

    public List<ConsultaNFeDestDocsDist> getDocsSemNFTerceiros(String cnpjTomador, Short filtrarData, Date dataInicial, Date dataFinal, Short filtrarParceiro, String cpfCnpjParceiro, Short filtrarStatus, EnumConstStatLancNFTerceiros statusManifesto, Short filtrarChave, String chaveConsulta, Integer maxRegs, int page) {
        Criteria crit = this.criteria();
        crit.createAlias("notaFiscalTerceiros", "nf", JoinType.LEFT_OUTER_JOIN);
        crit.setMaxResults(maxRegs.intValue());
        crit.setFirstResult(page);
        crit.add(this.eq("cnpjDestinatarioTomador", cnpjTomador));
        if (ToolMethods.isEquals((Object)filtrarData, (Object)1)) {
            crit.add(this.between("dataEmissao", dataInicial, TDate.getLastDateOnDay((Date)dataFinal)));
        }
        if (ToolMethods.isEquals((Object)filtrarParceiro, (Object)1)) {
            crit.add(this.eq("cnpjEmitente", cpfCnpjParceiro));
        }
        if (ToolMethods.isEquals((Object)filtrarStatus, (Object)1)) {
            crit.add(this.eq("statusSistema", statusManifesto.getValue()));
        }
        if (ToolMethods.isEquals((Object)filtrarChave, (Object)1)) {
            crit.add(this.eq("chave", chaveConsulta));
        }
        crit.add(this.eq("statusSefaz", EnumConstCTeStatus.AUTORIZADO.getValueShort()));
        crit.add(this.eq("tipoFatEntSaida", EnumConstNatOpEntSaidaFaturamento.ENT_SAI_FATURAMENTO_SAIDA.getValue()));
        crit.add(this.isNull("nf.identificador"));
        crit.addOrder(Order.desc((String)"dataEmissao"));
        return crit.list();
    }

    public ConsultaNFeDestDocsDist getByNotaTerceiros(NotaFiscalTerceiros notaFiscalTerceiros) {
        return (ConsultaNFeDestDocsDist)this.toUnique(this.restrictions(this.eq("notaFiscalTerceiros", notaFiscalTerceiros)));
    }

    public List<ConsultaNFeDestDocsDist> getDocsAgDownloadXML(Empresa empresa, List<String> chavesNotas) {
        org.hibernate.query.Query q = this.query("select c from ConsultaNFeDestDocsDist c where c.empresa=:empresa  and c.chave in(:chaves) and (c.idRegXMLTerc is null or c.idRegXMLTerc<=0)");
        q.setEntity("empresa", (Object)empresa);
        q.setParameterList("chaves", chavesNotas);
        List<ConsultaNFeDestDocsDist> aux = this.toList((Query)q);
        return aux;
    }
}

