/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.dao.impl;

import com.touchcomp.basementor.constants.enums.eventonfe.NFeConstStatusEventoNFe;
import com.touchcomp.basementor.model.vo.ConsultaNFeDestNFe;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.EvtNFeManifestoDest;
import com.touchcomp.basementorservice.dao.DaoGenericEntityImpl;
import com.touchcomp.basementortools.tools.date.ToolDate;
import com.touchcomp.basementortools.tools.methods.ToolMethods;
import java.util.ArrayList;
import java.util.Date;
import java.util.List;
import org.hibernate.Query;
import org.springframework.stereotype.Repository;

@Repository
public class DaoConsultaNFeDestNFeImpl
extends DaoGenericEntityImpl<ConsultaNFeDestNFe, Long> {
    public List<ConsultaNFeDestNFe> getNFeConsultadasSemManifesto(Empresa empresa, Date dataInicial, Date dataFinal) {
        org.hibernate.query.Query q = this.query("select c  from ConsultaNFeDestNFe c  where c.consultaNFeDestNFeAut.consultaNFeDest.empresa = :empresa and cast(c.consultaNFeDestNFeAut.consultaNFeDest.dataConsulta as date) between :dataInicial and :dataFinal and c.inativo = :nao");
        q.setDate("dataInicial", dataInicial);
        q.setDate("dataFinal", dataFinal);
        q.setEntity("empresa", (Object)empresa);
        q.setShort("nao", (short)0);
        List<ConsultaNFeDestNFe> consultas = this.toList((Query)q);
        consultas = this.getConsultasNaoCanceladasDenegadas(consultas);
        Date dataIn = null;
        Date dataFim = null;
        for (ConsultaNFeDestNFe consulta : consultas) {
            String dataConsulta = consulta.getDataEmissao();
            Date data = ToolDate.strToDate((String)dataConsulta, (String)"yyyy-MM-dd");
            if (dataIn == null || data.before(dataIn)) {
                dataIn = data;
            }
            if (dataFim != null && !data.after(dataFim)) continue;
            dataFim = data;
        }
        List<String> chavesNFe = this.getChavesNFePeriodo(dataIn, dataFim, empresa);
        ArrayList<ConsultaNFeDestNFe> novasConsultas = new ArrayList<ConsultaNFeDestNFe>();
        for (ConsultaNFeDestNFe c : consultas) {
            String chave = c.getChNFe();
            Boolean achou = false;
            for (String chaveNFe : chavesNFe) {
                if (!ToolMethods.isEquals((Object)chave, (Object)chaveNFe)) continue;
                achou = true;
                break;
            }
            if (achou.booleanValue()) continue;
            novasConsultas.add(c);
        }
        return novasConsultas;
    }

    private List<String> getChavesNFePeriodo(Date dataIn, Date dataFim, Empresa empresa) {
        org.hibernate.query.Query q = this.query("select n.chaveNFE  from NotaFiscalTerceiros n  where n.empresa = :empresa and n.dataEntrada between :dataInicial and :dataFinal and n.modeloDocFiscal.codigo = :codigo");
        q.setDate("dataInicial", dataIn);
        q.setDate("dataFinal", dataFim);
        q.setEntity("empresa", (Object)empresa);
        q.setString("codigo", "55");
        List chaves = q.list();
        return chaves;
    }

    private List<ConsultaNFeDestNFe> getConsultasNaoCanceladasDenegadas(List<ConsultaNFeDestNFe> consultas) {
        ArrayList<ConsultaNFeDestNFe> consultasNew = new ArrayList<ConsultaNFeDestNFe>();
        for (ConsultaNFeDestNFe consulta : consultas) {
            Boolean achou = false;
            for (EvtNFeManifestoDest e : consulta.getEventoNfeManifesto()) {
                if (!ToolMethods.isEquals((Object)e.getStatus(), (Object)NFeConstStatusEventoNFe.EVENTO_CIENCIA_NFE_REJ_EVT_SOB_NF_CANC_DENEGADA.getCodigo().shortValue())) continue;
                achou = true;
            }
            if (achou.booleanValue()) continue;
            consultasNew.add(consulta);
        }
        return consultasNew;
    }
}

