/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.dao.impl;

import com.touchcomp.basementor.model.vo.ConsumoAtivo;
import com.touchcomp.basementor.model.vo.Equipamento;
import com.touchcomp.basementorservice.dao.DaoGenericEntityImpl;
import java.util.Date;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.Query;
import org.springframework.stereotype.Repository;

@Repository
public class DaoConsumoAtivoImpl
extends DaoGenericEntityImpl<ConsumoAtivo, Long> {
    public Double getHodometroAnterior(String placa, Date dataConsumo, Long idConsumoAtual) {
        idConsumoAtual = idConsumoAtual == null ? 0L : idConsumoAtual;
        org.hibernate.query.Query q = this.query("SELECT c.hodometro FROM ConsumoAtivo c WHERE c.dataConsumo = (SELECT MAX(a.dataConsumo) FROM ConsumoAtivo a WHERE a.equipamento = c.equipamento and a.dataConsumo<=:dataConsumo and a.identificador<>:idConsumoAtual) and c.equipamento.veiculo.placa = :placa and c.identificador<>:idConsumoAtual order by c.identificador desc");
        q.setString("placa", placa.toUpperCase());
        q.setDate("dataConsumo", dataConsumo);
        q.setLong("idConsumoAtual", idConsumoAtual.longValue());
        q.setMaxResults(1);
        Double ret = (Double)q.uniqueResult();
        return ret != null ? ret : 0.0;
    }

    public boolean existeConsumoAtivoCodigoCtf(String codigoCtf) {
        Criteria crit = this.criteria();
        this.restrictions(crit, this.eq("codigoCTF", codigoCtf));
        return this.toRowCount(crit) > 0L;
    }

    public ConsumoAtivo getConsumoAtivoCtf(String codigoCtf) {
        Criteria crit = this.criteria();
        this.restrictions(crit, this.eq("codigoCTF", codigoCtf));
        return (ConsumoAtivo)this.toUnique(crit);
    }

    public List<ConsumoAtivo> getConsumoAtivoDataConsumoAtivo(Date dataConsumo, Equipamento ativo) {
        org.hibernate.query.Query q = this.query("SELECT c FROM ConsumoAtivo c WHERE c.dataConsumo >= :dataConsumo AND c.equipamento = :ativo ORDER BY c.dataConsumo");
        q.setDate("dataConsumo", dataConsumo);
        q.setEntity("ativo", (Object)ativo);
        return this.toList((Query)q);
    }
}

