/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.dao.impl;

import com.touchcomp.basementor.model.vo.Cliente;
import com.touchcomp.basementor.model.vo.Cooperado;
import com.touchcomp.basementor.model.vo.Pessoa;
import com.touchcomp.basementorservice.dao.DaoGenericEntityImpl;
import java.util.List;
import org.hibernate.Query;
import org.springframework.stereotype.Repository;

@Repository
public class DaoCooperadoImpl
extends DaoGenericEntityImpl<Cooperado, Long> {
    public Cooperado findCooperadoPorCliente(Cliente cliente) {
        String query = "from Cooperado c where c.cliente = :cliente";
        org.hibernate.query.Query q = this.query(query);
        q.setEntity("cliente", (Object)cliente);
        q.setMaxResults(1);
        return (Cooperado)q.uniqueResult();
    }

    public Cooperado findCooperadoPorCodigoCliente(String codCliente) {
        String query = "from Cooperado c  where c.cliente.codigoCliente = :codCliente and c.cliente.ativo = :ativo";
        org.hibernate.query.Query q = this.query(query);
        q.setString("codCliente", codCliente);
        q.setShort("ativo", (short)1);
        q.setMaxResults(1);
        return (Cooperado)q.uniqueResult();
    }

    public Cooperado findCooperadoPorCodigo(String codCooperado) {
        String query = "from Cooperado c  where c.codigoCooperado = :codCooperado and c.cliente.ativo = :ativo";
        org.hibernate.query.Query q = this.query(query);
        q.setString("codCooperado", codCooperado);
        q.setShort("ativo", (short)1);
        q.setMaxResults(1);
        return (Cooperado)q.uniqueResult();
    }

    public List<Cooperado> findCooperadosAtivos() {
        String query = "Select c  from Cooperado c where c.ativo = 1";
        org.hibernate.query.Query q = this.query(query);
        return q.list();
    }

    public Cooperado findCooperado(Pessoa pessoa) {
        String query = "Select c\nfrom Cooperado c\nwhere c.ativo = 1\nand c.cliente.pessoa=:pessoa";
        org.hibernate.query.Query q = this.query(query);
        q.setParameter("pessoa", (Object)pessoa);
        return (Cooperado)this.toUnique((Query)q);
    }
}

