/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.dao.impl;

import com.touchcomp.basementor.constants.enums.EnumConstantsMentorSimNao;
import com.touchcomp.basementor.model.vo.CotacaoCompra;
import com.touchcomp.basementor.model.vo.Empresa;
import com.touchcomp.basementor.model.vo.SituacaoCotacaoCompra;
import com.touchcomp.basementorservice.dao.DaoGenericEntityImpl;
import java.util.Date;
import java.util.List;
import org.hibernate.Criteria;
import org.hibernate.criterion.Projection;
import org.hibernate.criterion.Projections;
import org.springframework.stereotype.Repository;

@Repository
public class DaoCotacaoCompraImpl
extends DaoGenericEntityImpl<CotacaoCompra, Long> {
    public List<CotacaoCompra> get(EnumConstantsMentorSimNao filtrarDatas, Date dataIn, Date dataFinal, SituacaoCotacaoCompra situacaoCotacaoCompra, Empresa empresa) {
        Criteria c = this.criteria();
        if (filtrarDatas.equals((Object)EnumConstantsMentorSimNao.SIM)) {
            c.add(this.between("dataCotacaoCompra", dataIn, dataFinal));
        }
        if (situacaoCotacaoCompra != null) {
            c.add(this.eq("situacaoCotacaoCompra", situacaoCotacaoCompra));
        } else {
            c.add(this.isNull("situacaoCotacaoCompra"));
        }
        c.add(this.eq("empresa", empresa));
        return c.list();
    }

    public List<CotacaoCompra> get(Empresa emp, SituacaoCotacaoCompra situacaoCotacaoCompra) {
        Criteria c = this.criteria();
        c.add(this.eq("situacaoCotacaoCompra", situacaoCotacaoCompra));
        c.add(this.eq("empresa", emp));
        c.add(this.eq("fechada", (short)0));
        return c.list();
    }

    public List<CotacaoCompra> getCotacoesVencidas(Empresa emp, Date date, SituacaoCotacaoCompra situacaoLibFornecedor, SituacaoCotacaoCompra situacaoEnvEmailForn) {
        Criteria c = this.criteria();
        c.add(this.or(this.eq("situacaoCotacaoCompra", situacaoLibFornecedor), this.eq("situacaoCotacaoCompra", situacaoEnvEmailForn)));
        c.add(this.eq("empresa", emp));
        c.add(this.lessEqual("dataPrevFinalizacao", date));
        return c.list();
    }

    public Short getStatusCotacao(Long identificador) {
        Criteria c = this.criteria();
        c.setProjection((Projection)Projections.property((String)"fechada"));
        c.add(this.eq("identificador", identificador));
        return (Short)c.uniqueResult();
    }
}

