/*
 * Decompiled with CFR 0.152.
 */
package com.touchcomp.basementorservice.dao.impl;

import com.touchcomp.basementor.model.vo.CotacaoMoeda;
import com.touchcomp.basementor.model.vo.Moeda;
import com.touchcomp.basementorservice.dao.DaoGenericEntityImpl;
import java.util.Date;
import java.util.List;
import org.hibernate.query.Query;
import org.springframework.stereotype.Repository;

@Repository
public class DaoCotacaoMoedaImpl
extends DaoGenericEntityImpl<CotacaoMoeda, Long> {
    public Double getValorUltimaCotacaoMoeda(Long idMoeda) {
        Query q = this.query(" select c.valor from CotacaoMoeda c inner join c.moeda m where m.identificador =:idMoeda order by c.dataCotacao desc");
        q.setLong("idMoeda", idMoeda.longValue());
        q.setMaxResults(1);
        return (Double)q.uniqueResult();
    }

    public CotacaoMoeda getUltimaCotacaoMoeda(Long idMoeda) {
        Query q = this.query(" select c from CotacaoMoeda c inner join c.moeda m where m.identificador =:idMoeda order by c.dataCotacao desc");
        q.setLong("idMoeda", idMoeda.longValue());
        q.setMaxResults(1);
        return (CotacaoMoeda)q.uniqueResult();
    }

    @Override
    public List<CotacaoMoeda> get(Moeda moeda) {
        Query q = this.query("select c  from CotacaoMoeda c  where c.moeda = :moeda");
        q.setEntity("moeda", (Object)moeda);
        return q.list();
    }

    public Boolean getMoedaPreferencial(Moeda moeda) {
        Query q = this.query("select c  from CotacaoMoeda c inner join c.moeda m  where m = :moeda  and m.preferencial = :sim");
        q.setEntity("moeda", (Object)moeda);
        q.setShort("sim", (short)1);
        List aux = q.list();
        if (aux != null && !aux.isEmpty()) {
            return false;
        }
        return true;
    }

    public CotacaoMoeda get(Moeda moeda, Date date) {
        Query q = this.query("select c  from CotacaoMoeda c inner join c.moeda m  where m = :moeda  and c.dataCotacao = :data");
        q.setEntity("moeda", (Object)moeda);
        q.setDate("data", date);
        q.setMaxResults(1);
        return (CotacaoMoeda)q.uniqueResult();
    }
}

